/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.function.complex;

import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.ops.function.Function;
import net.imglib2.ops.function.complex.ComplexImageFunction;
import net.imglib2.ops.operation.complex.binary.ComplexAdd;
import net.imglib2.ops.operation.complex.binary.ComplexMultiply;
import net.imglib2.ops.operation.complex.unary.ComplexExp;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.complex.ComplexDoubleType;

@Deprecated
public class DFTFunction<T extends ComplexType<T>>
implements Function<long[], T> {
    private final Function<long[], T> spatialFunction;
    private final long[] span;
    private final ImgFactory<ComplexDoubleType> imgFactory;
    private final ComplexImageFunction<ComplexDoubleType, ComplexDoubleType> dataArray;
    private final ComplexAdd<T, T, T> adder;
    private final ComplexExp<T, T> exper;
    private final ComplexMultiply<T, T, T> multiplier;
    private final T MINUS_TWO_PI_I;
    private final T constant;
    private final T expVal;
    private final T funcVal;
    private final T spatialExponent;
    private ComplexDoubleType tmp;

    public DFTFunction(ImgFactory<ComplexDoubleType> factory, Function<long[], T> spatialFunction, long[] span) {
        if (span.length != 2) {
            throw new IllegalArgumentException("DFTFunction is only designed for two dimensional functions");
        }
        this.tmp = new ComplexDoubleType();
        this.adder = new ComplexAdd();
        this.exper = new ComplexExp();
        this.multiplier = new ComplexMultiply();
        this.spatialFunction = spatialFunction;
        this.span = (long[])span.clone();
        this.imgFactory = factory;
        this.MINUS_TWO_PI_I = this.createOutput();
        this.constant = this.createOutput();
        this.expVal = this.createOutput();
        this.funcVal = this.createOutput();
        this.spatialExponent = this.createOutput();
        this.MINUS_TWO_PI_I.setComplexNumber(0.0, Math.PI * -2);
        this.dataArray = this.createDataArray();
    }

    @Override
    public void compute(long[] point, T output) {
        this.dataArray.compute(point, this.tmp);
        output.setComplexNumber(this.tmp.getRealDouble(), this.tmp.getImaginaryDouble());
    }

    public DFTFunction<T> copy() {
        return new DFTFunction<T>(this.imgFactory, this.spatialFunction.copy(), (long[])this.span.clone());
    }

    @Override
    public T createOutput() {
        return (T)((ComplexType)this.spatialFunction.createOutput());
    }

    private ComplexImageFunction<ComplexDoubleType, ComplexDoubleType> createDataArray() {
        Img img = this.imgFactory.create(this.span, (Object)new ComplexDoubleType());
        RandomAccess oAccessor = img.randomAccess();
        long[] iPosition = new long[2];
        long[] oPosition = new long[2];
        T sum = this.createOutput();
        T xyTerm = this.createOutput();
        int ox = 0;
        while ((long)ox < this.span[0]) {
            oPosition[0] = ox;
            int oy = 0;
            while ((long)oy < this.span[1]) {
                oPosition[1] = oy;
                sum.setZero();
                int ix = 0;
                while ((long)ix < this.span[0]) {
                    iPosition[0] = ix;
                    int iy = 0;
                    while ((long)iy < this.span[1]) {
                        iPosition[1] = iy;
                        this.calcTermAtPoint(oPosition, iPosition, xyTerm);
                        this.adder.compute(sum, xyTerm, sum);
                        ++iy;
                    }
                    ++ix;
                }
                oAccessor.setPosition(oPosition);
                ((ComplexDoubleType)oAccessor.get()).setComplexNumber(sum.getRealDouble(), sum.getImaginaryDouble());
                ++oy;
            }
            ++ox;
        }
        return new ComplexImageFunction<ComplexDoubleType, ComplexDoubleType>(img, new ComplexDoubleType());
    }

    private void calcTermAtPoint(long[] oPosition, long[] iPosition, T xyTerm) {
        this.spatialFunction.compute(iPosition, this.funcVal);
        double val = (double)oPosition[0] * (double)iPosition[0] / (double)this.span[0];
        this.spatialExponent.setComplexNumber(val += (double)oPosition[1] * (double)iPosition[1] / (double)this.span[1], 0.0);
        this.multiplier.compute(this.MINUS_TWO_PI_I, this.spatialExponent, this.constant);
        this.exper.compute(this.constant, this.expVal);
        this.multiplier.compute(this.funcVal, this.expVal, xyTerm);
    }
}

