/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.randomaccessibleinterval.unary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.roi.RectangleRegionOfInterest;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

@Deprecated
public class LocalMaximaForDistanceMap<T extends RealType<T>>
implements UnaryOperation<RandomAccessibleInterval<T>, List<long[]>> {
    private double[] m_roiOrigin;
    private double[] m_roiExtend;
    private RectangleRegionOfInterest m_roi;
    private Cursor<T> m_roiCursor;
    private final NeighborhoodType m_neighborhood;

    public LocalMaximaForDistanceMap(NeighborhoodType neighborhood) {
        this.m_neighborhood = neighborhood;
    }

    @Override
    public List<long[]> compute(RandomAccessibleInterval<T> src, List<long[]> res) {
        int numDims = src.numDimensions();
        if (src.numDimensions() < 2) {
            throw new IllegalArgumentException("Image must have at least 2 dimensions");
        }
        if (src.numDimensions() > 3) {
            throw new IllegalArgumentException("Only three dimensions are allowed");
        }
        if (this.m_roi == null || this.m_roiOrigin.length != this.m_roi.numDimensions()) {
            this.m_roiOrigin = new double[numDims];
            this.m_roiExtend = new double[numDims];
            for (int d = 0; d < this.m_roiOrigin.length; ++d) {
                this.m_roiExtend[d] = this.m_neighborhood.getExtend();
            }
            this.m_roi = new RectangleRegionOfInterest(this.m_roiOrigin, this.m_roiExtend);
        }
        RealType val = (RealType)((RealType)Views.iterable(src).firstElement()).createVariable();
        val.setReal(0.0f);
        this.m_roiCursor = this.m_roi.getIterableIntervalOverROI((RandomAccessible)Views.extendValue(src, (Type)val)).cursor();
        ArrayList<LocalMaxima> localMax = new ArrayList<LocalMaxima>(10);
        Cursor srcCursor = Views.iterable(src).localizingCursor();
        while (srcCursor.hasNext()) {
            srcCursor.fwd();
            for (int d = 0; d < this.m_roiOrigin.length; ++d) {
                this.m_roiOrigin[d] = srcCursor.getIntPosition(d) + this.m_neighborhood.getOffset();
            }
            this.m_roi.setOrigin(this.m_roiOrigin);
            boolean add = true;
            this.m_roiCursor.reset();
            float p = ((RealType)srcCursor.get()).getRealFloat();
            if (!(p > 0.0f)) continue;
            while (this.m_roiCursor.hasNext()) {
                if (!(((RealType)this.m_roiCursor.next()).getRealFloat() > p)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            long[] pos = new long[numDims];
            for (int i = 0; i < numDims; ++i) {
                pos[i] = srcCursor.getIntPosition(i);
            }
            localMax.add(new LocalMaxima(((RealType)srcCursor.get()).getRealFloat(), pos));
        }
        LocalMaximaComparator comparator = new LocalMaximaComparator();
        Collections.sort(localMax, comparator);
        int l = localMax.size();
        for (int i = 0; i < l; ++i) {
            float r = ((LocalMaxima)localMax.get(i)).val * ((LocalMaxima)localMax.get(i)).val;
            if (!(r > 1.0f)) continue;
            for (int u = i + 1; u < l; ++u) {
                float q = 0.0f;
                for (int a = 0; a < numDims; ++a) {
                    float d = ((LocalMaxima)localMax.get(u)).pos[a] - ((LocalMaxima)localMax.get(i)).pos[a];
                    q += d * d;
                }
                if (!(q < r)) continue;
                localMax.remove(u);
                --l;
                --u;
            }
        }
        for (LocalMaxima lm : localMax) {
            res.add(lm.pos);
        }
        return res;
    }

    @Override
    public UnaryOperation<RandomAccessibleInterval<T>, List<long[]>> copy() {
        return new LocalMaximaForDistanceMap<T>(this.m_neighborhood);
    }

    private class LocalMaximaComparator
    implements Comparator<LocalMaxima> {
        private LocalMaximaComparator() {
        }

        @Override
        public int compare(LocalMaxima a, LocalMaxima b) {
            float pb;
            float pa = a.val;
            if (pa > (pb = b.val)) {
                return -1;
            }
            if (pa < pb) {
                return 1;
            }
            return 0;
        }
    }

    private class LocalMaxima {
        private final float val;
        private final long[] pos;

        public LocalMaxima(float val, long[] pos) {
            this.val = val;
            this.pos = pos;
        }
    }

    public static enum NeighborhoodType {
        EIGHT(-1, 3),
        SIXTEEN(-2, 5),
        THIRTYTWO(-3, 7);

        private int m_offset;
        private int m_extend;

        private NeighborhoodType(int offset, int extend) {
            this.m_offset = offset;
            this.m_extend = extend;
        }

        public final int getOffset() {
            return this.m_offset;
        }

        public final int getExtend() {
            return this.m_extend;
        }
    }
}

