/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.pointset;

import net.imglib2.AbstractCursor;
import net.imglib2.ops.pointset.AbstractPointSet;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.ops.pointset.PointSetIterator;
import net.imglib2.roi.RegionOfInterest;

@Deprecated
public class RoiPointSet
extends AbstractPointSet {
    private final int numD;
    private final RegionOfInterest roi;
    private final long[] origin;
    private final long[] boundMin;
    private final long[] boundMax;
    private final double[] tmpCoord;

    public RoiPointSet(RegionOfInterest roi) {
        this.roi = roi;
        this.numD = roi.numDimensions();
        this.origin = new long[this.numD];
        this.boundMin = new long[this.numD];
        this.boundMax = new long[this.numD];
        this.tmpCoord = new double[this.numD];
    }

    @Override
    public long[] getOrigin() {
        for (int i = 0; i < this.numD; ++i) {
            this.origin[i] = (long)Math.floor(this.roi.realMin(i));
        }
        return this.origin;
    }

    @Override
    public void translate(long[] delta) {
        for (int i = 0; i < this.numD; ++i) {
            this.roi.move((double)delta[i], i);
        }
        this.invalidateBounds();
    }

    @Override
    public PointSetIterator iterator() {
        return new RoiPointSetIterator();
    }

    @Override
    public int numDimensions() {
        return this.roi.numDimensions();
    }

    @Override
    protected long[] findBoundMin() {
        for (int i = 0; i < this.numD; ++i) {
            this.boundMin[i] = (long)Math.floor(this.roi.realMin(i));
        }
        return this.boundMin;
    }

    @Override
    protected long[] findBoundMax() {
        for (int i = 0; i < this.numD; ++i) {
            this.boundMax[i] = (long)Math.ceil(this.roi.realMax(i));
        }
        return this.boundMax;
    }

    @Override
    public boolean includes(long[] point) {
        for (int i = 0; i < this.numD; ++i) {
            this.tmpCoord[i] = point[i];
        }
        return this.roi.contains(this.tmpCoord);
    }

    @Override
    public long size() {
        long numElems = 0L;
        PointSetIterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            ++numElems;
        }
        return numElems;
    }

    @Override
    public PointSet copy() {
        return new RoiPointSet(this.roi);
    }

    private class RoiPointSetIterator
    extends AbstractCursor<long[]>
    implements PointSetIterator {
        private PointSetIterator iter;
        private long[] curr;
        private long[] nextCache;

        public RoiPointSetIterator() {
            super(RoiPointSet.this.roi.numDimensions());
            this.reset();
        }

        public boolean hasNext() {
            if (this.nextCache != null) {
                return true;
            }
            return this.positionToNext();
        }

        public void reset() {
            HyperVolumePointSet vol = new HyperVolumePointSet(RoiPointSet.this.findBoundMin(), RoiPointSet.this.findBoundMax());
            this.iter = vol.iterator();
            this.curr = null;
            this.nextCache = null;
        }

        public long[] get() {
            return this.curr;
        }

        public void fwd() {
            if (this.nextCache != null || this.positionToNext()) {
                if (this.curr == null) {
                    this.curr = new long[this.n];
                }
                for (int i = 0; i < this.n; ++i) {
                    this.curr[i] = this.nextCache[i];
                }
                this.nextCache = null;
                return;
            }
            throw new IllegalArgumentException("fwd() cannot go beyond end");
        }

        public void localize(long[] position) {
            for (int i = 0; i < this.n; ++i) {
                position[i] = this.curr[i];
            }
        }

        public long getLongPosition(int d) {
            return this.curr[d];
        }

        public AbstractCursor<long[]> copy() {
            return new RoiPointSetIterator();
        }

        public AbstractCursor<long[]> copyCursor() {
            return this.copy();
        }

        private boolean positionToNext() {
            this.nextCache = null;
            while (this.iter.hasNext()) {
                long[] pos = (long[])this.iter.next();
                if (!RoiPointSet.this.includes(pos)) continue;
                this.nextCache = pos;
                return true;
            }
            return false;
        }
    }
}

