/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.haralick;

import net.imagej.ops.Ops;
import net.imagej.ops.features.haralick.AbstractHaralickFeature;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Haralick.Entropy.class, label="Haralick: Entropy")
public class DefaultEntropy<T extends RealType<T>>
extends AbstractHaralickFeature<T>
implements Ops.Haralick.Entropy {
    private static final double EPSILON = Double.MIN_NORMAL;

    @Override
    public void compute(IterableInterval<T> input, DoubleType output) {
        double[][] matrix = this.getCooccurrenceMatrix(input);
        double res = 0.0;
        int nrGrayLevels = matrix.length;
        for (int i = 0; i < nrGrayLevels; ++i) {
            for (int j = 0; j < nrGrayLevels; ++j) {
                res += matrix[i][j] * Math.log(matrix[i][j] + Double.MIN_NORMAL);
            }
        }
        output.set(-res);
    }
}

