/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.threshold.rosin;

import net.imagej.ops.Ops;
import net.imagej.ops.threshold.AbstractComputeThresholdHistogram;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Threshold.Rosin.class, priority=100.0)
public class ComputeRosinThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T>
implements Ops.Threshold.Rosin {
    @Parameter
    private LogService log;

    @Override
    public long computeBin(Histogram1d<T> histo) {
        long[] hist = histo.toLongArray();
        int noPts = hist.length;
        boolean doInvert = false;
        int pk = this.findStart(hist, noPts);
        int st = this.findFirst(hist, noPts);
        int fi = this.findEnd(hist, noPts);
        int d1 = pk - st;
        int d2 = fi - pk;
        if (d1 < 0 || d2 < 0) {
            this.log.warn((Object)"Histogram peak at a strange location");
        }
        if (d1 > d2) {
            doInvert = true;
        }
        if (doInvert) {
            for (int i = 0; i < noPts / 2; ++i) {
                long tmp = hist[i];
                hist[i] = hist[noPts - 1 - i];
                hist[noPts - 1 - i] = tmp;
            }
        }
        st = this.findStart(hist, noPts);
        int thresh = this.findCorner(hist, st, noPts);
        if (doInvert) {
            thresh = noPts - thresh - 1;
        }
        return thresh;
    }

    private int findStart(long[] Y, int noPts) {
        int st = 0;
        long max = Y[0];
        for (int i = 1; i < noPts; ++i) {
            if (Y[i] <= max) continue;
            max = Y[i];
            st = i;
        }
        return st;
    }

    private int findFirst(long[] Y, int noPts) {
        int st = 0;
        for (int i = 0; i < noPts; ++i) {
            if (Y[i] <= 0L) continue;
            st = i;
            break;
        }
        return st;
    }

    private int findEnd(long[] Y, int noPts) {
        int fi = 0;
        for (int i = 1; i < noPts; ++i) {
            if (Y[i] <= 0L) continue;
            fi = i;
        }
        return fi;
    }

    private int findCorner(long[] Y, int st, int noPts) {
        int end;
        int i;
        long[] X = new long[noPts];
        float maxDist = -1.0f;
        int thresh = -1;
        for (i = st; i < noPts; ++i) {
            X[i] = i;
        }
        for (end = noPts - 1; Y[end] == 0L && end >= 0; --end) {
        }
        noPts = end;
        if (end <= 0) {
            throw new IllegalStateException("Histogram is empty.");
        }
        for (i = st; i <= noPts; ++i) {
            float dist = (Y[st] - Y[noPts - 1]) * X[i] - (X[st] - X[noPts - 1]) * Y[i] - X[noPts - 1] * Y[st] + X[st] * Y[noPts - 1];
            dist = (float)(Math.pow(dist, 2.0) / (Math.pow(X[st] - X[noPts - 1], 2.0) + Math.pow(Y[st] - Y[noPts - 1], 2.0)));
            if (!((dist = Math.abs(dist)) > maxDist)) continue;
            maxDist = dist;
            thresh = i;
        }
        return thresh;
    }
}

