/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.shm;

import java.util.Random;
import org.apposed.appose.SharedMemory;
import org.apposed.appose.ShmFactory;
import org.apposed.appose.util.Plugins;

public final class Shms {
    public static int O_RDONLY = 0;
    public static int O_RDWR = 2;
    public static int O_CREAT = 64;
    public static int PROT_READ = 1;
    public static int PROT_WRITE = 2;
    public static int MAP_SHARED = 1;
    public static final int SHM_SAFE_NAME_LENGTH = 14;
    public static final String SHM_NAME_PREFIX_POSIX = "/psm_";
    public static final String SHM_NAME_PREFIX_WIN = "wnsm_";

    private Shms() {
    }

    public static SharedMemory create(String name, boolean create, long rsize) {
        SharedMemory shm = Plugins.create(ShmFactory.class, factory -> factory.create(name, create, rsize));
        if (shm == null) {
            throw new UnsupportedOperationException("No SharedMemory support for this platform");
        }
        return shm;
    }

    public static String withLeadingSlash(String name) {
        return name.startsWith("/") ? name : "/" + name;
    }

    public static String withoutLeadingSlash(String name) {
        return name.startsWith("/") ? name.substring(1) : name;
    }

    public static String makeFilename(int maxLength, String prefix) {
        int nbytes = (maxLength - prefix.length()) / 2;
        if (nbytes < 2) {
            throw new IllegalArgumentException("prefix too long");
        }
        String name = prefix + Shms.tokenHex(nbytes);
        assert (name.length() <= maxLength);
        return name;
    }

    public static void checkSize(String shmName, long prevSize, long size) {
        boolean alreadyExists;
        boolean bl = alreadyExists = prevSize >= 0L;
        if (alreadyExists && prevSize < size) {
            throw new RuntimeException("Shared memory segment '" + shmName + "' already exists with smaller size. Size of the existing shared memory segment (" + prevSize + ") cannot be smaller than the size of the proposed object (" + size + ".");
        }
    }

    private static String tokenHex(int nbytes) {
        byte[] bytes = new byte[nbytes];
        new Random().nextBytes(bytes);
        StringBuilder sb = new StringBuilder(nbytes * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }
}

