/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.overlay;

import java.awt.geom.GeneralPath;
import net.imglib2.Interval;
import net.imglib2.realtransform.AffineTransform3D;

public class RenderBoxHelper {
    private double depth = 10.0;
    private double scale = 0.1;
    private final double[] origin = new double[3];

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setDepth(double depth) {
        this.depth = depth;
        this.origin[2] = -depth;
    }

    public void setOrigin(double x, double y) {
        this.origin[0] = x;
        this.origin[1] = y;
    }

    public double perspectiveX(double[] p) {
        return this.scale * (p[0] - this.origin[0]) / (p[2] - this.origin[2]) * this.depth;
    }

    public double perspectiveY(double[] p) {
        return this.scale * (p[1] - this.origin[1]) / (p[2] - this.origin[2]) * this.depth;
    }

    public void splitEdge(double[] a, double[] b, GeneralPath before, GeneralPath behind) {
        double[] t = new double[3];
        if (a[2] <= 0.0) {
            before.moveTo(this.perspectiveX(a), this.perspectiveY(a));
            if (b[2] <= 0.0) {
                before.lineTo(this.perspectiveX(b), this.perspectiveY(b));
            } else {
                double d = a[2] / (a[2] - b[2]);
                t[0] = (b[0] - a[0]) * d + a[0];
                t[1] = (b[1] - a[1]) * d + a[1];
                before.lineTo(this.perspectiveX(t), this.perspectiveY(t));
                behind.moveTo(this.perspectiveX(t), this.perspectiveY(t));
                behind.lineTo(this.perspectiveX(b), this.perspectiveY(b));
            }
        } else {
            behind.moveTo(this.perspectiveX(a), this.perspectiveY(a));
            if (b[2] > 0.0) {
                behind.lineTo(this.perspectiveX(b), this.perspectiveY(b));
            } else {
                double d = a[2] / (a[2] - b[2]);
                t[0] = (b[0] - a[0]) * d + a[0];
                t[1] = (b[1] - a[1]) * d + a[1];
                behind.lineTo(this.perspectiveX(t), this.perspectiveY(t));
                before.moveTo(this.perspectiveX(t), this.perspectiveY(t));
                before.lineTo(this.perspectiveX(b), this.perspectiveY(b));
            }
        }
    }

    public void renderBox(Interval sourceInterval, AffineTransform3D transform, GeneralPath front, GeneralPath back) {
        double sX0 = sourceInterval.min(0);
        double sX1 = sourceInterval.max(0);
        double sY0 = sourceInterval.min(1);
        double sY1 = sourceInterval.max(1);
        double sZ0 = sourceInterval.min(2);
        double sZ1 = sourceInterval.max(2);
        double[] p000 = new double[]{sX0, sY0, sZ0};
        double[] p100 = new double[]{sX1, sY0, sZ0};
        double[] p010 = new double[]{sX0, sY1, sZ0};
        double[] p110 = new double[]{sX1, sY1, sZ0};
        double[] p001 = new double[]{sX0, sY0, sZ1};
        double[] p101 = new double[]{sX1, sY0, sZ1};
        double[] p011 = new double[]{sX0, sY1, sZ1};
        double[] p111 = new double[]{sX1, sY1, sZ1};
        double[] q000 = new double[3];
        double[] q100 = new double[3];
        double[] q010 = new double[3];
        double[] q110 = new double[3];
        double[] q001 = new double[3];
        double[] q101 = new double[3];
        double[] q011 = new double[3];
        double[] q111 = new double[3];
        transform.apply(p000, q000);
        transform.apply(p100, q100);
        transform.apply(p010, q010);
        transform.apply(p110, q110);
        transform.apply(p001, q001);
        transform.apply(p101, q101);
        transform.apply(p011, q011);
        transform.apply(p111, q111);
        this.splitEdge(q000, q100, front, back);
        this.splitEdge(q100, q110, front, back);
        this.splitEdge(q110, q010, front, back);
        this.splitEdge(q010, q000, front, back);
        this.splitEdge(q001, q101, front, back);
        this.splitEdge(q101, q111, front, back);
        this.splitEdge(q111, q011, front, back);
        this.splitEdge(q011, q001, front, back);
        this.splitEdge(q000, q001, front, back);
        this.splitEdge(q100, q101, front, back);
        this.splitEdge(q110, q111, front, back);
        this.splitEdge(q010, q011, front, back);
    }

    public void renderCanvas(Interval targetInterval, GeneralPath canvas) {
        double tX0 = targetInterval.min(0);
        double tX1 = targetInterval.max(0);
        double tY0 = targetInterval.min(1);
        double tY1 = targetInterval.max(1);
        double[] c000 = new double[]{tX0, tY0, 0.0};
        double[] c100 = new double[]{tX1, tY0, 0.0};
        double[] c010 = new double[]{tX0, tY1, 0.0};
        double[] c110 = new double[]{tX1, tY1, 0.0};
        canvas.moveTo(this.perspectiveX(c000), this.perspectiveY(c000));
        canvas.lineTo(this.perspectiveX(c100), this.perspectiveY(c100));
        canvas.lineTo(this.perspectiveX(c110), this.perspectiveY(c110));
        canvas.lineTo(this.perspectiveX(c010), this.perspectiveY(c010));
        canvas.closePath();
    }
}

