/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.ImageComponentRetained;
import org.jogamp.java3d.J3DGraphics2D;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.MasterControl;
import org.jogamp.java3d.VirtualUniverse;

final class J3DGraphics2DImpl
extends J3DGraphics2D {
    private boolean hasBeenDisposed = false;
    private Graphics2D offScreenGraphics2D;
    private BufferedImage g3dImage = null;
    private byte[] data = null;
    private boolean isFlushed = true;
    private Canvas3D canvas3d;
    private int width;
    private int height;
    private int texWidth;
    private int texHeight;
    private int xmin;
    private int ymin;
    private int xmax;
    private int ymax;
    private Object extentLock = new Object();
    private boolean abgr;
    private boolean initTexMap = false;
    private boolean strokeSet = false;
    private Point2D.Float ptDst1 = new Point2D.Float();
    private Point2D.Float ptDst2 = new Point2D.Float();
    private Color xOrModeColor = null;
    private volatile boolean initCtx = false;
    private volatile boolean threadWaiting = false;
    static final Color blackTransparent = new Color(0, 0, 0, 0);
    int objectId = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    J3DGraphics2DImpl(Canvas3D c) {
        this.canvas3d = c;
        Object object = VirtualUniverse.mc.contextCreationLock;
        synchronized (object) {
            if (c.ctx == null) {
                this.width = 1;
                this.height = 1;
                this.g3dImage = new BufferedImage(this.width, this.height, 2);
                this.offScreenGraphics2D = this.g3dImage.createGraphics();
            } else {
                this.init();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        if (!this.initCtx) {
            this.abgr = (this.canvas3d.extensionsSupported & 2) != 0;
            this.width = this.canvas3d.getPixelWidth();
            this.height = this.canvas3d.getPixelHeight();
            this.initTexMap = false;
            if (this.width <= 0) {
                this.width = 1;
            }
            if (this.height <= 0) {
                this.height = 1;
            }
            Object object = this.extentLock;
            synchronized (object) {
                this.xmax = this.width;
                this.ymax = this.height;
                this.xmin = 0;
                this.ymin = 0;
            }
            this.g3dImage = new BufferedImage(this.width, this.height, this.abgr ? 6 : 2);
            this.offScreenGraphics2D = this.g3dImage.createGraphics();
            this.clearOffScreen();
            if (!this.abgr) {
                this.data = new byte[this.width * this.height * 4];
            }
            this.initCtx = true;
        }
    }

    @Override
    public void flush(boolean waiting) {
        if (this.hasBeenDisposed) {
            throw new IllegalStateException(J3dI18N.getString("J3DGraphics2D0"));
        }
        if (!this.isFlushed) {
            if (Thread.currentThread() == this.canvas3d.screen.renderer) {
                if (!this.initCtx) {
                    return;
                }
                this.doFlush();
            } else {
                if (!this.initCtx) {
                    if (waiting && this.canvas3d.pendingView != null && this.canvas3d.pendingView.activeStatus) {
                        while (!this.initCtx) {
                            MasterControl.threadYield();
                        }
                    } else {
                        return;
                    }
                }
                boolean renderRun = Thread.currentThread() != this.canvas3d.view.universe.behaviorScheduler;
                this.threadWaiting = true;
                this.sendRenderMessage(renderRun, 23, null, null, null);
                if (waiting) {
                    this.runMonitor(0);
                }
            }
            this.isFlushed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doFlush() {
        assert (!this.hasBeenDisposed);
        if (this.canvas3d.ctx == null) {
            this.canvas3d.getGraphicsContext3D().doClear();
        }
        Object object = this.extentLock;
        synchronized (object) {
            if (this.xmin < 0) {
                this.xmin = 0;
            }
            if (this.xmax > this.width) {
                this.xmax = this.width;
            }
            if (this.ymin < 0) {
                this.ymin = 0;
            }
            if (this.ymax > this.height) {
                this.ymax = this.height;
            }
            if (this.xmax - this.xmin > 0 && this.ymax - this.ymin > 0) {
                if (this.abgr) {
                    this.data = ((DataBufferByte)this.g3dImage.getRaster().getDataBuffer()).getData();
                } else {
                    this.copyImage(this.g3dImage, this.data, this.width, this.height, this.xmin, this.ymin, this.xmax, this.ymax);
                }
                this.copyDataToCanvas(0, 0, this.xmin, this.ymin, this.xmax, this.ymax, this.width, this.height);
            } else {
                this.runMonitor(2);
            }
            this.xmax = 0;
            this.ymax = 0;
            this.xmin = this.width;
            this.ymin = this.height;
        }
    }

    final void copyImage(BufferedImage bi, byte[] image, int width, int height, int x1, int y1, int x2, int y2) {
        assert (!this.hasBeenDisposed);
        int biType = bi.getType();
        int dstBegin = 0;
        int rowInc = 1;
        int rowBegin = 0;
        if (biType == 2 || biType == 1) {
            rowBegin = y1;
            int colBegin = x1;
            int[] intData = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
            int rowOffset = rowInc * width;
            rowBegin = rowBegin * width + colBegin;
            dstBegin = rowBegin * 4;
            if (biType == 2) {
                for (int h = y1; h < y2; ++h) {
                    int i = rowBegin;
                    int j = dstBegin;
                    int w = x1;
                    while (w < x2) {
                        int intPixel = intData[i];
                        image[j++] = (byte)(intPixel >> 16 & 0xFF);
                        image[j++] = (byte)(intPixel >> 8 & 0xFF);
                        image[j++] = (byte)(intPixel & 0xFF);
                        image[j++] = (byte)(intPixel >> 24 & 0xFF);
                        ++w;
                        ++i;
                    }
                    rowBegin += rowOffset;
                    dstBegin += rowOffset * 4;
                }
            } else {
                for (int h = y1; h < y2; ++h) {
                    int i = rowBegin;
                    int j = dstBegin;
                    int w = x1;
                    while (w < x2) {
                        int intPixel = intData[i];
                        image[j++] = (byte)(intPixel >> 16 & 0xFF);
                        image[j++] = (byte)(intPixel >> 8 & 0xFF);
                        image[j++] = (byte)(intPixel & 0xFF);
                        image[j++] = -1;
                        ++w;
                        ++i;
                    }
                    rowBegin += rowOffset;
                    dstBegin += rowOffset * 4;
                }
            }
        } else {
            WritableRaster ras = bi.getRaster();
            ColorModel cm = bi.getColorModel();
            Object pixel = ImageComponentRetained.getDataElementBuffer(ras);
            int j = (y1 * width + x1) * 4;
            for (int h = y1; h < y2; ++h) {
                int i = j;
                for (int w = x1; w < x2; ++w) {
                    ras.getDataElements(w, h, pixel);
                    image[j++] = (byte)cm.getRed(pixel);
                    image[j++] = (byte)cm.getGreen(pixel);
                    image[j++] = (byte)cm.getBlue(pixel);
                    image[j++] = (byte)cm.getAlpha(pixel);
                }
                j = i + width * 4;
            }
        }
    }

    void sendRenderMessage(boolean renderRun, int command, Object arg1, Object arg2, Object arg3) {
        J3dMessage renderMessage = new J3dMessage();
        renderMessage.threads = 16;
        renderMessage.type = 44;
        renderMessage.universe = null;
        renderMessage.view = null;
        renderMessage.args[0] = this.canvas3d;
        renderMessage.args[1] = new Integer(command);
        renderMessage.args[2] = arg1;
        renderMessage.args[3] = arg2;
        renderMessage.args[4] = arg3;
        while (!this.canvas3d.view.inRenderThreadData) {
            MasterControl.threadYield();
        }
        this.canvas3d.screen.renderer.rendererStructure.addMessage(renderMessage);
        if (renderRun) {
            VirtualUniverse.mc.sendRunMessage(this.canvas3d.view, 16);
        } else {
            VirtualUniverse.mc.setWorkForRequestRenderer();
        }
    }

    final void validate() {
        this.validate(0.0f, 0.0f, (float)this.width, (float)this.height, false);
    }

    void validate(float x1, float y1, float x2, float y2, AffineTransform xform) {
        if (xform == null) {
            this.validate(x1, y1, x2, y2, true);
        } else {
            float t;
            this.ptDst1.x = x1;
            this.ptDst1.y = y1;
            xform.transform(this.ptDst1, this.ptDst1);
            this.ptDst2.x = x2;
            this.ptDst2.y = y2;
            xform.transform(this.ptDst2, this.ptDst2);
            if (this.ptDst1.x > this.ptDst2.x) {
                t = this.ptDst1.x;
                this.ptDst1.x = this.ptDst2.x;
                this.ptDst2.x = t;
            }
            if (this.ptDst1.y > this.ptDst2.y) {
                t = this.ptDst1.y;
                this.ptDst1.y = this.ptDst2.y;
                this.ptDst2.y = t;
            }
            this.validate(this.ptDst1.x - 1.0f, this.ptDst1.y - 1.0f, this.ptDst2.x + 1.0f, this.ptDst2.y + 1.0f, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validate(float x1, float y1, float x2, float y2, boolean shouldTransform) {
        boolean doResize = false;
        this.isFlushed = false;
        Object object = this.canvas3d;
        synchronized (object) {
            if (this.initCtx && this.canvas3d.resizeGraphics2D) {
                doResize = true;
                this.canvas3d.resizeGraphics2D = false;
            }
        }
        if (doResize) {
            object = VirtualUniverse.mc.contextCreationLock;
            synchronized (object) {
                Graphics2D oldOffScreenGraphics2D = this.offScreenGraphics2D;
                this.initCtx = false;
                this.init();
                this.copyGraphics2D(oldOffScreenGraphics2D);
            }
        }
        this.ptDst1.x = x1;
        this.ptDst1.y = y1;
        this.ptDst2.x = x2;
        this.ptDst2.y = y2;
        if (shouldTransform) {
            AffineTransform tr = this.getTransform();
            tr.transform(this.ptDst1, this.ptDst1);
            tr.transform(this.ptDst2, this.ptDst2);
        }
        object = this.extentLock;
        synchronized (object) {
            if (this.ptDst1.x < (float)this.xmin) {
                this.xmin = (int)this.ptDst1.x;
            }
            if (this.ptDst2.x < (float)this.xmin) {
                this.xmin = (int)this.ptDst2.x;
            }
            if (this.ptDst1.y < (float)this.ymin) {
                this.ymin = (int)this.ptDst1.y;
            }
            if (this.ptDst2.y < (float)this.ymin) {
                this.ymin = (int)this.ptDst2.y;
            }
            if (this.ptDst1.x > (float)this.xmax) {
                this.xmax = (int)this.ptDst1.x;
            }
            if (this.ptDst2.x > (float)this.xmax) {
                this.xmax = (int)this.ptDst2.x;
            }
            if (this.ptDst1.y > (float)this.ymax) {
                this.ymax = (int)this.ptDst1.y;
            }
            if (this.ptDst2.y > (float)this.ymax) {
                this.ymax = (int)this.ptDst2.y;
            }
        }
    }

    void copyGraphics2D(Graphics2D oldg) {
        this.setColor(oldg.getColor());
        this.setFont(oldg.getFont());
        this.setClip(oldg.getClip());
        this.setComposite(oldg.getComposite());
        this.setTransform(oldg.getTransform());
        this.setPaint(oldg.getPaint());
        this.setStroke(oldg.getStroke());
        if (this.xOrModeColor != null) {
            this.setXORMode(this.xOrModeColor);
        }
    }

    @Override
    public final void clip(Shape s) {
        this.offScreenGraphics2D.clip(s);
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.offScreenGraphics2D.getFontMetrics();
    }

    @Override
    public Rectangle getClipBounds(Rectangle r) {
        return this.offScreenGraphics2D.getClipBounds(r);
    }

    @Override
    public Rectangle getClipRect() {
        return this.offScreenGraphics2D.getClipRect();
    }

    @Override
    public String toString() {
        return this.offScreenGraphics2D.toString();
    }

    @Override
    public final AffineTransform getTransform() {
        return this.offScreenGraphics2D.getTransform();
    }

    @Override
    public final Color getColor() {
        return this.offScreenGraphics2D.getColor();
    }

    @Override
    public final Composite getComposite() {
        return this.offScreenGraphics2D.getComposite();
    }

    @Override
    public final Font getFont() {
        return this.offScreenGraphics2D.getFont();
    }

    @Override
    public final FontMetrics getFontMetrics(Font f) {
        return this.offScreenGraphics2D.getFontMetrics(f);
    }

    @Override
    public final FontRenderContext getFontRenderContext() {
        return this.offScreenGraphics2D.getFontRenderContext();
    }

    @Override
    public final GraphicsConfiguration getDeviceConfiguration() {
        return this.offScreenGraphics2D.getDeviceConfiguration();
    }

    @Override
    public final Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.offScreenGraphics2D.getRenderingHint(hintKey);
    }

    @Override
    public final Paint getPaint() {
        return this.offScreenGraphics2D.getPaint();
    }

    @Override
    public final Rectangle getClipBounds() {
        return this.offScreenGraphics2D.getClipBounds();
    }

    @Override
    public final RenderingHints getRenderingHints() {
        return this.offScreenGraphics2D.getRenderingHints();
    }

    @Override
    public final Shape getClip() {
        return this.offScreenGraphics2D.getClip();
    }

    @Override
    public final Stroke getStroke() {
        return this.offScreenGraphics2D.getStroke();
    }

    @Override
    public final boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        this.validate(0.0f, 0.0f, (float)img.getWidth(obs), (float)img.getHeight(obs), xform);
        return this.offScreenGraphics2D.drawImage(img, xform, obs);
    }

    @Override
    public final void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        if (op != null) {
            img = op.filter(img, null);
        }
        this.validate((float)x, (float)y, (float)(x + img.getWidth()), (float)(y + img.getHeight()), true);
        this.offScreenGraphics2D.drawImage(img, null, x, y);
    }

    @Override
    public final boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        this.validate((float)x, (float)y, (float)(x + img.getWidth(observer)), (float)(y + img.getWidth(observer)), true);
        return this.offScreenGraphics2D.drawImage(img, x, y, observer);
    }

    @Override
    public final boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        this.validate((float)x, (float)y, (float)(x + width), (float)(y + height), true);
        return this.offScreenGraphics2D.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public final boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        this.validate((float)x, (float)y, (float)(x + width), (float)(y + height), true);
        return this.offScreenGraphics2D.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    public final void drawImage(BufferedImage img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        this.validate((float)dx1, (float)dy1, (float)dx2, (float)dy2, true);
        this.offScreenGraphics2D.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public final boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        this.validate((float)dx1, (float)dy1, (float)dx2, (float)dy2, true);
        return this.offScreenGraphics2D.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public final boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        this.validate((float)dx1, (float)dy1, (float)dx2, (float)dy2, true);
        return this.offScreenGraphics2D.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public final boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        this.validate((float)x, (float)y, (float)(x + img.getWidth(observer)), (float)(y + img.getHeight(observer)), true);
        return this.offScreenGraphics2D.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public final boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.offScreenGraphics2D.hit(rect, s, onStroke);
    }

    public final void addRenderingHints(Map hints) {
        this.offScreenGraphics2D.addRenderingHints(hints);
    }

    @Override
    public final void clipRect(int x, int y, int width, int height) {
        this.offScreenGraphics2D.clipRect(x, y, width, height);
    }

    @Override
    public final void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.validate((float)(x + dx), (float)(y + dy), (float)(x + dx + width), (float)(y + dy + height), true);
        this.offScreenGraphics2D.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public final void draw(Shape s) {
        Rectangle rect = s.getBounds();
        this.validate((float)rect.x, (float)rect.y, (float)(rect.x + rect.width), (float)(rect.y + rect.height), true);
        this.offScreenGraphics2D.draw(s);
    }

    @Override
    public final void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.validate();
        this.offScreenGraphics2D.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public final void drawGlyphVector(GlyphVector g, float x, float y) {
        this.validate();
        this.offScreenGraphics2D.drawGlyphVector(g, x, y);
    }

    @Override
    public final void drawLine(int x1, int y1, int x2, int y2) {
        if (!this.strokeSet) {
            int maxy;
            int miny;
            int maxx;
            int minx;
            if (x1 > x2) {
                minx = x2;
                maxx = x1;
            } else {
                minx = x1;
                maxx = x2;
            }
            if (y1 > y2) {
                miny = y2;
                maxy = y1;
            } else {
                miny = y1;
                maxy = y2;
            }
            this.validate((float)minx, (float)miny, (float)maxx, (float)maxy, true);
        } else {
            this.validate();
        }
        this.offScreenGraphics2D.drawLine(x1, y1, x2, y2);
    }

    @Override
    public final void drawOval(int x, int y, int width, int height) {
        this.validate();
        this.offScreenGraphics2D.drawOval(x, y, width, height);
    }

    @Override
    public final void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.validate();
        this.offScreenGraphics2D.drawPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public final void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.validate();
        this.offScreenGraphics2D.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public final void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.validate(0.0f, 0.0f, img.getWidth(), img.getHeight(), xform);
        this.offScreenGraphics2D.drawRenderableImage(img, xform);
    }

    @Override
    public final void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.validate(0.0f, 0.0f, (float)img.getWidth(), (float)img.getHeight(), xform);
        this.offScreenGraphics2D.drawRenderedImage(img, xform);
    }

    @Override
    public final void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.validate();
        this.offScreenGraphics2D.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public final void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.validate();
        this.offScreenGraphics2D.drawString(iterator, x, y);
    }

    @Override
    public final void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.validate();
        this.offScreenGraphics2D.drawString(iterator, x, y);
    }

    @Override
    public final void drawString(String s, float x, float y) {
        TextLayout layout = new TextLayout(s, this.getFont(), this.getFontRenderContext());
        Rectangle2D bounds = layout.getBounds();
        float x1 = (float)bounds.getX();
        float y1 = (float)bounds.getY();
        this.validate(x1 + x, y1 + y, x1 + x + (float)bounds.getWidth(), y1 + y + (float)bounds.getHeight(), true);
        this.offScreenGraphics2D.drawString(s, x, y);
    }

    @Override
    public final void drawString(String s, int x, int y) {
        this.drawString(s, (float)x, (float)y);
    }

    @Override
    public final void fill(Shape s) {
        Rectangle rect = s.getBounds();
        this.validate((float)rect.x, (float)rect.y, (float)(rect.x + rect.width), (float)(rect.y + rect.height), true);
        this.offScreenGraphics2D.fill(s);
    }

    @Override
    public final void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.validate();
        this.offScreenGraphics2D.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public final void fillOval(int x, int y, int width, int height) {
        this.validate();
        this.offScreenGraphics2D.fillOval(x, y, width, height);
    }

    @Override
    public final void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.validate();
        this.offScreenGraphics2D.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public final void rotate(double theta) {
        this.offScreenGraphics2D.rotate(theta);
    }

    @Override
    public final void rotate(double theta, double x, double y) {
        this.offScreenGraphics2D.rotate(theta, x, y);
    }

    @Override
    public final void scale(double sx, double sy) {
        this.offScreenGraphics2D.scale(sx, sy);
    }

    @Override
    public final void setClip(Shape clip) {
        this.offScreenGraphics2D.setClip(clip);
    }

    @Override
    public final void setClip(int x, int y, int width, int height) {
        this.offScreenGraphics2D.setClip(x, y, width, height);
    }

    @Override
    public final void setColor(Color c) {
        this.offScreenGraphics2D.setColor(c);
    }

    @Override
    public final void setComposite(Composite comp) {
        this.offScreenGraphics2D.setComposite(comp);
    }

    @Override
    public final void setFont(Font font) {
        this.offScreenGraphics2D.setFont(font);
    }

    @Override
    public final void setPaint(Paint paint) {
        this.offScreenGraphics2D.setPaint(paint);
    }

    @Override
    public final void setPaintMode() {
        this.xOrModeColor = null;
        this.offScreenGraphics2D.setPaintMode();
    }

    @Override
    public final void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.offScreenGraphics2D.setRenderingHint(hintKey, hintValue);
    }

    public final void setRenderingHints(Map hints) {
        this.offScreenGraphics2D.setRenderingHints(hints);
    }

    @Override
    public final void setStroke(Stroke s) {
        this.strokeSet = s != null;
        this.offScreenGraphics2D.setStroke(s);
    }

    @Override
    public final void setTransform(AffineTransform Tx) {
        this.offScreenGraphics2D.setTransform(Tx);
    }

    @Override
    public final void setXORMode(Color c1) {
        this.xOrModeColor = c1;
        this.offScreenGraphics2D.setXORMode(c1);
    }

    @Override
    public final void shear(double shx, double shy) {
        this.offScreenGraphics2D.shear(shx, shy);
    }

    @Override
    public final void transform(AffineTransform Tx) {
        this.offScreenGraphics2D.transform(Tx);
    }

    @Override
    public final void translate(double tx, double ty) {
        this.offScreenGraphics2D.translate(tx, ty);
    }

    @Override
    public final void translate(int x, int y) {
        this.offScreenGraphics2D.translate(x, y);
    }

    @Override
    public boolean hitClip(int x, int y, int width, int height) {
        return this.offScreenGraphics2D.hitClip(x, y, width, height);
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.validate();
        this.offScreenGraphics2D.draw3DRect(x, y, width, height, raised);
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.validate();
        this.offScreenGraphics2D.drawBytes(data, offset, length, x, y);
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this.validate();
        this.offScreenGraphics2D.drawChars(data, offset, length, x, y);
    }

    @Override
    public void drawPolygon(Polygon p) {
        this.validate();
        this.offScreenGraphics2D.drawPolygon(p);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.validate();
        this.offScreenGraphics2D.drawRect(x, y, width, height);
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.validate();
        this.offScreenGraphics2D.fill3DRect(x, y, width, height, raised);
    }

    @Override
    public void fillPolygon(Polygon p) {
        this.validate();
        this.offScreenGraphics2D.fillPolygon(p);
    }

    @Override
    public final void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.validate();
        this.offScreenGraphics2D.fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public final void fillRect(int x, int y, int width, int height) {
        this.validate();
        this.offScreenGraphics2D.fillRect(x, y, width, height);
    }

    @Override
    public void dispose() {
        if (this.hasBeenDisposed) {
            return;
        }
        if (Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doDispose();
        } else {
            boolean renderRun = Thread.currentThread() != this.canvas3d.view.universe.behaviorScheduler;
            this.sendRenderMessage(renderRun, 26, null, null, null);
        }
    }

    public void doDispose() {
        if (this.hasBeenDisposed) {
            return;
        }
        if (this.objectId != -1) {
            Canvas3D.freeTexture(this.canvas3d.ctx, this.objectId);
            this.objectId = -1;
        }
        this.offScreenGraphics2D.dispose();
        this.hasBeenDisposed = true;
        this.canvas3d.graphics2D = null;
    }

    @Override
    public void drawAndFlushImage(BufferedImage img, int x, int y, ImageObserver observer) {
        if (this.hasBeenDisposed) {
            throw new IllegalStateException(J3dI18N.getString("J3DGraphics2D0"));
        }
        if (!this.initCtx || !this.abgr || img.getType() != 6) {
            this.drawImage((Image)img, x, y, observer);
            this.flush(false);
            return;
        }
        if (Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doDrawAndFlushImage(img, x, y, observer);
        } else {
            boolean renderRun = Thread.currentThread() != this.canvas3d.view.universe.behaviorScheduler;
            this.sendRenderMessage(renderRun, 24, img, new Point(x, y), observer);
        }
    }

    void doDrawAndFlushImage(BufferedImage img, int x, int y, ImageObserver observer) {
        int y1;
        int x1;
        assert (!this.hasBeenDisposed);
        int imgWidth = img.getWidth(observer);
        int imgHeight = img.getHeight(observer);
        if (this.canvas3d.ctx == null) {
            this.canvas3d.getGraphicsContext3D().doClear();
        }
        this.data = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        AffineTransform tr = this.getTransform();
        this.ptDst1.x = x;
        this.ptDst1.y = y;
        tr.transform(this.ptDst1, this.ptDst1);
        int px = (int)this.ptDst1.x;
        int py = (int)this.ptDst1.y;
        int x2 = px + imgWidth > this.width ? this.width - px : imgWidth;
        if (px < 0) {
            x1 = -px;
            px = 0;
        } else {
            x1 = 0;
        }
        int y2 = py + imgHeight > this.height ? this.height - py : imgHeight;
        if (py < 0) {
            y1 = -py;
            py = 0;
        } else {
            y1 = 0;
        }
        if (y2 - y1 > 0 && x2 - x1 > 0) {
            this.copyDataToCanvas(px, py, x1, y1, x2, y2, imgWidth, imgHeight);
        }
    }

    void copyDataToCanvas(int px, int py, int x1, int y1, int x2, int y2, int w, int h) {
        try {
            if (!this.canvas3d.drawingSurfaceObject.renderLock()) {
                return;
            }
            if (!this.initTexMap) {
                if (this.objectId == -1) {
                    this.objectId = Canvas3D.generateTexID(this.canvas3d.ctx);
                }
                this.texWidth = J3DGraphics2DImpl.getGreaterPowerOf2(w);
                this.texHeight = J3DGraphics2DImpl.getGreaterPowerOf2(h);
                if (!this.canvas3d.initTexturemapping(this.canvas3d.ctx, this.texWidth, this.texHeight, this.objectId)) {
                    this.initTexMap = false;
                    Canvas3D.freeTexture(this.canvas3d.ctx, this.objectId);
                    this.objectId = -1;
                    System.err.println("J3DGraphics2DImpl.copyDataToCanvas() : Fail to get texture resources ...");
                } else {
                    this.initTexMap = true;
                }
            }
            if (this.initTexMap) {
                this.canvas3d.texturemapping(this.canvas3d.ctx, px, py, x1, y1, x2, y2, this.texWidth, this.texHeight, w, this.abgr ? 4 : 8, this.objectId, this.data, this.width, this.height);
            }
            this.canvas3d.drawingSurfaceObject.unLock();
        }
        catch (NullPointerException ne) {
            this.canvas3d.drawingSurfaceObject.unLock();
            throw ne;
        }
        this.clearOffScreen();
        this.runMonitor(2);
    }

    void clearOffScreen() {
        Composite comp = this.offScreenGraphics2D.getComposite();
        Color c = this.offScreenGraphics2D.getColor();
        AffineTransform transform = this.offScreenGraphics2D.getTransform();
        this.offScreenGraphics2D.setTransform(new AffineTransform());
        this.offScreenGraphics2D.setComposite(AlphaComposite.Src);
        this.offScreenGraphics2D.setColor(blackTransparent);
        this.offScreenGraphics2D.fillRect(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
        this.offScreenGraphics2D.setComposite(comp);
        this.offScreenGraphics2D.setColor(c);
        this.offScreenGraphics2D.setTransform(transform);
    }

    static int getGreaterPowerOf2(int x) {
        int i = -1;
        if (x >= 0) {
            for (i = 1; i < x; i <<= 1) {
            }
        }
        return i;
    }

    synchronized void runMonitor(int action) {
        if (action == 0) {
            while (this.threadWaiting) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        } else if (action == 2) {
            this.notify();
            this.threadWaiting = false;
        }
    }
}

