/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import java.awt.Choice;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;

public class Colors
implements PlugIn,
ItemListener {
    public static final String[] colors = new String[]{"red", "green", "blue", "magenta", "cyan", "yellow", "orange", "black", "white", "gray", "lightgray", "darkgray", "pink"};
    private static final String[] colors2 = new String[]{"Red", "Green", "Blue", "Magenta", "Cyan", "Yellow", "Orange", "Black", "White", "Gray", "lightGray", "darkGray", "Pink"};
    private Choice fchoice;
    private Choice bchoice;
    private Choice schoice;
    private Color fc2;
    private Color bc2;
    private Color sc2;
    private static final double gamma = 0.8;

    @Override
    public void run(String arg) {
        this.showDialog();
    }

    void showDialog() {
        Color fc = Toolbar.getForegroundColor();
        String fname = Colors.getColorName(fc, "black");
        Color bc = Toolbar.getBackgroundColor();
        String bname = Colors.getColorName(bc, "white");
        Color sc = Roi.getColor();
        String sname = Colors.getColorName(sc, "yellow");
        GenericDialog gd = new GenericDialog("Colors");
        gd.addChoice("Foreground:", colors, fname);
        gd.addChoice("Background:", colors, bname);
        gd.addChoice("Selection:", colors, sname);
        Vector choices = gd.getChoices();
        if (choices != null) {
            this.fchoice = (Choice)choices.elementAt(0);
            this.bchoice = (Choice)choices.elementAt(1);
            this.schoice = (Choice)choices.elementAt(2);
            this.fchoice.addItemListener(this);
            this.bchoice.addItemListener(this);
            this.schoice.addItemListener(this);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            if (this.fc2 != fc) {
                Toolbar.setForegroundColor(fc);
            }
            if (this.bc2 != bc) {
                Toolbar.setBackgroundColor(bc);
            }
            if (this.sc2 != sc) {
                Roi.setColor(sc);
                ImagePlus imp = WindowManager.getCurrentImage();
                if (imp != null && imp.getRoi() != null) {
                    imp.draw();
                }
            }
            return;
        }
        fname = gd.getNextChoice();
        bname = gd.getNextChoice();
        sname = gd.getNextChoice();
        this.fc2 = Colors.getColor(fname, Color.black);
        this.bc2 = Colors.getColor(bname, Color.white);
        this.sc2 = Colors.getColor(sname, Color.yellow);
        if (this.fc2 != fc) {
            Toolbar.setForegroundColor(this.fc2);
        }
        if (this.bc2 != bc) {
            Toolbar.setBackgroundColor(this.bc2);
        }
        if (this.sc2 != sc) {
            Toolbar tb;
            Roi.setColor(this.sc2);
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp != null) {
                imp.draw();
            }
            if ((tb = Toolbar.getInstance()) != null) {
                tb.repaint();
            }
        }
    }

    public static String getColorName(Color c, String defaultName) {
        if (c == null) {
            return defaultName;
        }
        boolean useCapitalizedName = defaultName != null && defaultName.length() > 0 && Character.isUpperCase(defaultName.charAt(0));
        return Colors.getColorName(c, defaultName, useCapitalizedName);
    }

    private static String getColorName(Color c, String defaultName, boolean useCapitalizedName) {
        String[] colorNames;
        String[] stringArray = colorNames = useCapitalizedName ? colors2 : colors;
        if (c.equals(Color.red)) {
            return colorNames[0];
        }
        if (c.equals(Color.green)) {
            return colorNames[1];
        }
        if (c.equals(Color.blue)) {
            return colorNames[2];
        }
        if (c.equals(Color.magenta)) {
            return colorNames[3];
        }
        if (c.equals(Color.cyan)) {
            return colorNames[4];
        }
        if (c.equals(Color.yellow)) {
            return colorNames[5];
        }
        if (c.equals(Color.orange)) {
            return colorNames[6];
        }
        if (c.equals(Color.black)) {
            return colorNames[7];
        }
        if (c.equals(Color.white)) {
            return colorNames[8];
        }
        if (c.equals(Color.gray)) {
            return colorNames[9];
        }
        if (c.equals(Color.lightGray)) {
            return colorNames[10];
        }
        if (c.equals(Color.darkGray)) {
            return colorNames[11];
        }
        if (c.equals(Color.pink)) {
            return colorNames[12];
        }
        return defaultName;
    }

    public static Color getColor(String name, Color defaultColor) {
        if (name == null || name.length() < 2) {
            return defaultColor;
        }
        name = name.toLowerCase(Locale.US);
        Color c = defaultColor;
        if (name.contains(colors[7])) {
            c = Color.black;
        } else if (name.contains(colors[8])) {
            c = Color.white;
        } else if (name.contains(colors[0])) {
            c = Color.red;
        } else if (name.contains(colors[2])) {
            c = Color.blue;
        } else if (name.contains(colors[5])) {
            c = Color.yellow;
        } else if (name.contains(colors[1])) {
            c = Color.green;
        } else if (name.contains(colors[3])) {
            c = Color.magenta;
        } else if (name.contains(colors[4])) {
            c = Color.cyan;
        } else if (name.contains(colors[6])) {
            c = Color.orange;
        } else if (name.contains(colors[12])) {
            c = Color.pink;
        } else if (name.contains(colors[9]) || name.contains("grey")) {
            c = name.contains("light") ? Color.lightGray : (name.contains("dark") ? Color.darkGray : Color.gray);
        }
        return c;
    }

    public static Color decode(String hexColor) {
        return Colors.decode(hexColor, Color.gray);
    }

    public static Color decode(String hexColor, Color defaultColor) {
        if (hexColor == null || hexColor.length() < 2) {
            return defaultColor;
        }
        Color color = Colors.getColor(hexColor, null);
        if (color == null) {
            if (hexColor.startsWith("#")) {
                hexColor = hexColor.substring(1);
            } else if (hexColor.startsWith("0x")) {
                hexColor = hexColor.substring(2);
            }
            int len = hexColor.length();
            if (len != 6 && len != 8) {
                return defaultColor;
            }
            boolean hasAlpha = len == 8;
            try {
                int rgba = (int)Long.parseLong(hexColor, 16);
                color = new Color(rgba, hasAlpha);
            }
            catch (NumberFormatException e) {
                return defaultColor;
            }
        }
        return color;
    }

    public static int getRed(String hexColor) {
        return Colors.decode(hexColor, Color.black).getRed();
    }

    public static int getGreen(String hexColor) {
        return Colors.decode(hexColor, Color.black).getGreen();
    }

    public static int getBlue(String hexColor) {
        return Colors.decode(hexColor, Color.black).getBlue();
    }

    public static String hexToColor(String hex) {
        if (hex == null) {
            return null;
        }
        Color color = Colors.decode(hex, null);
        if (color == null) {
            return null;
        }
        return Colors.getColorName(color, null, false);
    }

    public static String hexToColor2(String hex) {
        if (hex == null) {
            return null;
        }
        Color color = Colors.decode(hex, null);
        if (color == null) {
            return null;
        }
        return Colors.getColorName(color, null, true);
    }

    public static String colorToString(Color color) {
        if (color == null) {
            return "none";
        }
        String str = Colors.getColorName(color, null, false);
        if (str == null) {
            str = "#" + Colors.getHexString(color);
        }
        return str;
    }

    public static String colorToString2(Color color) {
        if (color == null) {
            return "None";
        }
        String str = Colors.getColorName(color, null, true);
        if (str == null) {
            str = "#" + Colors.getHexString(color);
        }
        return str;
    }

    private static String getHexString(Color color) {
        boolean isOpaque;
        int rgb = color.getRGB();
        boolean bl = isOpaque = (rgb & 0xFF000000) == -16777216;
        if (isOpaque) {
            rgb &= 0xFFFFFF;
        }
        String format = isOpaque ? "%06x" : "%08x";
        return String.format(format, rgb);
    }

    public static Color toColor(int red, int green, int blue) {
        if (red < 0) {
            red = 0;
        }
        if (green < 0) {
            green = 0;
        }
        if (blue < 0) {
            blue = 0;
        }
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        return new Color(red, green, blue);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Choice choice = (Choice)e.getSource();
        String item = choice.getSelectedItem();
        Color color = Colors.getColor(item, Color.black);
        if (choice == this.fchoice) {
            Toolbar.setForegroundColor(color);
        } else if (choice == this.bchoice) {
            Toolbar.setBackgroundColor(color);
        } else if (choice == this.schoice) {
            Roi.setColor(color);
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp != null && imp.getRoi() != null) {
                imp.draw();
            }
            Toolbar.getInstance().repaint();
        }
    }

    public static String[] getColors(String ... moreColors) {
        ArrayList<String> names = new ArrayList<String>();
        for (String arg : moreColors) {
            if (arg == null || arg.length() <= 0 || Character.isLetter(arg.charAt(0)) && !arg.equals("None")) continue;
            names.add(arg);
        }
        for (String arg : colors2) {
            names.add(arg);
        }
        return names.toArray(new String[names.size()]);
    }

    public static Color wavelengthToColor(double wl) {
        double B;
        double G;
        double R;
        if (wl >= 380.0 & wl <= 440.0) {
            double attenuation = 0.3 + 0.7 * (wl - 380.0) / 60.0;
            R = Math.pow(-(wl - 440.0) / 60.0 * attenuation, 0.8);
            G = 0.0;
            B = Math.pow(1.0 * attenuation, 0.8);
        } else if (wl >= 440.0 & wl <= 490.0) {
            R = 0.0;
            G = Math.pow((wl - 440.0) / 50.0, 0.8);
            B = 1.0;
        } else if (wl >= 490.0 & wl <= 510.0) {
            R = 0.0;
            G = 1.0;
            B = Math.pow(-(wl - 510.0) / 20.0, 0.8);
        } else if (wl >= 510.0 & wl <= 580.0) {
            R = Math.pow((wl - 510.0) / 70.0, 0.8);
            G = 1.0;
            B = 0.0;
        } else if (wl >= 580.0 & wl <= 645.0) {
            R = 1.0;
            G = Math.pow(-(wl - 645.0) / 65.0, 0.8);
            B = 0.0;
        } else if (wl >= 645.0 & wl <= 750.0) {
            double attenuation = 0.3 + 0.7 * (750.0 - wl) / 105.0;
            R = Math.pow(1.0 * attenuation, 0.8);
            G = 0.0;
            B = 0.0;
        } else {
            R = 0.0;
            G = 0.0;
            B = 0.0;
        }
        R = Math.floor(R * 255.0);
        G = Math.floor(G * 255.0);
        B = Math.floor(B * 255.0);
        return new Color((int)R, (int)G, (int)B);
    }
}

