/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations;

import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.Translation;
import net.imglib2.realtransform.Translation2D;
import net.imglib2.realtransform.Translation3D;
import net.imglib2.realtransform.TranslationGet;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.AbstractLinearCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.InvertibleCoordinateTransform;

public class TranslationCoordinateTransform
extends AbstractLinearCoordinateTransform<TranslationGet, double[]>
implements InvertibleCoordinateTransform<TranslationGet> {
    public static final String TYPE = "translation";
    public double[] translation;
    public transient AffineGet transform;

    public TranslationCoordinateTransform(double[] translation) {
        this("", translation);
    }

    public TranslationCoordinateTransform(String name, double[] translation) {
        super(TYPE, name, (String)null, (String)null);
        this.translation = translation;
        this.buildTransform(translation);
    }

    public TranslationCoordinateTransform(String name, String[] inputAxes, String[] outputAxes, double[] translation) {
        super(TYPE, name, null, inputAxes, outputAxes);
        this.translation = translation;
        this.buildTransform(translation);
    }

    public TranslationCoordinateTransform(String name, String inputSpace, String outputSpace, double[] translation) {
        super(TYPE, name, inputSpace, outputSpace);
        this.translation = translation;
        this.buildTransform(translation);
    }

    public TranslationCoordinateTransform(String name, String inputSpace, String outputSpace, N5Reader n5, String path) {
        super(TYPE, name, path, inputSpace, outputSpace);
        this.translation = this.getParameters(n5);
        this.buildTransform(this.translation);
    }

    public TranslationCoordinateTransform(String name, String inputSpace, String outputSpace, String path) {
        super(TYPE, name, path, inputSpace, outputSpace);
        this.translation = null;
    }

    public TranslationCoordinateTransform(TranslationCoordinateTransform other) {
        super(other);
        this.translation = other.translation;
    }

    public TranslationCoordinateTransform(TranslationCoordinateTransform other, String[] inputAxes, String[] outputAxes) {
        super(other, inputAxes, outputAxes);
        this.translation = other.translation;
    }

    @Override
    public TranslationGet buildTransform(double[] parameters) {
        this.translation = parameters;
        this.transform = parameters.length == 2 ? new Translation2D(parameters) : (parameters.length == 3 ? new Translation3D(parameters) : new Translation(parameters));
        return (TranslationGet)this.transform;
    }

    @Override
    public TranslationGet getTransform() {
        if (this.transform == null && this.translation != null) {
            this.buildTransform(this.translation);
        }
        return (TranslationGet)this.transform;
    }

    @Override
    public double[] getParameters(N5Reader n5) {
        return TranslationCoordinateTransform.getDoubleArray(n5, this.getParameterPath());
    }
}

