/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.models;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.imagej.ImgPlus;
import net.imglib2.util.Pair;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.menu.MenuKey;
import sc.fiji.labkit.ui.models.ExtensionPoints;
import sc.fiji.labkit.ui.models.ImageLabelingModel;
import sc.fiji.labkit.ui.models.SegmentationResultsModel;
import sc.fiji.labkit.ui.segmentation.ForwardingSegmenter;
import sc.fiji.labkit.ui.segmentation.SegmentationPlugin;
import sc.fiji.labkit.ui.segmentation.Segmenter;

public class SegmentationItem
extends ForwardingSegmenter {
    public static final MenuKey<SegmentationItem> SEGMENTER_MENU = new MenuKey<SegmentationItem>(SegmentationItem.class);
    private static final AtomicInteger counter = new AtomicInteger();
    private final String name;
    private String filename;
    private boolean modified;
    private final Map<ImageLabelingModel, SegmentationResultsModel> results;
    private final ExtensionPoints extensionPoints;

    public SegmentationItem(SegmentationPlugin plugin, ExtensionPoints extensionPoints) {
        super(plugin.createSegmenter());
        this.name = "#" + counter.incrementAndGet() + " - " + plugin.getTitle();
        this.extensionPoints = extensionPoints;
        this.results = new WeakHashMap<ImageLabelingModel, SegmentationResultsModel>();
        this.filename = null;
        this.modified = false;
    }

    @Deprecated
    public Segmenter segmenter() {
        return this;
    }

    public String name() {
        return this.name;
    }

    public SegmentationResultsModel results(ImageLabelingModel imageLabeling) {
        SegmentationResultsModel result = this.results.get(imageLabeling);
        if (result == null) {
            result = new SegmentationResultsModel(imageLabeling, this.extensionPoints, this.getSourceSegmenter());
            this.results.put(imageLabeling, result);
        }
        return result;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public void openModel(String path) {
        super.openModel(path);
        this.filename = path;
        this.modified = false;
        this.results.forEach((i, r) -> r.update());
    }

    @Override
    public void train(List<Pair<ImgPlus<?>, Labeling>> data) {
        this.results.forEach((i, r) -> r.clear());
        this.modified = true;
        super.train(data);
        this.results.forEach((i, r) -> r.update());
    }

    public boolean isModified() {
        return this.modified;
    }

    public String getFileName() {
        return this.filename;
    }
}

