/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.zarr.cache;

import com.google.gson.JsonElement;
import org.janelia.saalfeldlab.n5.cache.N5JsonCache;
import org.janelia.saalfeldlab.n5.cache.N5JsonCacheableContainer;

public class ZarrJsonCache
extends N5JsonCache {
    public ZarrJsonCache(N5JsonCacheableContainer container) {
        super(container);
    }

    public void updateCacheInfo(String normalPathKey, String normalCacheKey, JsonElement uncachedAttributes) {
        N5JsonCache.N5CacheInfo cacheInfo = this.getCacheInfo(normalPathKey);
        if (cacheInfo == null) {
            this.addNewCacheInfo(normalPathKey, normalCacheKey, uncachedAttributes);
            return;
        }
        if (cacheInfo == emptyCacheInfo) {
            cacheInfo = this.newCacheInfo();
        }
        if (normalCacheKey != null) {
            JsonElement attributesToCache = uncachedAttributes == null ? this.container.getAttributesFromContainer(normalPathKey, normalCacheKey) : uncachedAttributes;
            this.updateCacheAttributes(cacheInfo, normalCacheKey, attributesToCache);
            if (normalCacheKey.equals(".zgroup")) {
                if (this.container.isGroupFromAttributes(normalCacheKey, attributesToCache)) {
                    this.updateCacheIsGroup(cacheInfo, true);
                    this.updateCacheIsDataset(cacheInfo, false);
                }
            } else if (normalCacheKey.equals(".zarray") && this.container.isDatasetFromAttributes(normalCacheKey, attributesToCache)) {
                this.updateCacheIsGroup(cacheInfo, false);
                this.updateCacheIsDataset(cacheInfo, true);
            }
        } else {
            this.updateCacheIsGroup(cacheInfo, this.container.isGroupFromContainer(normalPathKey));
            this.updateCacheIsDataset(cacheInfo, this.container.isDatasetFromContainer(normalPathKey));
        }
        this.updateCache(normalPathKey, cacheInfo);
    }

    public N5JsonCache.N5CacheInfo addNewCacheInfo(String normalPathKey, String normalCacheKey, JsonElement uncachedAttributes) {
        return this.cacheGroupAndDataset(normalPathKey);
    }

    @Deprecated
    public N5JsonCache.N5CacheInfo forceAddNewCacheInfo(String normalPathKey, String normalCacheKey, JsonElement uncachedAttributes, boolean isGroup, boolean isDataset) {
        N5JsonCache.N5CacheInfo cacheInfo = this.getCacheInfo(normalPathKey);
        if (cacheInfo == null || cacheInfo == emptyCacheInfo) {
            cacheInfo = this.newCacheInfo();
        }
        this.updateCacheAttributes(cacheInfo, ".zgroup", null);
        this.updateCacheAttributes(cacheInfo, ".zarray", null);
        this.updateCacheAttributes(cacheInfo, ".zattrs", null);
        if (normalCacheKey != null) {
            this.updateCacheAttributes(cacheInfo, normalCacheKey, uncachedAttributes);
        }
        this.updateCacheIsGroup(cacheInfo, isGroup);
        this.updateCacheIsDataset(cacheInfo, isDataset);
        this.updateCache(normalPathKey, cacheInfo);
        return cacheInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonElement getAttributes(String normalPathKey, String normalCacheKey) {
        N5JsonCache.N5CacheInfo cacheInfo = this.getCacheInfo(normalPathKey);
        if (cacheInfo == null) {
            this.cacheGroupAndDataset(normalPathKey);
            cacheInfo = this.getCacheInfo(normalPathKey);
        }
        if (cacheInfo == emptyCacheInfo || cacheInfo.getCache(normalCacheKey) == emptyJson) {
            return null;
        }
        N5JsonCache.N5CacheInfo n5CacheInfo = cacheInfo;
        synchronized (n5CacheInfo) {
            if (!cacheInfo.containsKey(normalCacheKey)) {
                this.updateCacheInfo(normalPathKey, normalCacheKey, null);
            }
        }
        JsonElement output = cacheInfo.getCache(normalCacheKey);
        return output == null ? null : output.deepCopy();
    }

    public boolean isDataset(String normalPathKey, String normalCacheKey) {
        N5JsonCache.N5CacheInfo cacheInfo = this.getCacheInfo(normalPathKey);
        if (cacheInfo == null) {
            this.cacheGroupAndDataset(normalPathKey);
            cacheInfo = this.getCacheInfo(normalPathKey);
        } else {
            if (cacheInfo == emptyCacheInfo || cacheInfo.isGroup()) {
                return cacheInfo.isDataset();
            }
            if (!cacheInfo.containsKey(".zarray")) {
                this.updateCacheIsDataset(cacheInfo, this.container.isDatasetFromContainer(normalPathKey));
            }
        }
        return cacheInfo.isDataset();
    }

    public boolean isGroup(String normalPathKey, String normalCacheKey) {
        N5JsonCache.N5CacheInfo cacheInfo = this.getCacheInfo(normalPathKey);
        if (cacheInfo == null) {
            this.cacheGroupAndDataset(normalPathKey);
            cacheInfo = this.getCacheInfo(normalPathKey);
        } else {
            if (cacheInfo == emptyCacheInfo || cacheInfo.isDataset()) {
                return cacheInfo.isGroup();
            }
            if (!cacheInfo.containsKey(".zgroup")) {
                this.updateCacheIsGroup(cacheInfo, this.container.isGroupFromContainer(normalPathKey));
            }
        }
        return cacheInfo.isGroup();
    }

    public N5JsonCache.N5CacheInfo cacheGroupAndDataset(String normalPathKey) {
        JsonElement zgroup = this.container.getAttributesFromContainer(normalPathKey, ".zgroup");
        boolean isGroup = this.container.isGroupFromAttributes(normalPathKey, zgroup);
        JsonElement zarray = this.container.getAttributesFromContainer(normalPathKey, ".zarray");
        boolean isDataset = this.container.isGroupFromAttributes(normalPathKey, zarray);
        if (isGroup || isDataset) {
            N5JsonCache.N5CacheInfo cacheInfo = this.newCacheInfo();
            this.updateCacheIsGroup(cacheInfo, isGroup);
            this.updateCacheAttributes(cacheInfo, ".zgroup", zgroup);
            this.updateCacheIsDataset(cacheInfo, isDataset);
            this.updateCacheAttributes(cacheInfo, ".zarray", zarray);
            this.updateCache(normalPathKey, cacheInfo);
            return cacheInfo;
        }
        this.updateCache(normalPathKey, emptyCacheInfo);
        return emptyCacheInfo;
    }

    public N5JsonCache.N5CacheInfo cacheAttributes(String normalPathKey, String normalCacheKey) {
        N5JsonCache.N5CacheInfo cacheInfo = this.getCacheInfo(normalPathKey);
        if (cacheInfo != null) {
            JsonElement zattrs = this.container.getAttributesFromContainer(normalPathKey, normalCacheKey);
            this.updateCacheAttributes(cacheInfo, normalCacheKey, zattrs);
        }
        return cacheInfo;
    }
}

