/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geom.real;

import java.util.List;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.BoundaryType;
import net.imglib2.roi.geom.GeomMaths;
import net.imglib2.roi.geom.real.DefaultWritablePolygon2D;

public class ClosedWritablePolygon2D
extends DefaultWritablePolygon2D {
    public ClosedWritablePolygon2D(List<? extends RealLocalizable> vertices) {
        super(vertices);
    }

    public ClosedWritablePolygon2D(double[] x, double[] y) {
        super(x, y);
    }

    @Override
    public boolean test(RealLocalizable localizable) {
        boolean edge = false;
        double[] pt1 = new double[2];
        double[] pt2 = new double[2];
        for (int i = 0; i < this.x.size(); ++i) {
            pt1[0] = this.x.get(i);
            pt1[1] = this.y.get(i);
            if (i == this.x.size() - 1) {
                pt2[0] = this.x.get(0);
                pt2[1] = this.y.get(0);
            } else {
                pt2[0] = this.x.get(i + 1);
                pt2[1] = this.y.get(i + 1);
            }
            edge = GeomMaths.lineContains(pt1, pt2, localizable, 2);
            if (!edge) continue;
            return true;
        }
        return GeomMaths.pnpoly(this.x, this.y, localizable);
    }

    @Override
    public BoundaryType boundaryType() {
        return BoundaryType.CLOSED;
    }
}

