/*
 * Decompiled with CFR 0.152.
 */
package org.blosc;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.NativeLongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.blosc.BufferSizes;
import org.blosc.IBloscDll;

public class JBlosc {
    public static final int OVERHEAD = 16;

    public JBlosc() {
        this.init();
    }

    public void init() {
        IBloscDll.blosc_init();
    }

    public void destroy() {
        IBloscDll.blosc_destroy();
    }

    public void setNumThreads(int nthreads) {
        IBloscDll.blosc_set_nthreads(nthreads);
    }

    public int getNumThreads() {
        return IBloscDll.blosc_get_nthreads();
    }

    public String listCompressors() {
        return IBloscDll.blosc_list_compressors();
    }

    public void setCompressor(String compname) {
        IBloscDll.blosc_set_compressor(compname);
    }

    public String getCompressor() {
        return IBloscDll.blosc_get_compressor();
    }

    public int compnameToCompcode(String compname) {
        return IBloscDll.blosc_compname_to_compcode(compname);
    }

    public String compcodeToCompname(int compcode) {
        PointerByReference ptr = new PointerByReference();
        IBloscDll.blosc_compcode_to_compname(compcode, ptr);
        Pointer p = ptr.getValue();
        return p.getString(0L);
    }

    public String getVersionString() {
        return IBloscDll.blosc_get_version_string();
    }

    String[] getComplibInfo(String compname) {
        PointerByReference ptrComplib = new PointerByReference();
        PointerByReference ptrVersion = new PointerByReference();
        int compcode = IBloscDll.blosc_get_complib_info(compname, ptrComplib, ptrVersion);
        if (compcode == -1) {
            throw new IllegalArgumentException();
        }
        String[] result = new String[]{ptrComplib.getValue().getString(0L), ptrVersion.getValue().getString(0L)};
        return result;
    }

    public void freeResources() {
        if (IBloscDll.blosc_free_resources() == -1) {
            throw new RuntimeException();
        }
    }

    public int getBlocksize() {
        return IBloscDll.blosc_get_blocksize();
    }

    public static void setBlocksize(long blocksize) {
        IBloscDll.blosc_set_blocksize(new NativeLong(blocksize));
    }

    public BufferSizes cbufferSizes(ByteBuffer cbuffer) {
        NativeLongByReference nbytes = new NativeLongByReference();
        NativeLongByReference cbytes = new NativeLongByReference();
        NativeLongByReference blocksize = new NativeLongByReference();
        IBloscDll.blosc_cbuffer_sizes(cbuffer, nbytes, cbytes, blocksize);
        BufferSizes bs = new BufferSizes(nbytes.getValue().longValue(), cbytes.getValue().longValue(), blocksize.getValue().longValue());
        return bs;
    }

    private void checkSizes(long srcLength, long destLength) {
        if (srcLength > 0x7FFFFFEFL) {
            throw new IllegalArgumentException("Source array is too large");
        }
        if (destLength < srcLength + 16L) {
            throw new IllegalArgumentException("Dest array is not large enough.");
        }
    }

    private static void checkExit(int w) {
        if (w == 0) {
            throw new RuntimeException("Compressed size larger then dest length");
        }
        if (w == -1) {
            throw new RuntimeException("Error compressing data");
        }
    }

    public int compress(int compressionLevel, int shuffleType, int typeSize, ByteBuffer src, long srcLength, ByteBuffer dest, long destLength) {
        this.checkSizes(srcLength, destLength);
        src.position(0);
        dest.position(0);
        src.order(ByteOrder.nativeOrder());
        dest.order(ByteOrder.nativeOrder());
        int w = IBloscDll.blosc_compress(compressionLevel, shuffleType, new NativeLong((long)typeSize), new NativeLong(srcLength), src, dest, new NativeLong(destLength));
        JBlosc.checkExit(w);
        return w;
    }

    public int decompress(Buffer src, Buffer dest, long destSize) {
        src.position(0);
        dest.position(0);
        return IBloscDll.blosc_decompress(src, dest, new NativeLong(destSize));
    }

    public static int compressCtx(int compressionLevel, int shuffleType, int typeSize, ByteBuffer src, long srcLength, ByteBuffer dest, long destLength, String compressorName, int blockSize, int numThreads) {
        src.position(0);
        dest.position(0);
        int w = IBloscDll.blosc_compress_ctx(compressionLevel, shuffleType, new NativeLong((long)typeSize), new NativeLong(srcLength), src, dest, new NativeLong(destLength), compressorName, new NativeLong((long)blockSize), numThreads);
        JBlosc.checkExit(w);
        return w;
    }

    public static int decompressCtx(Buffer src, Buffer dest, long destSize, int numThreads) {
        src.position(0);
        dest.position(0);
        return IBloscDll.blosc_decompress_ctx(src, dest, new NativeLong(destSize), numThreads);
    }

    public void cbufferMetainfo(Buffer cbuffer, NativeLongByReference typesize, IntByReference flags) {
        IBloscDll.blosc_cbuffer_metainfo(cbuffer, typesize, flags);
    }

    public void cbufferVersions(Buffer cbuffer, IntByReference version, IntByReference versionlz) {
        IBloscDll.blosc_cbuffer_versions(cbuffer, version, versionlz);
    }

    public Buffer cbufferComplib(Buffer cbuffer) {
        return IBloscDll.blosc_cbuffer_complib(cbuffer);
    }
}

