/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJMatrix;

public class VJLight {
    private float x;
    private float y;
    private float z;
    public float tx;
    public float ty;
    public float tz;
    private final float EPSILON = 1.0E-9f;
    public float diffuse;
    public float specular;

    public VJLight(float x, float y, float z, float diffuse, float specular) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.diffuse = diffuse;
        this.specular = specular;
        this.setNormalized(x, y, z);
    }

    public String toString() {
        return "light (" + this.x + "," + this.y + "," + this.z + "); ";
    }

    public String toLongString() {
        return "light (" + this.x + "," + this.y + "," + this.z + ") " + this.tx + "," + this.ty + "," + this.tz;
    }

    public void objectify(VJMatrix m) {
        float[] v = VJMatrix.newVector(this.x, this.y, this.z);
        float[] tv = m.mul(v);
        this.setNormalized(tv[0], tv[1], tv[2]);
    }

    private void setNormalized(float tx, float ty, float tz) {
        float mag = (float)Math.sqrt(Math.pow(tx, 2.0) + Math.pow(ty, 2.0) + Math.pow(tz, 2.0));
        if (mag > 1.0E-9f) {
            this.tx = tx / mag;
            this.ty = ty / mag;
            this.tz = tz / mag;
        } else {
            this.tx = tx;
            this.ty = ty;
            this.tz = tz;
        }
    }

    public float getSpecular() {
        return this.specular;
    }

    public float getDiffuse() {
        return this.diffuse;
    }

    public float getx() {
        return this.tx;
    }

    public float gety() {
        return this.ty;
    }

    public float getz() {
        return this.tz;
    }
}

