/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Vector;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class ExtractTextAsWordlist {
    public static boolean outputMessages = true;
    private int wordsExtracted = 0;
    private String user_dir = System.getProperty("user.dir");
    String separator = System.getProperty("file.separator");
    PdfDecoder decodePdf = null;
    private String outputDir = "";
    private boolean isFile = true;
    private byte[] byteArray = null;
    public static boolean isTest = false;

    public ExtractTextAsWordlist() {
    }

    public ExtractTextAsWordlist(String string) {
        if (outputMessages) {
            System.out.println("processing " + string);
        }
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = this.user_dir + this.separator;
        }
        if (string.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(string);
        } else {
            String[] stringArray = null;
            File file = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                file = new File(string);
                if (!file.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                }
                stringArray = file.list();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            long l = stringArray.length;
            int n = 0;
            while ((long)n < l) {
                if (stringArray[n].toLowerCase().endsWith(".pdf")) {
                    if (outputMessages) {
                        System.out.println(string + stringArray[n]);
                    }
                    this.decodeFile(string + stringArray[n]);
                }
                ++n;
            }
        }
    }

    public ExtractTextAsWordlist(byte[] byArray) {
        if (outputMessages) {
            System.out.println("processing byte array");
        }
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = this.user_dir + this.separator;
        }
        this.byteArray = byArray;
        this.isFile = false;
        this.decodeFile("byteArray");
    }

    private void decodeFile(String string) {
        PdfDecoder.useTextExtraction();
        String string2 = "demo";
        int n = string.lastIndexOf(this.separator);
        if (n != -1) {
            string2 = string.substring(n + 1, string.length() - 4);
        }
        this.outputDir = this.user_dir + "text" + this.separator + string2 + this.separator;
        try {
            this.decodePdf = new PdfDecoder(false);
            this.decodePdf.setExtractionMode(1);
            this.decodePdf.init(true);
            PdfGroupingAlgorithms.useUnrotatedCoords = false;
            if (outputMessages) {
                System.out.println("Opening file :" + string);
            }
            if (this.isFile) {
                this.decodePdf.openPdfFile(string);
            } else {
                this.decodePdf.openPdfArray(this.byteArray);
            }
        }
        catch (PdfSecurityException pdfSecurityException) {
            System.err.println("Exception " + pdfSecurityException + " in pdf code for wordlist" + string);
        }
        catch (PdfException pdfException) {
            System.err.println("Exception " + pdfException + " in pdf code for wordlist" + string);
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " in pdf code for wordlist" + string);
            exception.printStackTrace();
        }
        if (!this.decodePdf.isExtractionAllowed()) {
            if (outputMessages) {
                System.out.println("Text extraction not allowed");
            }
        } else if (this.decodePdf.isEncrypted() && !this.decodePdf.isPasswordSupplied()) {
            if (outputMessages) {
                System.out.println("Encrypted settings");
                System.out.println("Please look at SimpleViewer for code sample to handle such files");
            }
        } else {
            int n2 = 1;
            int n3 = this.decodePdf.getPageCount();
            if (n3 > 10 && isTest) {
                n3 = 10;
            }
            try {
                for (int i = n2; i < n3 + 1; ++i) {
                    this.decodePdf.decodePage(i);
                    PdfGroupingAlgorithms pdfGroupingAlgorithms = this.decodePdf.getGroupingObject();
                    PdfPageData pdfPageData = this.decodePdf.getPdfPageData();
                    int n4 = pdfPageData.getMediaBoxX(i);
                    int n5 = pdfPageData.getMediaBoxWidth(i) + n4;
                    int n6 = pdfPageData.getMediaBoxX(i);
                    int n7 = pdfPageData.getMediaBoxHeight(i) - n6;
                    if (outputMessages) {
                        System.out.println("Page " + i + " Extracting text from rectangle (" + n4 + "," + n7 + " " + n5 + "," + n6 + ")");
                    }
                    Vector vector = null;
                    try {
                        vector = pdfGroupingAlgorithms.extractTextAsWordlist(n4, n7, n5, n6, i, false, true, "&:=()!;.,\\/\"\"''");
                    }
                    catch (PdfException pdfException) {
                        this.decodePdf.closePdfFile();
                        System.err.println("Exception= " + pdfException + " in " + string);
                    }
                    if (vector == null) {
                        if (outputMessages) {
                            System.out.println("No text found");
                        }
                    } else {
                        File file = new File(this.outputDir);
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                        int n8 = vector.size() / 5;
                        this.wordsExtracted += n8;
                        if (outputMessages) {
                            System.out.println("Page contains " + n8 + " words.");
                        }
                        if (outputMessages) {
                            System.out.println("Writing to " + this.outputDir + "words-" + i + ".txt");
                        }
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputDir + "words-" + i + ".txt"), "UTF-8");
                        Iterator iterator = vector.iterator();
                        while (iterator.hasNext()) {
                            String string3 = (String)iterator.next();
                            string3 = Strip.convertToText(string3);
                            int n9 = (int)Float.parseFloat((String)iterator.next());
                            int n10 = (int)Float.parseFloat((String)iterator.next());
                            int n11 = (int)Float.parseFloat((String)iterator.next());
                            int n12 = (int)Float.parseFloat((String)iterator.next());
                            outputStreamWriter.write(string3 + "," + n9 + "," + n10 + "," + n11 + "," + n12 + "\n");
                        }
                        outputStreamWriter.close();
                    }
                    this.decodePdf.flushObjectValues(false);
                }
            }
            catch (Exception exception) {
                this.decodePdf.closePdfFile();
                System.err.println("Exception " + exception + " in " + string);
                exception.printStackTrace();
            }
            this.decodePdf.flushObjectValues(true);
            if (outputMessages) {
                System.out.println("Text read");
            }
        }
        this.decodePdf.closePdfFile();
        this.decodePdf = null;
    }

    public static void main(String[] stringArray) {
        File file;
        if (outputMessages) {
            System.out.println("Simple demo to extract text objects");
        }
        String string = "";
        if (stringArray.length == 1) {
            string = stringArray[0];
            if (outputMessages) {
                System.out.println("File :" + string);
            }
        } else {
            System.out.println("You must pass ONE parameter - a filename or directory in as a parameter");
            System.out.println("Make sure you put double quotes around the value if it has spaces");
            System.exit(1);
        }
        if (!(file = new File(string)).exists()) {
            System.out.println("File " + string + " not found");
        }
        ExtractTextAsWordlist extractTextAsWordlist = new ExtractTextAsWordlist(string);
    }

    public int getWordsExtractedCount() {
        return this.wordsExtracted;
    }
}

