/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.example;

import edu.utexas.clm.archipelago.Cluster;
import edu.utexas.clm.archipelago.compute.SerializableCallable;
import ij.IJ;
import ij.plugin.PlugIn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class Equality_Example
implements PlugIn {
    private final HashMap<Integer, Float> ifmap = new HashMap();
    private final HashMap<Float, Integer> fimap = new HashMap();
    private final HashMap<Float, Float> ffmap = new HashMap();
    private final AtomicInteger uid = new AtomicInteger(0);

    public void run(String arg) {
        ExecutorService executorService = Cluster.activeCluster() ? Cluster.getCluster().getService(1) : Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<Future<ArrayList<Float>>> futures = new ArrayList<Future<ArrayList<Float>>>();
        for (int i = 0; i < 128; ++i) {
            ArrayList<Float> arrayList = new ArrayList<Float>();
            Float f = new Float(i);
            Integer id = this.uid.getAndIncrement();
            arrayList.add(f);
            this.ifmap.put(id, f);
            this.fimap.put(f, id);
            this.ffmap.put(f, f);
            futures.add(executorService.submit(new EqCall(arrayList)));
        }
        try {
            for (Future future : futures) {
                Float fc = (Float)((ArrayList)future.get()).get(0);
                Float fo = this.ffmap.get(fc);
                String eqstr = fo == fc ? "they are equal" : "they are unequal";
                IJ.log((String)("Got back float " + fc + " keyed to " + fo + " and " + eqstr));
            }
        }
        catch (InterruptedException ie) {
            IJ.log((String)("Woops: " + ie));
        }
        catch (ExecutionException ee) {
            IJ.log((String)("Woops: " + ee));
        }
    }

    public static class EqCall
    implements SerializableCallable<ArrayList<Float>> {
        private final ArrayList<Float> floats;

        public EqCall(ArrayList<Float> floats) {
            this.floats = floats;
        }

        @Override
        public ArrayList<Float> call() throws Exception {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.floats;
        }
    }
}

