/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.utils;

public class FastSqrt {
    private FastSqrt() {
    }

    public static float sqrt(float number) {
        return number * FastSqrt.inverseSqrt(number);
    }

    private static float inverseSqrt(float number) {
        float x2 = number * 0.5f;
        float y = FastSqrt.fastInverseSqrt(number);
        y *= 1.5f - x2 * y * y;
        y *= 1.5f - x2 * y * y;
        y *= 1.5f - x2 * y * y;
        y *= 1.5f - x2 * y * y;
        return y;
    }

    private static float fastInverseSqrt(float number) {
        return Float.intBitsToFloat(1597463007 - (Float.floatToRawIntBits(number) >> 1));
    }

    public static double sqrt(double number) {
        return number * FastSqrt.inverseSqrt(number);
    }

    private static double inverseSqrt(double number) {
        double x2 = number * 0.5;
        double y = FastSqrt.fastInverseSqrt(number);
        y *= 1.5 - x2 * y * y;
        y *= 1.5 - x2 * y * y;
        y *= 1.5 - x2 * y * y;
        y *= 1.5 - x2 * y * y;
        y *= 1.5 - x2 * y * y;
        return y;
    }

    private static double fastInverseSqrt(double number) {
        return Double.longBitsToDouble(6910469410427058089L - (Double.doubleToRawLongBits(number) >> 1));
    }
}

