/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.commands;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.scijava.command.Command;
import org.scijava.event.EventDetails;
import org.scijava.event.EventHistory;
import org.scijava.event.EventHistoryListener;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.commands.WatchEventsFrame;

@Plugin(type=Command.class, menuPath="Plugins>Debug>Watch Events")
public class WatchEvents
implements Command,
EventHistoryListener {
    @Parameter
    private EventHistory eventHistory;
    @Parameter
    private LogService log;
    private WatchEventsFrame watchEventsFrame;

    public void run() {
        this.watchEventsFrame = new WatchEventsFrame(this.eventHistory, this.log);
        this.eventHistory.addListener((EventHistoryListener)this);
        this.watchEventsFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WatchEvents.this.eventHistory.removeListener((EventHistoryListener)WatchEvents.this);
            }
        });
        this.watchEventsFrame.setVisible(true);
    }

    public void eventOccurred(EventDetails details) {
        this.watchEventsFrame.append(details);
    }
}

