/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks.downsample;

import net.imglib2.Interval;
import net.imglib2.algorithm.blocks.downsample.AbstractDownsample;
import net.imglib2.type.PrimitiveType;
import net.imglib2.util.Util;

abstract class AbstractDownsampleAvgBlock<T extends AbstractDownsampleAvgBlock<T, P>, P>
extends AbstractDownsample<T, P> {
    final int[] downsamplingFactors;

    AbstractDownsampleAvgBlock(int[] downsamplingFactors, PrimitiveType primitiveType) {
        super(AbstractDownsampleAvgBlock.downsampleInDim(downsamplingFactors), primitiveType);
        this.downsamplingFactors = downsamplingFactors;
    }

    private static boolean[] downsampleInDim(int[] downsamplingFactors) {
        int n = downsamplingFactors.length;
        boolean[] downsampleInDim = new boolean[n];
        for (int d = 0; d < n; ++d) {
            if (downsamplingFactors[d] < 1) {
                throw new IllegalArgumentException();
            }
            downsampleInDim[d] = downsamplingFactors[d] > 1;
        }
        return downsampleInDim;
    }

    AbstractDownsampleAvgBlock(T downsample) {
        super(downsample);
        this.downsamplingFactors = ((AbstractDownsampleAvgBlock)downsample).downsamplingFactors;
    }

    @Override
    public void setTargetInterval(Interval interval) {
        boolean destSizeChanged = false;
        for (int d = 0; d < this.n; ++d) {
            long tpos = interval.min(d);
            this.sourcePos[d] = tpos * (long)this.downsamplingFactors[d];
            int tdim = Util.safeInt(interval.dimension(d));
            if (tdim == this.destSize[d]) continue;
            this.destSize[d] = tdim;
            this.sourceSize[d] = tdim * this.downsamplingFactors[d];
            destSizeChanged = true;
        }
        if (destSizeChanged) {
            this.recomputeTempArraySizes();
        }
    }
}

