/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.stats;

import java.util.ArrayList;
import java.util.Arrays;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.Algorithm;
import net.imglib2.algorithm.Benchmark;
import net.imglib2.algorithm.stats.HistogramBinMapper;
import net.imglib2.img.Img;

public class Histogram<T>
implements Algorithm,
Benchmark {
    private long pTime = 0L;
    private final int[] histogram;
    private final RealCursor<T> cursor;
    private final HistogramBinMapper<T> binMapper;

    public Histogram(HistogramBinMapper<T> mapper, RealCursor<T> c) {
        this.cursor = c;
        this.binMapper = mapper;
        this.histogram = new int[this.binMapper.getNumBins()];
    }

    public Histogram(HistogramBinMapper<T> mapper, Img<T> image) {
        this(mapper, image.cursor());
    }

    public void reset() {
        Arrays.fill(this.histogram, 0);
        this.cursor.reset();
    }

    public int getBin(T t) {
        return this.getHistogram()[this.binMapper.map(t)];
    }

    public int getBin(int i) {
        return this.getHistogram()[i];
    }

    public HistogramBinMapper<T> getBinMapper() {
        return this.binMapper;
    }

    public int[] getHistogram() {
        return this.histogram;
    }

    public T getBinCenter(int i) {
        return this.getBinMapper().invMap(i);
    }

    public ArrayList<T> getBinCenters() {
        ArrayList<T> binCenters = new ArrayList<T>(this.histogram.length);
        for (int i = 0; i < this.histogram.length; ++i) {
            binCenters.add(i, this.getBinMapper().invMap(i));
        }
        return binCenters;
    }

    public int getNumBins() {
        return this.getBinMapper().getNumBins();
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        while (this.cursor.hasNext()) {
            this.cursor.fwd();
            int index = this.binMapper.map(this.cursor.get());
            if (index < 0 || index >= this.histogram.length) continue;
            int n = index;
            this.histogram[n] = this.histogram[n] + 1;
        }
        this.pTime = System.currentTimeMillis() - startTime;
        return true;
    }

    @Override
    public long getProcessingTime() {
        return this.pTime;
    }
}

