/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour.io.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.List;
import org.scijava.ui.behaviour.io.InputTriggerDescription;

public class JsonConfigIO {
    public static void write(List<InputTriggerDescription> descriptions, Writer writer) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        gson.toJson(descriptions, (Appendable)writer);
    }

    public static void write(List<InputTriggerDescription> descriptions, String fileName) throws IOException {
        FileWriter writer = new FileWriter(fileName);
        JsonConfigIO.write(descriptions, writer);
        writer.close();
    }

    public static List<InputTriggerDescription> read(Reader reader) {
        Gson gson = new GsonBuilder().create();
        Type type = new TypeToken<List<InputTriggerDescription>>(){}.getType();
        List descriptions = (List)gson.fromJson(reader, type);
        return descriptions;
    }

    public static List<InputTriggerDescription> read(String fileName) throws IOException {
        FileReader reader = new FileReader(fileName);
        List<InputTriggerDescription> descriptions = JsonConfigIO.read(reader);
        reader.close();
        return descriptions;
    }
}

