/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.axispos;

import java.util.ArrayList;
import net.imagej.animation.Animation;
import net.imagej.animation.AnimationService;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.display.ImageDisplay;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Axes", mnemonic=97), @Menu(label="Set Active Axis...")}, headless=true)
public class SetActiveAxis
extends DynamicCommand {
    private static final String AXIS_NAME = "axisName";
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;
    @Parameter(persist=false, initializer="initAxisName")
    private String axisName;
    @Parameter
    private AnimationService animationService;

    public ImageDisplay getDisplay() {
        return this.display;
    }

    public void setDisplay(ImageDisplay display) {
        this.display = display;
    }

    public AxisType getAxis() {
        return Axes.get((String)this.axisName);
    }

    public void setAxis(AxisType axis) {
        this.axisName = axis.toString();
    }

    public void run() {
        AxisType axis = this.getAxis();
        if (axis != null) {
            this.display.setActiveAxis(axis);
            int axisIndex = this.display.dimensionIndex(axis);
            long last = this.display.dimension(axisIndex) - 1L;
            Animation a = this.animationService.getAnimation(this.display);
            boolean active = a.isActive();
            if (active) {
                a.stop();
            }
            a.setAxis(axis);
            a.setFirst(0L);
            a.setLast(last);
            if (active) {
                a.start();
            }
        }
    }

    protected void initAxisName() {
        MutableModuleItem axisNameItem = this.getInfo().getMutableInput(AXIS_NAME, String.class);
        ArrayList<String> choices = new ArrayList<String>();
        for (int d = 0; d < this.display.numDimensions(); ++d) {
            AxisType axisType = ((CalibratedAxis)this.display.axis(d)).type();
            if (axisType.isXY()) continue;
            choices.add(axisType.getLabel());
        }
        axisNameItem.setChoices(choices);
    }
}

