/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.MultiLineLabel;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import ij.plugin.frame.RoiManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelSeparator;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.services.OMEXMLService;
import loci.plugins.BF;
import loci.plugins.in.ImporterOptions;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.Model;
import mpicbg.models.TranslationModel2D;
import mpicbg.models.TranslationModel3D;
import mpicbg.stitching.CollectionStitchingImgLib;
import mpicbg.stitching.Downsampler;
import mpicbg.stitching.ImageCollectionElement;
import mpicbg.stitching.ImagePlusTimePoint;
import mpicbg.stitching.StitchingParameters;
import mpicbg.stitching.TextFileAccess;
import mpicbg.stitching.fusion.Fusion;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import ome.units.quantity.Length;
import plugin.GridType;
import stitching.CommonFunctions;
import stitching.utils.Log;
import tools.RoiPicker;

public class Stitching_Grid
implements PlugIn {
    public static final String version = "1.2";
    private final String myURL = "http://fly.mpi-cbg.de/preibisch";
    public static boolean seperateOverlapY = false;
    public static int defaultGridChoice1 = 0;
    public static int defaultGridChoice2 = 0;
    public static int defaultGridSizeX = 2;
    public static int defaultGridSizeY = 3;
    public static double defaultOverlapX = 20.0;
    public static double defaultOverlapY = 20.0;
    public static String defaultDirectory = "";
    public static String defaultSeriesFile = "";
    public static boolean defaultConfirmFiles = true;
    public static String defaultFileNames = "tile_{ii}.tif";
    public static String defaultTileConfiguration = "TileConfiguration.txt";
    public static boolean defaultAddTilesAsRois = false;
    public static boolean defaultComputeOverlap = true;
    public static boolean defaultInvertX = false;
    public static boolean defaultInvertY = false;
    public static boolean defaultIgnoreZStage = false;
    public static boolean defaultSubpixelAccuracy = false;
    public static boolean defaultDownSample = false;
    public static boolean defaultDisplayFusion = false;
    public static boolean writeOnlyTileConfStatic = false;
    public static boolean defaultIgnoreCalibration = false;
    public static double defaultIncreaseOverlap = 0.0;
    public static boolean defaultVirtualInput = false;
    public static int defaultStartI = 1;
    public static int defaultStartX = 1;
    public static int defaultStartY = 1;
    public static int defaultFusionMethod = 0;
    public static double defaultR = 0.3;
    public static double defaultRegressionThreshold = 0.3;
    public static double defaultDisplacementThresholdRelative = 2.5;
    public static double defaultDisplacementThresholdAbsolute = 3.5;
    public static boolean defaultOnlyPreview = false;
    public static int defaultMemorySpeedChoice = 0;
    public static double defaultSeqRange = 1.0;
    public static boolean defaultQuickFusion = true;
    public static String[] resultChoices = new String[]{"Fuse and display", "Write to disk"};
    public static int defaultResult = 0;
    public static String defaultOutputDirectory = "";
    int snakeDirectionX = 0;
    int snakeDirectionY = 0;

    public void run(String arg0) {
        ArrayList<ImagePlusTimePoint> optimized;
        ArrayList<ImageCollectionElement> elements;
        double increaseOverlap;
        boolean ignoreCalibration;
        boolean confirmFiles;
        String filenames;
        String directory;
        String outputFile;
        String seriesFile;
        double overlapY;
        double overlapX;
        int gridSizeY;
        int gridSizeX;
        Log.info("Stitching internal version: 1.2");
        GridType grid = new GridType();
        int gridType = grid.getType();
        int gridOrder = grid.getOrder();
        if (gridType == -1 || gridOrder == -1) {
            return;
        }
        GenericDialogPlus gd = new GenericDialogPlus("Grid stitching: " + GridType.choose1[gridType] + ", " + GridType.choose2[gridType][gridOrder]);
        if (gridType < 5) {
            gd.addNumericField("Grid_size_x", (double)defaultGridSizeX, 0);
            gd.addNumericField("Grid_size_y", (double)defaultGridSizeY, 0);
            if (seperateOverlapY) {
                gd.addSlider("Tile_overlap_x [%]", 0.0, 100.0, defaultOverlapX);
                gd.addSlider("Tile_overlap_y [%]", 0.0, 100.0, defaultOverlapY);
            } else {
                gd.addSlider("Tile_overlap [%]", 0.0, 100.0, defaultOverlapX);
            }
            if (grid.getType() < 4) {
                gd.addNumericField("First_file_index_i", (double)defaultStartI, 0);
            } else {
                gd.addNumericField("First_file_index_x", (double)defaultStartX, 0);
                gd.addNumericField("First_file_index_y", (double)defaultStartY, 0);
            }
        }
        if (gridType == 6 && gridOrder == 1) {
            gd.addFileField("Multi_series_file", defaultSeriesFile, 50);
        } else {
            gd.addDirectoryField("Directory", defaultDirectory, 50);
            if (gridType == 5 || gridType == 7) {
                gd.addCheckbox("Confirm_files", defaultConfirmFiles);
            }
            if (gridType < 5) {
                gd.addStringField("File_names for tiles", defaultFileNames, 50);
            }
            if (gridType == 6) {
                gd.addStringField("Layout_file", defaultTileConfiguration, 50);
            } else {
                gd.addStringField("Output_textfile_name", defaultTileConfiguration, 50);
            }
        }
        gd.addChoice("Fusion_method", CommonFunctions.fusionMethodListGrid, CommonFunctions.fusionMethodListGrid[defaultFusionMethod]);
        gd.addNumericField("Regression_threshold", defaultRegressionThreshold, 2);
        gd.addNumericField("Max/avg_displacement_threshold", defaultDisplacementThresholdRelative, 2);
        gd.addNumericField("Absolute_displacement_threshold", defaultDisplacementThresholdAbsolute, 2);
        if (gridType == 7) {
            gd.addNumericField("Frame range to compare", defaultSeqRange, 0);
        }
        gd.addCheckbox("Add_tiles_as_ROIs", defaultAddTilesAsRois);
        if (gridType < 5) {
            gd.addCheckbox("Compute_overlap (otherwise use approximate grid coordinates)", defaultComputeOverlap);
        } else if (gridType == 6 && gridOrder == 0) {
            gd.addCheckbox("Compute_overlap (otherwise apply coordinates from layout file)", defaultComputeOverlap);
        } else if (gridType == 6 && gridOrder == 1) {
            gd.addCheckbox("Compute_overlap (otherwise trust coordinates in the file)", defaultComputeOverlap);
            gd.addCheckbox("Ignore_Calibration", defaultIgnoreCalibration);
            gd.addSlider("Increase_overlap [%]", 0.0, 100.0, defaultIncreaseOverlap);
        }
        gd.addCheckbox("Invert_X coordinates", defaultInvertX);
        gd.addCheckbox("Invert_Y coordinates", defaultInvertY);
        gd.addCheckbox("Ignore_Z_stage position", defaultIgnoreZStage);
        gd.addCheckbox("Subpixel_accuracy", defaultSubpixelAccuracy);
        gd.addCheckbox("Downsample_tiles", defaultDownSample);
        gd.addCheckbox("Display_fusion", defaultDisplayFusion);
        gd.addCheckbox("Use_virtual_input_images (Slow! Even slower when combined with subpixel accuracy during fusion!)", defaultVirtualInput);
        gd.addChoice("Computation_parameters", CommonFunctions.cpuMemSelect, CommonFunctions.cpuMemSelect[defaultMemorySpeedChoice]);
        gd.addChoice("Image_output", resultChoices, resultChoices[defaultResult]);
        gd.addMessage("");
        gd.addMessage("This Plugin is developed by Stephan Preibisch\nhttp://fly.mpi-cbg.de/preibisch");
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        CommonFunctions.addHyperLinkListener(text, "http://fly.mpi-cbg.de/preibisch");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        StitchingParameters params = new StitchingParameters();
        int startI = 0;
        int startX = 0;
        int startY = 0;
        if (gridType < 5) {
            gridSizeX = defaultGridSizeX = (int)Math.round(gd.getNextNumber());
            gridSizeY = defaultGridSizeY = (int)Math.round(gd.getNextNumber());
            if (seperateOverlapY) {
                overlapX = defaultOverlapX = gd.getNextNumber();
                overlapX /= 100.0;
                overlapY = defaultOverlapY = gd.getNextNumber();
                overlapY /= 100.0;
            } else {
                defaultOverlapY = defaultOverlapX = gd.getNextNumber();
                overlapY = defaultOverlapX;
                overlapX = defaultOverlapX;
                overlapY = overlapX /= 100.0;
            }
            if (grid.getType() < 4) {
                startI = defaultStartI = (int)Math.round(gd.getNextNumber());
            } else {
                startX = defaultStartI = (int)Math.round(gd.getNextNumber());
                startY = defaultStartI = (int)Math.round(gd.getNextNumber());
            }
        } else {
            gridSizeY = 0;
            gridSizeX = 0;
            overlapY = 0.0;
            overlapX = 0.0;
        }
        if (gridType == 6 && gridOrder == 1) {
            seriesFile = defaultSeriesFile = gd.getNextString();
            outputFile = defaultTileConfiguration;
            directory = seriesFile.trim();
            directory = directory.replace('\\', '/');
            directory = directory.split("/[^/]*$")[0];
            filenames = null;
            confirmFiles = false;
        } else {
            directory = defaultDirectory = gd.getNextString();
            seriesFile = null;
            confirmFiles = gridType == 5 || gridType == 7 ? (defaultConfirmFiles = gd.getNextBoolean()) : false;
            filenames = gridType < 5 ? (defaultFileNames = gd.getNextString()) : "";
            outputFile = defaultTileConfiguration = gd.getNextString();
        }
        params.fusionMethod = defaultFusionMethod = gd.getNextChoiceIndex();
        params.regThreshold = defaultRegressionThreshold = gd.getNextNumber();
        params.relativeThreshold = defaultDisplacementThresholdRelative = gd.getNextNumber();
        params.absoluteThreshold = defaultDisplacementThresholdAbsolute = gd.getNextNumber();
        if (gridType == 7) {
            defaultSeqRange = Math.round(gd.getNextNumber());
            params.seqRange = (int)defaultSeqRange;
        }
        params.addTilesAsRois = defaultAddTilesAsRois = gd.getNextBoolean();
        boolean addTilesAsRois = defaultAddTilesAsRois;
        params.computeOverlap = gridType == 5 || gridType == 7 ? true : (defaultComputeOverlap = gd.getNextBoolean());
        if (gridType == 6 && gridOrder == 1) {
            ignoreCalibration = defaultIgnoreCalibration = gd.getNextBoolean();
            increaseOverlap = defaultIncreaseOverlap = gd.getNextNumber();
        } else {
            ignoreCalibration = false;
            increaseOverlap = 0.0;
        }
        params.invertX = defaultInvertX = gd.getNextBoolean();
        boolean invertX = defaultInvertX;
        params.invertY = defaultInvertY = gd.getNextBoolean();
        boolean invertY = defaultInvertY;
        params.ignoreZStage = defaultIgnoreZStage = gd.getNextBoolean();
        boolean ignoreZStage = defaultIgnoreZStage;
        params.subpixelAccuracy = defaultSubpixelAccuracy = gd.getNextBoolean();
        params.downSample = defaultDownSample = gd.getNextBoolean();
        boolean downSample = defaultDownSample;
        params.displayFusion = defaultDisplayFusion = gd.getNextBoolean();
        params.virtual = defaultVirtualInput = gd.getNextBoolean();
        params.cpuMemChoice = defaultMemorySpeedChoice = gd.getNextChoiceIndex();
        params.outputVariant = defaultResult = gd.getNextChoiceIndex();
        if (params.virtual) {
            Log.warn("Using virtual input images. This will save a lot of RAM, but will also be slower ... \n");
            if (params.subpixelAccuracy && params.fusionMethod != CommonFunctions.fusionMethodListGrid.length - 1) {
                Log.warn("You combine subpixel-accuracy with virtual input images, fusion will take 2-times longer ... \n");
            }
        }
        if (params.fusionMethod != CommonFunctions.fusionMethodListGrid.length - 1 && params.outputVariant == 1) {
            if (defaultOutputDirectory == null || defaultOutputDirectory.length() == 0) {
                defaultOutputDirectory = defaultDirectory;
            }
            GenericDialogPlus gd2 = new GenericDialogPlus("Select output directory");
            gd2.addDirectoryField("Output_directory", defaultOutputDirectory, 60);
            gd2.showDialog();
            if (gd2.wasCanceled()) {
                return;
            }
            params.outputDirectory = defaultOutputDirectory = gd2.getNextString();
        } else {
            params.outputDirectory = null;
        }
        long startTime = System.currentTimeMillis();
        params.channel1 = 0;
        params.channel2 = 0;
        params.timeSelect = 0;
        params.checkPeaks = 5;
        if (gridType == 7) {
            params.sequential = true;
        }
        if (gridType != 6 || gridOrder != 1) {
            directory = directory.replace('\\', '/');
            if ((directory = directory.trim()).length() > 0 && !directory.endsWith("/")) {
                directory = directory + "/";
            }
        }
        Downsampler ds = null;
        if (downSample && gridType != 5 && gridType != 7) {
            ds = new Downsampler();
        }
        if ((elements = gridType < 5 ? this.getGridLayout(grid, gridSizeX, gridSizeY, overlapX, overlapY, directory, filenames, startI, startX, startY, params.virtual, ds) : (gridType == 5 || gridType == 7 ? this.getAllFilesInDirectory(directory, confirmFiles) : (gridType == 6 && gridOrder == 1 ? this.getLayoutFromMultiSeriesFile(seriesFile, increaseOverlap, ignoreCalibration, invertX, invertY, ignoreZStage, ds) : (gridType == 6 ? this.getLayoutFromFile(directory, outputFile, ds) : null)))) == null) {
            Log.error("Error during tile discovery, or invalid grid type. Aborting.");
            return;
        }
        if (elements.size() < 2) {
            Log.error("Found: " + elements.size() + " tiles, but at least 2 are required for stitching. Aborting.");
            return;
        }
        int numChannels = -1;
        int numTimePoints = -1;
        boolean is2d = false;
        boolean is3d = false;
        for (ImageCollectionElement element : elements) {
            if (gridType >= 5) {
                if (params.virtual) {
                    Log.info("Opening VIRTUAL: " + element.getFile().getAbsolutePath() + " ... ");
                } else {
                    Log.info("Loading: " + element.getFile().getAbsolutePath() + " ... ");
                }
            }
            long time = System.currentTimeMillis();
            ImagePlus imp = element.open(params.virtual);
            time = System.currentTimeMillis() - time;
            if (imp == null) {
                return;
            }
            if (downSample && (gridType == 5 || gridType == 7)) {
                if (ds == null) {
                    ds = new Downsampler();
                    ds.getInput(imp.getWidth(), imp.getHeight());
                }
                ds.run(imp);
            }
            int lastNumChannels = numChannels;
            int lastNumTimePoints = numTimePoints;
            numChannels = imp.getNChannels();
            numTimePoints = imp.getNFrames();
            if (imp.getNSlices() > 1) {
                if (gridType >= 5) {
                    Log.info("" + imp.getWidth() + "x" + imp.getHeight() + "x" + imp.getNSlices() + "px, channels=" + numChannels + ", timepoints=" + numTimePoints + " (" + time + " ms)");
                }
                is3d = true;
            } else {
                if (gridType >= 5) {
                    Log.info("" + imp.getWidth() + "x" + imp.getHeight() + "px, channels=" + numChannels + ", timepoints=" + numTimePoints + " (" + time + " ms)");
                }
                is2d = true;
            }
            if (is2d && is3d) {
                Log.error("Some images are 2d, some are 3d ... cannot proceed");
                return;
            }
            if (lastNumChannels != numChannels && lastNumChannels != -1) {
                Log.error("Number of channels per image changes ... cannot proceed");
                return;
            }
            if (lastNumTimePoints != numTimePoints && lastNumTimePoints != -1) {
                Log.error("Number of timepoints per image changes ... cannot proceed");
                return;
            }
            if (gridType != 5 && gridType != 7) continue;
            if (is2d) {
                element.setDimensionality(2);
                element.setModel((Model<?>)new TranslationModel2D());
                element.setOffset(new float[]{0.0f, 0.0f});
                continue;
            }
            element.setDimensionality(3);
            element.setModel((Model<?>)new TranslationModel3D());
            element.setOffset(new float[]{0.0f, 0.0f, 0.0f});
        }
        int dimensionality = is2d ? 2 : 3;
        params.dimensionality = dimensionality;
        if (gridType != 6) {
            this.writeTileConfiguration(new File(directory, outputFile), elements);
        }
        if ((optimized = CollectionStitchingImgLib.stitchCollection(elements, params)) == null) {
            return;
        }
        for (ImagePlusTimePoint imt : optimized) {
            Log.info(imt.getImagePlus().getTitle() + ": " + imt.getModel());
        }
        if (params.computeOverlap && outputFile != null) {
            outputFile = outputFile.endsWith(".txt") ? outputFile.substring(0, outputFile.length() - 4) + ".registered.txt" : outputFile + ".registered.txt";
            this.writeRegisteredTileConfiguration(new File(directory, outputFile), elements);
        }
        if (params.fusionMethod != CommonFunctions.fusionMethodListGrid.length - 1) {
            boolean bl;
            long time = System.currentTimeMillis();
            if (params.outputDirectory == null) {
                Log.info("Fuse & Display ...");
            } else {
                Log.info("Fuse & Write to disk (into directory '" + new File(params.outputDirectory, "").getAbsolutePath() + "') ...");
            }
            IJ.showStatus((String)"Fusing stitched image...");
            ArrayList<InvertibleBoundable> models = new ArrayList<InvertibleBoundable>();
            ArrayList<ImagePlus> images = new ArrayList<ImagePlus>();
            boolean is32bit = false;
            boolean is16bit = false;
            boolean is8bit = false;
            for (ImagePlusTimePoint imagePlusTimePoint : optimized) {
                ImagePlus imp = imagePlusTimePoint.getImagePlus();
                if (imp.getType() == 2) {
                    is32bit = true;
                } else if (imp.getType() == 1) {
                    is16bit = true;
                } else if (imp.getType() == 0) {
                    is8bit = true;
                }
                images.add(imp);
            }
            for (int f = 1; f <= numTimePoints; ++f) {
                for (ImagePlusTimePoint imt : optimized) {
                    models.add((InvertibleBoundable)imt.getModel());
                }
            }
            ImagePlus imp = null;
            boolean bl2 = false;
            if (overlapX == 0.0 && overlapY == 0.0 && !params.computeOverlap && !params.subpixelAccuracy && grid.getType() < 4) {
                GenericDialogPlus gd3 = new GenericDialogPlus("Use fast fusion algorithm");
                gd3.addMessage("There seems to be no overlap between any of the tiles.");
                gd3.addCheckbox("Use fast fusion?", defaultQuickFusion);
                gd3.showDialog();
                if (gd3.wasCanceled()) {
                    return;
                }
                defaultQuickFusion = gd3.getNextBoolean();
                bl = defaultQuickFusion;
                if (bl) {
                    Log.info("There is no overlap between any of the tiles, using faster fusion algorithm.");
                }
            }
            if (is32bit) {
                imp = Fusion.fuse(new FloatType(), images, models, params.dimensionality, params.subpixelAccuracy, params.fusionMethod, params.outputDirectory, bl, false, params.displayFusion);
            } else if (is16bit) {
                imp = Fusion.fuse(new UnsignedShortType(), images, models, params.dimensionality, params.subpixelAccuracy, params.fusionMethod, params.outputDirectory, bl, false, params.displayFusion);
            } else if (is8bit) {
                imp = Fusion.fuse(new UnsignedByteType(), images, models, params.dimensionality, params.subpixelAccuracy, params.fusionMethod, params.outputDirectory, bl, false, params.displayFusion);
            } else {
                Log.error("Unknown image type for fusion.");
            }
            Log.info("Finished fusion (" + (System.currentTimeMillis() - time) + " ms)");
            Log.info("Finished ... (" + (System.currentTimeMillis() - startTime) + " ms)");
            if (imp != null) {
                imp.setTitle("Fused");
                imp.show();
            }
            if (addTilesAsRois) {
                double[] offset = new double[dimensionality];
                Fusion.estimateBounds(offset, new int[dimensionality], images, models, dimensionality);
                this.generateRois(offset, optimized);
                RoiManager rm = RoiManager.getInstance();
                if (imp == null) {
                    rm.runCommand("save", new File(params.outputDirectory, "tile_rois.zip").getAbsolutePath());
                } else {
                    rm.runCommand("Show All");
                    Toolbar bar = Toolbar.getInstance();
                    int roiPickerId = bar.getToolId(new RoiPicker().getToolName());
                    if (roiPickerId >= 0) {
                        bar.setTool(roiPickerId);
                    } else {
                        IJ.runPlugIn((String)RoiPicker.class.getName(), (String)"");
                    }
                }
            }
        }
        for (ImageCollectionElement element : elements) {
            element.close();
        }
    }

    protected void generateRois(double[] offsets, ArrayList<ImagePlusTimePoint> optimizedImages) {
        IJ.showStatus((String)"Generating ROIs from image tiles...");
        RoiManager rm = RoiManager.getInstance();
        if (rm == null) {
            rm = new RoiManager();
        }
        HashMap roisBySlice = new HashMap();
        IFormatReader reader = null;
        for (int i = 0; i < optimizedImages.size(); ++i) {
            int pixelOffset;
            ImagePlusTimePoint iptp = optimizedImages.get(i);
            reader = this.initializeReader(reader, iptp.getElement().getFile().getAbsolutePath());
            int sizeZ = reader.getSizeZ();
            int sizeT = reader.getSizeT();
            int sizeC = reader.getSizeC();
            String[] seriesFiles = reader.getSeriesUsedFiles(true);
            int n = pixelOffset = seriesFiles == null ? 0 : seriesFiles.length;
            if (reader.getSeriesCount() > 1) {
                reader.setSeries(i);
            }
            seriesFiles = reader.getSeriesUsedFiles();
            ImagePlus unfused = iptp.getImagePlus();
            int slice = 1;
            double[] coords = new double[iptp.getElement().getDimensionality()];
            iptp.getModel().applyInPlace(coords);
            for (int j = 0; j < offsets.length; ++j) {
                int n2 = j;
                coords[n2] = coords[n2] - offsets[j];
            }
            int coordXOffset = (int)Math.floor(coords[0]);
            int coordYOffset = (int)Math.floor(coords[1]);
            for (int t = 0; t < sizeT; ++t) {
                for (int z = 0; z < sizeZ; ++z) {
                    for (int c = 0; c < sizeC; ++c) {
                        Roi roi = new Roi(coordXOffset, coordYOffset, unfused.getWidth(), unfused.getHeight());
                        roi.setPosition(c + 1, z + 1, t + 1);
                        String roiName = "sp=" + slice + "; label=" + i + "; series=" + reader.getSeries() + "; C=" + (c + 1) + "; Z=" + (z + 1) + "; T=" + (t + 1);
                        if (reader != null) {
                            String sourceName = "unknown file " + reader.getIndex(z, c, t);
                            if (seriesFiles != null && seriesFiles.length > reader.getIndex(z, c, t) + pixelOffset) {
                                sourceName = new File(seriesFiles[reader.getIndex(z, c, t) + pixelOffset]).getName();
                            }
                            roiName = roiName + "; file=" + sourceName;
                        }
                        roi.setName(roiName);
                        if (roisBySlice.get(slice) == null) {
                            roisBySlice.put(slice, new ArrayList());
                        }
                        ((List)roisBySlice.get(slice)).add(roi);
                        ++slice;
                    }
                }
            }
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            Log.error("Failed to close Bio-Formats reader.");
        }
        Log.info("Adding ROIs...");
        ArrayList keys = new ArrayList(roisBySlice.keySet());
        Collections.sort(keys);
        for (Integer slice : keys) {
            for (Roi roi : (List)roisBySlice.get(slice)) {
                rm.add((ImagePlus)null, roi, 0);
            }
        }
        Log.info("ROIs generated.");
    }

    protected IFormatReader initializeReader(IFormatReader in, String file) {
        Log.info("Initializing Bio-Formats reader...");
        if (in == null || !file.equalsIgnoreCase(in.getCurrentFile())) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    Log.error("Failed to close Bio-Formats reader.");
                    return null;
                }
            }
            in = new ImageReader();
            IMetadata omeMeta = MetadataTools.createOMEXMLMetadata();
            in.setMetadataStore((MetadataStore)omeMeta);
            try {
                in.setId(file);
            }
            catch (FormatException e) {
                Log.error("Failed to discover file names. FormatException when parsing: " + file);
                return null;
            }
            catch (IOException e) {
                Log.error("Failed to discover file names. IOException when parsing: " + file);
                return null;
            }
        }
        return in;
    }

    protected ImagePlus[] openBF(String multiSeriesFileName, boolean splitC, boolean splitT, boolean splitZ, boolean autoScale, boolean crop, boolean allSeries) {
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setId(new File(multiSeriesFileName).getAbsolutePath());
            options.setSplitChannels(splitC);
            options.setSplitTimepoints(splitT);
            options.setSplitFocalPlanes(splitZ);
            options.setAutoscale(autoScale);
            options.setStackFormat("Hyperstack");
            options.setStackOrder("XYCZT");
            options.setCrop(crop);
            options.setOpenAllSeries(allSeries);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (Exception e) {
            Log.error("Cannot open multiseries file: " + e, e);
            return null;
        }
        return imps;
    }

    protected ImagePlus[] openBFDefault(String multiSeriesFileName) {
        return this.openBF(multiSeriesFileName, false, false, false, false, false, true);
    }

    protected ArrayList<ImageCollectionElement> getLayoutFromMultiSeriesFile(String multiSeriesFile, double increaseOverlap, boolean ignoreCalibration, boolean invertX, boolean invertY, boolean ignoreZStage, Downsampler ds) {
        boolean timeHack;
        if (multiSeriesFile == null || multiSeriesFile.length() == 0) {
            Log.error("Filename is empty!");
            return null;
        }
        ArrayList<ImageCollectionElement> elements = new ArrayList<ImageCollectionElement>();
        ChannelSeparator r = new ChannelSeparator();
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
            ImagePlus[] meta = service.createOMEXMLMetadata();
            r.setMetadataStore((MetadataStore)meta);
            r.setId(multiSeriesFile);
            int numSeries = r.getSeriesCount();
            Log.debug("numSeries:  " + numSeries);
            int dim = 2;
            for (int series = 0; series < numSeries; ++series) {
                if (r.getSizeZ() <= 1) continue;
                dim = 3;
            }
            Log.debug("dim:  " + dim);
            MetadataRetrieve retrieve = service.asRetrieve(r.getMetadataStore());
            Log.debug("retrieve:  " + retrieve);
            timeHack = numSeries == 1;
            for (int series = 0; series < numSeries; ++series) {
                Log.debug("fetching data for series:  " + series);
                r.setSeries(series);
                int sizeT = r.getSizeT();
                Log.debug("sizeT:  " + sizeT);
                int maxT = timeHack ? sizeT : 1;
                for (int t = 0; t < maxT; ++t) {
                    ImageCollectionElement element;
                    double[] location = CommonFunctions.getPlanePosition((IFormatReader)r, retrieve, series, t, invertX, invertY, ignoreZStage);
                    double locationX = location[0];
                    double locationY = location[1];
                    double locationZ = location[2];
                    if (!ignoreCalibration) {
                        double calX = 1.0;
                        double calY = 1.0;
                        double calZ = 1.0;
                        String dimOrder = r.getDimensionOrder().toUpperCase();
                        int posX = dimOrder.indexOf(88);
                        Length cal = retrieve.getPixelsPhysicalSizeX(series);
                        if (posX >= 0 && cal != null && cal.value().doubleValue() != 0.0) {
                            calX = cal.value().doubleValue();
                        }
                        Log.debug("calibrationX:  " + calX);
                        int posY = dimOrder.indexOf(89);
                        cal = retrieve.getPixelsPhysicalSizeY(series);
                        if (posY >= 0 && cal != null && cal.value().doubleValue() != 0.0) {
                            calY = cal.value().doubleValue();
                        }
                        Log.debug("calibrationY:  " + calY);
                        int posZ = dimOrder.indexOf(90);
                        cal = retrieve.getPixelsPhysicalSizeZ(series);
                        if (posZ >= 0 && cal != null && cal.value().doubleValue() != 0.0) {
                            calZ = cal.value().doubleValue();
                        }
                        Log.debug("calibrationZ:  " + calZ);
                        locationX /= calX;
                        locationY /= calY;
                        locationZ /= calZ;
                    }
                    locationX *= (100.0 - increaseOverlap) / 100.0;
                    locationY *= (100.0 - increaseOverlap) / 100.0;
                    locationZ *= (100.0 - increaseOverlap) / 100.0;
                    if (dim == 2) {
                        element = new ImageCollectionElement(new File(multiSeriesFile), elements.size());
                        element.setModel((Model<?>)new TranslationModel2D());
                        element.setOffset(new float[]{(float)locationX, (float)locationY});
                        element.setDimensionality(2);
                    } else {
                        element = new ImageCollectionElement(new File(multiSeriesFile), elements.size());
                        element.setModel((Model<?>)new TranslationModel3D());
                        element.setOffset(new float[]{(float)locationX, (float)locationY, (float)locationZ});
                        element.setDimensionality(3);
                    }
                    elements.add(element);
                }
            }
        }
        catch (Exception ex) {
            Log.error(ex);
            return null;
        }
        try {
            ImporterOptions options = new ImporterOptions();
            options.setId(new File(multiSeriesFile).getAbsolutePath());
            options.setSplitChannels(false);
            options.setSplitTimepoints(timeHack);
            options.setSplitFocalPlanes(false);
            options.setAutoscale(false);
            options.setStackFormat("Hyperstack");
            options.setStackOrder("XYCZT");
            options.setCrop(false);
            options.setOpenAllSeries(true);
            ImagePlus[] imps = BF.openImagePlus((ImporterOptions)options);
            if (ds != null) {
                ds.getInput(imps[0].getWidth(), imps[0].getHeight());
                ds.run(imps);
                ds.run(elements);
            }
            if (imps.length != elements.size()) {
                Log.error("Inconsistent series layout. Metadata says " + elements.size() + " tiles, but contains only " + imps.length + " images/tiles.");
                for (ImagePlus imp : imps) {
                    if (imp == null) continue;
                    imp.close();
                }
                return null;
            }
            for (int series = 0; series < elements.size(); ++series) {
                ImageCollectionElement element = (ImageCollectionElement)elements.get(series);
                element.setImagePlus(imps[series]);
                if (element.getDimensionality() == 2) {
                    Log.info("series " + series + ": position = (" + element.getOffset(0) + "," + element.getOffset(1) + ") [px], size = (" + element.getDimension(0) + "," + element.getDimension(1) + ")");
                    continue;
                }
                Log.info("series " + series + ": position = (" + element.getOffset(0) + "," + element.getOffset(1) + "," + element.getOffset(2) + ") [px], size = (" + element.getDimension(0) + "," + element.getDimension(1) + "," + element.getDimension(2) + ")");
            }
        }
        catch (Exception e) {
            Log.error("Cannot open multiseries file: " + e, e);
            return null;
        }
        return elements;
    }

    protected ArrayList<ImageCollectionElement> getLayoutFromFile(String directory, String layoutFile, Downsampler ds) {
        ArrayList<ImageCollectionElement> elements = new ArrayList<ImageCollectionElement>();
        int dim = -1;
        int index = 0;
        boolean multiSeries = false;
        HashMap<String, ImagePlus[]> multiSeriesMap = new HashMap<String, ImagePlus[]>();
        String pfx = "Stitching_Grid.getLayoutFromFile: ";
        try {
            BufferedReader in = TextFileAccess.openFileRead(new File(directory, layoutFile));
            if (in == null) {
                Log.error(pfx + "Cannot find tileconfiguration file '" + new File(directory, layoutFile).getAbsolutePath() + "'");
                return null;
            }
            int lineNo = 0;
            pfx = pfx + "Line ";
            while (in.ready()) {
                String point;
                String[] entries;
                String line = in.readLine().trim();
                ++lineNo;
                if (line.startsWith("#") || line.length() <= 3) continue;
                if (line.startsWith("dim")) {
                    entries = line.split("=");
                    if (entries.length != 2) {
                        Log.error(pfx + lineNo + " does not look like [ dim = n ]: " + line);
                        return null;
                    }
                    try {
                        dim = Integer.parseInt(entries[1].trim());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        Log.error(pfx + lineNo + ": Cannot parse dimensionality: " + entries[1].trim());
                        return null;
                    }
                }
                if (line.startsWith("multiseries")) {
                    entries = line.split("=");
                    if (entries.length != 2) {
                        Log.error(pfx + lineNo + " does not look like [ multiseries = (true|false) ]: " + line);
                        return null;
                    }
                    if (!entries[1].trim().equals("true")) continue;
                    multiSeries = true;
                    Log.info(pfx + lineNo + ": parsing MultiSeries configuration.");
                    continue;
                }
                if (dim < 0) {
                    Log.error(pfx + lineNo + ": Header missing, should look like [dim = n], but first line is: " + line);
                    return null;
                }
                if (dim < 2 || dim > 3) {
                    Log.error(pfx + lineNo + ": only dimensions of 2 and 3 are supported: " + line);
                    return null;
                }
                entries = line.split(";");
                if (entries.length != 3) {
                    Log.error(pfx + lineNo + " does not have 3 entries! [fileName; seriesNr; (x,y,...)]");
                    return null;
                }
                String imageName = entries[0].trim();
                if (imageName.length() == 0) {
                    Log.error(pfx + lineNo + ": You have to give a filename [fileName; ; (x,y,...)]: " + line);
                    return null;
                }
                int seriesNr = -1;
                if (multiSeries) {
                    String imageSeries = entries[1].trim();
                    if (imageSeries.length() == 0) {
                        Log.info(pfx + lineNo + ": Series index required [fileName; series; (x,y,...)");
                    } else {
                        try {
                            seriesNr = Integer.parseInt(imageSeries);
                            Log.info(pfx + lineNo + ": Series nr (sub-volume): " + seriesNr);
                        }
                        catch (NumberFormatException e) {
                            Log.error(pfx + lineNo + ": Cannot parse series nr: " + imageSeries);
                            return null;
                        }
                    }
                }
                if (!(point = entries[2].trim()).startsWith("(") || !point.endsWith(")")) {
                    Log.error(pfx + lineNo + ": Wrong format of coordinates: (x,y,...): " + point);
                    return null;
                }
                String[] points = (point = point.substring(1, point.length() - 1)).split(",");
                if (points.length != dim) {
                    Log.error(pfx + lineNo + ": Wrong format of coordinates: (x,y,z,...), dim = " + dim + ": " + point);
                    return null;
                }
                float[] offset = new float[dim];
                for (int i = 0; i < dim; ++i) {
                    try {
                        offset[i] = Float.parseFloat(points[i].trim());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        Log.error(pfx + lineNo + ": Cannot parse number: " + points[i].trim());
                        return null;
                    }
                }
                ImageCollectionElement element = new ImageCollectionElement(new File(directory, imageName), index++);
                element.setDimensionality(dim);
                if (dim == 3) {
                    element.setModel((Model<?>)new TranslationModel3D());
                } else {
                    element.setModel((Model<?>)new TranslationModel2D());
                }
                element.setOffset(offset);
                if (multiSeries) {
                    String imageNameFull = element.getFile().getAbsolutePath();
                    if (multiSeriesMap.get(imageNameFull) == null) {
                        Log.info(pfx + lineNo + ": Loading MultiSeries file: " + imageNameFull);
                        multiSeriesMap.put(imageNameFull, this.openBFDefault(imageNameFull));
                    }
                    element.setImagePlus(((ImagePlus[])multiSeriesMap.get(imageNameFull))[seriesNr]);
                }
                elements.add(element);
            }
        }
        catch (IOException e) {
            Log.error("Stitching_Grid.getLayoutFromFile: " + e);
            return null;
        }
        if (ds != null) {
            ImagePlus img = elements.get(0).open(true);
            ds.getInput(img.getWidth(), img.getHeight());
            ds.run(elements);
        }
        return elements;
    }

    protected ArrayList<ImageCollectionElement> getAllFilesInDirectory(String directory, boolean confirmFiles) {
        int i;
        File dir = new File(directory);
        if (!dir.isDirectory()) {
            Log.error("'" + directory + "' is not a directory. stop.");
            return null;
        }
        String[] imageFiles = dir.list();
        ArrayList<String> files = new ArrayList<String>();
        for (String fileName : imageFiles) {
            File file = new File(dir, fileName);
            if (!file.isFile() || file.isHidden() || fileName.endsWith(".txt") || fileName.endsWith(".TXT")) continue;
            Log.info(file.getPath());
            files.add(fileName);
        }
        Log.info("Found " + files.size() + " files (we ignore hidden and .txt files).");
        if (files.size() < 2) {
            Log.error("Only " + files.size() + " files found in '" + dir.getPath() + "', you need at least 2 - stop.");
            return null;
        }
        boolean[] useFile = new boolean[files.size()];
        for (int i2 = 0; i2 < files.size(); ++i2) {
            useFile[i2] = true;
        }
        if (confirmFiles) {
            GenericDialogPlus gd = new GenericDialogPlus("Confirm files");
            for (String name : files) {
                gd.addCheckbox(name, true);
            }
            gd.showDialog();
            if (gd.wasCanceled()) {
                return null;
            }
            for (i = 0; i < files.size(); ++i) {
                useFile[i] = gd.getNextBoolean();
            }
        }
        ArrayList<ImageCollectionElement> elements = new ArrayList<ImageCollectionElement>();
        for (i = 0; i < files.size(); ++i) {
            if (!useFile[i]) continue;
            elements.add(new ImageCollectionElement(new File(directory, (String)files.get(i)), i));
        }
        if (elements.size() < 2) {
            Log.error("Only " + elements.size() + " files selected, you need at least 2 - stop.");
            return null;
        }
        return elements;
    }

    protected ArrayList<ImageCollectionElement> getGridLayout(GridType grid, int gridSizeX, int gridSizeY, double overlapX, double overlapY, String directory, String filenames, int startI, int startX, int startY, boolean virtual, Downsampler ds) {
        int i;
        int gridType = grid.getType();
        int gridOrder = grid.getOrder();
        String replaceX = "{";
        String replaceY = "{";
        String replaceI = "{";
        int numXValues = 0;
        int numYValues = 0;
        int numIValues = 0;
        if (grid.getType() < 4) {
            int i1 = filenames.indexOf("{i");
            int i2 = filenames.indexOf("i}");
            if (i1 >= 0 && i2 > 0) {
                numIValues = i2 - i1;
                for (i = 0; i < numIValues; ++i) {
                    replaceI = replaceI + "i";
                }
                replaceI = replaceI + "}";
            } else {
                replaceI = "\\\\\\\\";
            }
        } else {
            int x1 = filenames.indexOf("{x");
            int x2 = filenames.indexOf("x}");
            if (x1 >= 0 && x2 > 0) {
                numXValues = x2 - x1;
                for (i = 0; i < numXValues; ++i) {
                    replaceX = replaceX + "x";
                }
                replaceX = replaceX + "}";
            } else {
                replaceX = "\\\\\\\\";
            }
            int y1 = filenames.indexOf("{y");
            int y2 = filenames.indexOf("y}");
            if (y1 >= 0 && y2 > 0) {
                numYValues = y2 - y1;
                for (int i2 = 0; i2 < numYValues; ++i2) {
                    replaceY = replaceY + "y";
                }
                replaceY = replaceY + "}";
            } else {
                replaceY = "\\\\\\\\";
            }
        }
        ImageCollectionElement[][] gridLayout = new ImageCollectionElement[gridSizeX][gridSizeY];
        if (grid.getType() < 4) {
            int[] position = new int[2];
            for (i = 0; i < gridSizeX * gridSizeY; ++i) {
                this.getPosition(position, i, gridType, gridOrder, gridSizeX, gridSizeY);
                String file = filenames.replace(replaceI, Stitching_Grid.getLeadingZeros(numIValues, i + startI));
                gridLayout[position[0]][position[1]] = new ImageCollectionElement(new File(directory, file), i);
            }
        } else {
            int i3 = 0;
            for (int y = 0; y < gridSizeY; ++y) {
                for (int x = 0; x < gridSizeX; ++x) {
                    String file = filenames.replace(replaceX, Stitching_Grid.getLeadingZeros(numXValues, x + startX)).replace(replaceY, Stitching_Grid.getLeadingZeros(numYValues, y + startY));
                    gridLayout[x][y] = new ImageCollectionElement(new File(directory, file), i3++);
                }
            }
        }
        int minWidth = Integer.MAX_VALUE;
        int minHeight = Integer.MAX_VALUE;
        int minDepth = Integer.MAX_VALUE;
        boolean is2d = false;
        boolean is3d = false;
        for (int y = 0; y < gridSizeY; ++y) {
            for (int x = 0; x < gridSizeX; ++x) {
                if (virtual) {
                    Log.info("Opening VIRTUAL (" + x + ", " + y + "): " + gridLayout[x][y].getFile().getAbsolutePath() + " ... ");
                } else {
                    Log.info("Loading (" + x + ", " + y + "): " + gridLayout[x][y].getFile().getAbsolutePath() + " ... ");
                }
                long time = System.currentTimeMillis();
                ImagePlus imp = gridLayout[x][y].open(virtual);
                if (ds != null) {
                    if (!ds.hasInput()) {
                        ds.getInput(imp.getWidth(), imp.getHeight());
                    }
                    ds.run(imp);
                }
                time = System.currentTimeMillis() - time;
                if (imp == null) {
                    return null;
                }
                if (imp.getNSlices() > 1) {
                    Log.info("" + imp.getWidth() + "x" + imp.getHeight() + "x" + imp.getNSlices() + "px, channels=" + imp.getNChannels() + ", timepoints=" + imp.getNFrames() + " (" + time + " ms)");
                    is3d = true;
                } else {
                    Log.info("" + imp.getWidth() + "x" + imp.getHeight() + "px, channels=" + imp.getNChannels() + ", timepoints=" + imp.getNFrames() + " (" + time + " ms)");
                    is2d = true;
                }
                if (is2d && is3d) {
                    Log.info("Some images are 2d, some are 3d ... cannot proceed");
                    return null;
                }
                if (imp.getWidth() < minWidth) {
                    minWidth = imp.getWidth();
                }
                if (imp.getHeight() < minHeight) {
                    minHeight = imp.getHeight();
                }
                if (imp.getNSlices() >= minDepth) continue;
                minDepth = imp.getNSlices();
            }
        }
        int dimensionality = is3d ? 3 : 2;
        int xoffset = 0;
        int yoffset = 0;
        int zoffset = 0;
        ArrayList<ImageCollectionElement> elements = new ArrayList<ImageCollectionElement>();
        for (int y = 0; y < gridSizeY; ++y) {
            yoffset = y == 0 ? 0 : (yoffset += (int)((double)minHeight * (1.0 - overlapY)));
            for (int x = 0; x < gridSizeX; ++x) {
                ImageCollectionElement element = gridLayout[x][y];
                if (x == 0 && y == 0) {
                    zoffset = 0;
                    yoffset = 0;
                    xoffset = 0;
                }
                xoffset = x == 0 ? 0 : (xoffset += (int)((double)minWidth * (1.0 - overlapX)));
                element.setDimensionality(dimensionality);
                if (dimensionality == 3) {
                    element.setModel((Model<?>)new TranslationModel3D());
                    element.setOffset(new float[]{xoffset, yoffset, zoffset});
                } else {
                    element.setModel((Model<?>)new TranslationModel2D());
                    element.setOffset(new float[]{xoffset, yoffset});
                }
                elements.add(element);
            }
        }
        return elements;
    }

    protected void writeTileConfiguration(File file, ArrayList<ImageCollectionElement> elements) {
        PrintWriter out = TextFileAccess.openFileWrite(file);
        int dimensionality = elements.get(0).getDimensionality();
        out.println("# Define the number of dimensions we are working on");
        out.println("dim = " + dimensionality);
        out.println("");
        out.println("# Define the image coordinates");
        for (ImageCollectionElement element : elements) {
            if (dimensionality == 3) {
                out.println(element.getFile().getName() + "; ; (" + element.getOffset(0) + ", " + element.getOffset(1) + ", " + element.getOffset(2) + ")");
                continue;
            }
            out.println(element.getFile().getName() + "; ; (" + element.getOffset(0) + ", " + element.getOffset(1) + ")");
        }
        out.close();
    }

    protected void writeRegisteredTileConfiguration(File file, ArrayList<ImageCollectionElement> elements) {
        PrintWriter out = TextFileAccess.openFileWrite(file);
        int dimensionality = elements.get(0).getDimensionality();
        Log.info("Writing registered TileConfiguration: " + file);
        out.println("# Define the number of dimensions we are working on");
        out.println("dim = " + dimensionality);
        out.println("");
        out.println("# Define the image coordinates");
        for (ImageCollectionElement element : elements) {
            TranslationModel3D m;
            if (dimensionality == 3) {
                m = (TranslationModel3D)element.getModel();
                out.println(element.getFile().getName() + "; ; (" + m.getTranslation()[0] + ", " + m.getTranslation()[1] + ", " + m.getTranslation()[2] + ")");
                continue;
            }
            m = (TranslationModel2D)element.getModel();
            double[] tmp = new double[2];
            m.applyInPlace(tmp);
            out.println(element.getFile().getName() + "; ; (" + tmp[0] + ", " + tmp[1] + ")");
        }
        out.close();
    }

    protected void getPosition(int[] currentPosition, int i, int gridType, int gridOrder, int sizeX, int sizeY) {
        if (i == 0) {
            currentPosition[0] = gridOrder == 0 || gridOrder == 2 ? 0 : sizeX - 1;
            currentPosition[1] = gridOrder == 0 || gridOrder == 1 ? 0 : sizeY - 1;
            if (gridType == 2 || gridType == 3) {
                this.snakeDirectionX = gridOrder == 0 || gridOrder == 2 ? 1 : -1;
                this.snakeDirectionY = gridOrder == 0 || gridOrder == 1 ? 1 : -1;
            }
        } else if (gridType == 0) {
            if (gridOrder == 0 || gridOrder == 2) {
                if (currentPosition[0] < sizeX - 1) {
                    currentPosition[0] = currentPosition[0] + 1;
                } else {
                    currentPosition[1] = gridOrder == 0 ? currentPosition[1] + 1 : currentPosition[1] - 1;
                    currentPosition[0] = 0;
                }
            } else if (currentPosition[0] > 0) {
                currentPosition[0] = currentPosition[0] - 1;
            } else {
                currentPosition[1] = gridOrder == 1 ? currentPosition[1] + 1 : currentPosition[1] - 1;
                currentPosition[0] = sizeX - 1;
            }
        } else if (gridType == 1) {
            if (gridOrder == 0 || gridOrder == 1) {
                if (currentPosition[1] < sizeY - 1) {
                    currentPosition[1] = currentPosition[1] + 1;
                } else {
                    currentPosition[0] = gridOrder == 0 ? currentPosition[0] + 1 : currentPosition[0] - 1;
                    currentPosition[1] = 0;
                }
            } else if (currentPosition[1] > 0) {
                currentPosition[1] = currentPosition[1] - 1;
            } else {
                currentPosition[0] = gridOrder == 2 ? currentPosition[0] + 1 : currentPosition[0] - 1;
                currentPosition[1] = sizeY - 1;
            }
        } else if (gridType == 2) {
            if (this.snakeDirectionX > 0) {
                if (currentPosition[0] < sizeX - 1) {
                    currentPosition[0] = currentPosition[0] + 1;
                } else {
                    currentPosition[1] = currentPosition[1] + this.snakeDirectionY;
                    this.snakeDirectionX *= -1;
                }
            } else {
                if (currentPosition[0] > 0) {
                    currentPosition[0] = currentPosition[0] - 1;
                    return;
                }
                currentPosition[1] = currentPosition[1] + this.snakeDirectionY;
                this.snakeDirectionX *= -1;
            }
        } else if (gridType == 3) {
            if (this.snakeDirectionY > 0) {
                if (currentPosition[1] < sizeY - 1) {
                    currentPosition[1] = currentPosition[1] + 1;
                } else {
                    currentPosition[0] = currentPosition[0] + this.snakeDirectionX;
                    this.snakeDirectionY *= -1;
                }
            } else if (currentPosition[1] > 0) {
                currentPosition[1] = currentPosition[1] - 1;
            } else {
                currentPosition[0] = currentPosition[0] + this.snakeDirectionX;
                this.snakeDirectionY *= -1;
            }
        }
    }

    public static String getLeadingZeros(int zeros, int number) {
        String output = "" + number;
        while (output.length() < zeros) {
            output = "0" + output;
        }
        return output;
    }
}

