/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPopupMenu;
import javax.swing.undo.AbstractUndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.gui.JFontChooser;

public class FontChooserHandler
extends AbstractSelectedAction
implements PropertyChangeListener {
    protected AttributeKey<Font> key;
    protected JFontChooser fontChooser;
    protected JPopupMenu popupMenu;
    protected int isUpdating;

    public FontChooserHandler(DrawingEditor editor, AttributeKey<Font> key, JFontChooser fontChooser, JPopupMenu popupMenu) {
        super(editor);
        this.key = key;
        this.fontChooser = fontChooser;
        this.popupMenu = popupMenu;
        fontChooser.addActionListener(this);
        fontChooser.addPropertyChangeListener(this);
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand() == "ApproveSelection") {
            this.applySelectedFontToFigures();
        } else if (evt.getActionCommand() == "CancelSelection") {
            // empty if block
        }
        this.popupMenu.setVisible(false);
    }

    protected void applySelectedFontToFigures() {
        final ArrayList<Figure> selectedFigures = new ArrayList<Figure>(this.getView().getSelectedFigures());
        final ArrayList<Object> restoreData = new ArrayList<Object>(selectedFigures.size());
        for (Figure figure : selectedFigures) {
            restoreData.add(figure.getAttributesRestoreData());
            figure.willChange();
            figure.set(this.key, this.fontChooser.getSelectedFont());
            figure.changed();
        }
        this.getEditor().setDefaultAttribute(this.key, this.fontChooser.getSelectedFont());
        final Font undoValue = this.fontChooser.getSelectedFont();
        AbstractUndoableEdit edit = new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                return AttributeKeys.FONT_FACE.getPresentationName();
            }

            @Override
            public void undo() {
                super.undo();
                Iterator iRestore = restoreData.iterator();
                for (Figure figure : selectedFigures) {
                    figure.willChange();
                    figure.restoreAttributesTo(iRestore.next());
                    figure.changed();
                }
            }

            @Override
            public void redo() {
                super.redo();
                for (Figure figure : selectedFigures) {
                    figure.willChange();
                    figure.set(FontChooserHandler.this.key, undoValue);
                    figure.changed();
                }
            }
        };
        this.fireUndoableEditHappened(edit);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getEditor().isEnabled());
        if (this.getView() != null && this.fontChooser != null && this.popupMenu != null) {
            this.fontChooser.setEnabled(this.getView().getSelectionCount() > 0);
            this.popupMenu.setEnabled(this.getView().getSelectionCount() > 0);
            ++this.isUpdating;
            if (this.getView().getSelectionCount() > 0) {
                for (Figure f : this.getView().getSelectedFigures()) {
                    if (!(f instanceof TextHolderFigure)) continue;
                    TextHolderFigure thf = (TextHolderFigure)f;
                    this.fontChooser.setSelectedFont(thf.getFont());
                    break;
                }
            }
            --this.isUpdating;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isUpdating++ == 0 && evt.getPropertyName() == "selectedFont") {
            this.applySelectedFontToFigures();
        }
        --this.isUpdating;
    }
}

