/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.decoration;

import java.awt.geom.Path2D;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.decoration.AbstractLineDecoration;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;

public class PerpendicularBar
extends AbstractLineDecoration
implements DOMStorable {
    private double height;

    public PerpendicularBar() {
        this(10.0);
    }

    public PerpendicularBar(double height) {
        super(false, true, false);
        this.height = height;
    }

    @Override
    protected Path2D.Double getDecoratorPath(Figure f) {
        Path2D.Double path = new Path2D.Double();
        double halfHeight = this.height / 2.0;
        path.moveTo(halfHeight, 0.0);
        path.lineTo(-halfHeight, 0.0);
        return path;
    }

    @Override
    protected double getDecoratorPathRadius(Figure f) {
        return 0.5;
    }

    @Override
    public void read(DOMInput in) {
        this.height = in.getAttribute("height", 10);
    }

    @Override
    public void write(DOMOutput out) {
        out.addAttribute("height", this.height);
    }
}

