/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.statements;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.LValue;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.compiler.ir.tac.statements.StatementVisitor;
import org.renjin.eval.Context;

public class Assignment
implements Statement {
    private LValue lhs;
    private Expression rhs;

    public Assignment(LValue lhs, Expression rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public LValue getLHS() {
        return this.lhs;
    }

    @Override
    public Expression getRHS() {
        return this.rhs;
    }

    @Override
    public Object interpret(Context context, Object[] temp) {
        this.lhs.setValue(context, temp, this.rhs.retrieveValue(context, temp));
        return null;
    }

    @Override
    public Iterable<IRLabel> possibleTargets() {
        return Collections.emptySet();
    }

    @Override
    public Set<Variable> variables() {
        return Sets.union(this.lhs.variables(), this.rhs.variables());
    }

    @Override
    public Assignment withRHS(Expression newRHS) {
        return new Assignment(this.lhs, newRHS);
    }

    public Statement withLHS(Variable lhs) {
        return new Assignment(lhs, this.rhs);
    }

    public String toString() {
        return this.getLHS() + " " + "\u2190" + " " + this.rhs;
    }

    @Override
    public List<Expression> getChildren() {
        return Arrays.asList(this.rhs);
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        if (childIndex != 0) {
            throw new IllegalArgumentException("childIndex=" + childIndex);
        }
        this.rhs = child;
    }

    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visitAssignment(this);
    }
}

