/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.time;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.renjin.invoke.annotations.Internal;
import org.renjin.primitives.time.DateTimeFormat;
import org.renjin.primitives.time.PosixCtVector;
import org.renjin.primitives.time.PosixLtVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;

public class Time {
    public static LocalDate EPOCH = new LocalDate(1970, 1, 1);

    @Internal
    public static SEXP strptime(StringVector x, StringVector formats, String tz) {
        if (x.length() == 0 || formats.length() == 0) {
            return StringVector.EMPTY;
        }
        DateTimeZone timeZone = Time.timeZoneFromRSpecification(tz);
        List<DateTimeFormatter> formatters = DateTimeFormat.forPatterns(formats, timeZone, false);
        PosixLtVector.Builder result = new PosixLtVector.Builder();
        if (!Strings.isNullOrEmpty((String)tz)) {
            result.withTimeZone(timeZone);
        }
        int resultLength = Math.max(x.length(), formats.length());
        for (int i = 0; i != resultLength; ++i) {
            DateTimeFormatter formatter = formatters.get(i % formatters.size());
            String string = x.getElementAsString(i % x.length());
            try {
                result.add(Time.parseIgnoreTrailingCharacters(formatter, timeZone, string));
                continue;
            }
            catch (IllegalArgumentException e) {
                result.addNA();
            }
        }
        return result.buildListVector();
    }

    private static DateTime parseIgnoreTrailingCharacters(DateTimeFormatter formatter, DateTimeZone defaultTimeZone, String text) {
        Chronology chronology = ISOChronology.getInstance().withZone(defaultTimeZone);
        DateTimeParser parser = formatter.getParser();
        Locale locale = null;
        Integer pivotYear = null;
        int defaultYear = 2000;
        Object timeZone = null;
        DateTimeParserBucket bucket = new DateTimeParserBucket(0L, chronology, locale, pivotYear, defaultYear);
        int newPos = parser.parseInto(bucket, text, 0);
        if (newPos >= 0) {
            long millis = bucket.computeMillis(true, text);
            if (formatter.isOffsetParsed() && bucket.getOffsetInteger() != null) {
                int parsedOffset = bucket.getOffsetInteger();
                DateTimeZone parsedZone = DateTimeZone.forOffsetMillis((int)parsedOffset);
                chronology = chronology.withZone(parsedZone);
            } else if (bucket.getZone() != null) {
                chronology = chronology.withZone(bucket.getZone());
            }
            return new DateTime(millis, chronology);
        }
        throw new IllegalArgumentException();
    }

    @Internal(value="as.POSIXct")
    public static DoubleVector asPOSIXct(ListVector x, String tz) {
        SEXP timeZoneAttribute = Strings.isNullOrEmpty((String)tz) ? x.getAttribute(Symbols.TZONE) : StringArrayVector.valueOf(tz);
        return new PosixCtVector.Builder().setTimeZone(timeZoneAttribute).addAll(new PosixLtVector(x)).buildDoubleVector();
    }

    @Internal(value="as.POSIXlt")
    public static ListVector asPOSIXlt(DoubleVector x, String tz) {
        SEXP timeZoneAttribute = Strings.isNullOrEmpty((String)tz) ? x.getAttribute(Symbols.TZONE) : StringArrayVector.valueOf(tz);
        return new PosixLtVector.Builder().withTimeZone(timeZoneAttribute).addAll(new PosixCtVector(x)).buildListVector();
    }

    @Internal
    public static DoubleVector POSIXlt2Date(ListVector x) {
        PosixLtVector ltVector = new PosixLtVector(x);
        DoubleArrayVector.Builder dateVector = DoubleArrayVector.Builder.withInitialCapacity(ltVector.length());
        for (int i = 0; i != ltVector.length(); ++i) {
            DateTime date2 = ltVector.getElementAsDateTime(i);
            if (date2 == null) {
                dateVector.addNA();
                continue;
            }
            dateVector.add(Days.daysBetween((ReadablePartial)EPOCH, (ReadablePartial)date2.toLocalDate()).getDays());
        }
        dateVector.setAttribute(Symbols.CLASS, (SEXP)StringVector.valueOf("Date"));
        return dateVector.build();
    }

    @Internal
    public static ListVector Date2POSIXlt(DoubleVector x) {
        PosixLtVector.Builder ltVector = new PosixLtVector.Builder();
        for (int i = 0; i != x.length(); ++i) {
            int daysSinceEpoch = x.getElementAsInt(i);
            if (IntVector.isNA(daysSinceEpoch)) {
                ltVector.addNA();
                continue;
            }
            ltVector.add(EPOCH.plusDays(daysSinceEpoch).toDateTimeAtStartOfDay(DateTimeZone.UTC));
        }
        return ltVector.buildListVector();
    }

    @Internal(value="Sys.time")
    public static DoubleVector sysTime() {
        return new PosixCtVector.Builder().add(new DateTime()).buildDoubleVector();
    }

    @Internal(value="format.POSIXlt")
    public static StringVector formatPOSIXlt(ListVector x, StringVector patterns, boolean useTz) {
        PosixLtVector dateTimes = new PosixLtVector(x);
        List<DateTimeFormatter> formatters = DateTimeFormat.forPatterns(patterns, dateTimes.getTimeZone(), useTz);
        StringVector.Builder result = new StringVector.Builder();
        int resultLength = Math.max(dateTimes.length(), patterns.length());
        for (int i = 0; i != resultLength; ++i) {
            DateTimeFormatter formatter = formatters.get(i % formatters.size());
            DateTime dateTime = dateTimes.getElementAsDateTime(i % dateTimes.length());
            if (dateTime == null) {
                result.addNA();
                continue;
            }
            result.add(formatter.print((ReadableInstant)dateTime));
        }
        return result.build();
    }

    public static DateTimeZone timeZoneFromRSpecification(String tz) {
        if (Strings.isNullOrEmpty((String)tz)) {
            return DateTimeZone.getDefault();
        }
        if ("GMT".equals(tz)) {
            return DateTimeZone.UTC;
        }
        return DateTimeZone.forID((String)tz);
    }

    public static DateTimeZone timeZoneFromPosixObject(SEXP lt) {
        SEXP attribute = lt.getAttribute(Symbols.TZONE);
        return Time.timeZoneFromTzoneAttribute(attribute);
    }

    public static DateTimeZone timeZoneFromTzoneAttribute(SEXP attribute) {
        if (attribute instanceof StringVector) {
            return Time.timeZoneFromRSpecification(((StringVector)attribute).getElementAsString(0));
        }
        return DateTimeZone.getDefault();
    }
}

