/*
 * Decompiled with CFR 0.152.
 */
package video2;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;

public class Make_Transition
implements PlugInFilter {
    private ImagePlus image;
    public static final int FADE = 0;
    public static final int H_STRIPES = 1;
    public static final int V_STRIPES = 2;
    public static final int DEF_NUM_SLICES = 20;
    public static final int DEF_TRANSITION = 0;
    private static final Transition[] transitions = new Transition[]{new FadeTransition(), new HStripesTransition(), new VStripesTransition()};

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 16;
    }

    public void run(ImageProcessor ip) {
        int current = this.image.getCurrentSlice();
        GenericDialog gd = new GenericDialog("Make Transition");
        gd.addNumericField("From slice", (double)current, 0);
        gd.addNumericField("Number of slices", 20.0, 0);
        String[] tstrings = new String[]{"Fade transition", "Horizontal stripes", "Vertical stripes"};
        gd.addChoice("Transition type", tstrings, tstrings[0]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int from = (int)gd.getNextNumber();
        int num = (int)gd.getNextNumber();
        int type = gd.getNextChoiceIndex();
        Make_Transition.makeTransition(this.image, from, num, type);
    }

    public static void makeTransition(ImagePlus imp, int from, int num, int type) {
        transitions[type].makeTransition(imp, from, num);
    }

    private static class FadeTransition
    implements Transition {
        private FadeTransition() {
        }

        @Override
        public void makeTransition(ImagePlus imp, int from, int num) {
            if (from > imp.getStackSize()) {
                IJ.error((String)"Need a following slice to which to transit.");
                return;
            }
            ++num;
            ImageStack stack = imp.getStack();
            int[] before = (int[])stack.getProcessor(from).convertToRGB().getPixels();
            int[] after = (int[])stack.getProcessor(from + 1).convertToRGB().getPixels();
            for (int z = 1; z < num; ++z) {
                ColorProcessor bp = new ColorProcessor(stack.getWidth(), stack.getHeight());
                int[] pixels = (int[])bp.getPixels();
                double dp = z;
                double dn = num - z;
                for (int i = 0; i < pixels.length; ++i) {
                    pixels[i] = FadeTransition.interpolate(before[i], dp, after[i], dn);
                }
                new ImagePlus("slice + " + z, (ImageProcessor)bp).show();
                stack.addSlice("", (ImageProcessor)bp, from + z - 1);
            }
        }

        public static int interpolate(int p, double dp, int n, double dn) {
            int rp = (p & 0xFF0000) >> 16;
            int rn = (n & 0xFF0000) >> 16;
            int gp = (p & 0xFF00) >> 8;
            int gn = (n & 0xFF00) >> 8;
            int bp = p & 0xFF;
            int bn = n & 0xFF;
            byte r_int = (byte)(((double)rn * dp + (double)rp * dn) / (dn + dp));
            byte g_int = (byte)(((double)gn * dp + (double)gp * dn) / (dn + dp));
            byte b_int = (byte)(((double)bn * dp + (double)bp * dn) / (dn + dp));
            return ((r_int & 0xFF) << 16) + ((g_int & 0xFF) << 8) + (b_int & 0xFF);
        }
    }

    private static class VStripesTransition
    implements Transition {
        private VStripesTransition() {
        }

        @Override
        public void makeTransition(ImagePlus imp, int from, int num) {
            ImageStack stack = imp.getStack();
            int w = imp.getWidth();
            int h = imp.getHeight();
            ImageProcessor fr = stack.getProcessor(from).duplicate();
            ImageProcessor to = stack.getProcessor(from + 1);
            int[] col = new int[h];
            for (int n = 0; n < num; ++n) {
                for (int x = n; x < w; x += num) {
                    to.getColumn(x, 0, col, h);
                    fr.putColumn(x, 0, col, h);
                }
                stack.addSlice("", fr, from + n);
            }
        }
    }

    private static class HStripesTransition
    implements Transition {
        private HStripesTransition() {
        }

        @Override
        public void makeTransition(ImagePlus imp, int from, int num) {
            ImageStack stack = imp.getStack();
            int w = imp.getWidth();
            int h = imp.getHeight();
            ImageProcessor fr = stack.getProcessor(from).duplicate();
            ImageProcessor to = stack.getProcessor(from + 1);
            int[] row = new int[w];
            for (int n = 0; n < num; ++n) {
                for (int y = n; y < h; y += num) {
                    to.getRow(0, y, row, w);
                    fr.putRow(0, y, row, w);
                }
                stack.addSlice("", fr, from + n);
            }
        }
    }

    public static interface Transition {
        public void makeTransition(ImagePlus var1, int var2, int var3);
    }
}

