/*
 * Decompiled with CFR 0.152.
 */
package bunwarpj.trakem2.transform;

import bunwarpj.BSplineModel;
import bunwarpj.Param;
import bunwarpj.Transformation;
import bunwarpj.bUnwarpJ_;
import java.awt.Point;
import java.util.Collection;
import java.util.Stack;
import mpicbg.models.AbstractModel;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.trakem2.transform.CoordinateTransform;

public class CubicBSplineTransform
extends AbstractModel<CubicBSplineTransform>
implements CoordinateTransform {
    private BSplineModel swx = null;
    private BSplineModel swy = null;
    private int intervals = 0;
    private int width = 0;
    private int height = 0;
    private int sourceWidth = 0;
    private int sourceHeight = 0;
    private Param parameter = new Param(2, 0, 0, 2, 0.1, 0.1, 1.0, 0.0, 0.0, 0.01);

    public CubicBSplineTransform() {
    }

    public CubicBSplineTransform(int intervals, double[][] cx, double[][] cy, int width, int height) {
        this.intervals = intervals;
        this.swx = new BSplineModel(cx);
        this.swy = new BSplineModel(cy);
        this.width = width;
        this.height = height;
    }

    public CubicBSplineTransform(int intervals, BSplineModel swx, BSplineModel swy, int width, int height) {
        this.intervals = intervals;
        this.swx = swx;
        this.swy = swy;
        this.width = width;
        this.height = height;
    }

    public void set(int intervals, BSplineModel swx, BSplineModel swy, int width, int height) {
        this.intervals = intervals;
        this.swx = swx;
        this.swy = swy;
        this.width = width;
        this.height = height;
    }

    public void set(int intervals, double[][] cx, double[][] cy, int width, int height) {
        this.intervals = intervals;
        this.swx = new BSplineModel(cx);
        this.swy = new BSplineModel(cy);
        this.width = width;
        this.height = height;
    }

    public double[] apply(double[] l) {
        double[] w = (double[])l.clone();
        this.applyInPlace(w);
        return w;
    }

    public void applyInPlace(double[] l) {
        double tv = l[1] * (double)this.intervals / (double)(this.height - 1) + 1.0;
        double tu = l[0] * (double)this.intervals / (double)(this.width - 1) + 1.0;
        l[0] = this.swx.prepareForInterpolationAndInterpolateI(tu, tv, false, false);
        l[1] = this.swy.prepareForInterpolationAndInterpolateI(tu, tv, false, false);
    }

    public void init(String dataString) throws NumberFormatException {
        String[] fields = dataString.split("\\s+");
        int j = 0;
        this.width = Integer.parseInt(fields[j++]);
        this.height = Integer.parseInt(fields[j++]);
        this.intervals = Integer.parseInt(fields[j++]);
        int size = this.intervals + 3;
        int size2 = size * size;
        if (fields.length < 2 * size2 + 3) {
            throw new NumberFormatException("Inappropriate parameters for " + ((Object)((Object)this)).getClass().getCanonicalName());
        }
        double[] cx = new double[size2];
        for (int i = 0; i < size2; ++i) {
            cx[i] = Double.parseDouble(fields[j++]);
        }
        double[] cy = new double[size2];
        for (int i = 0; i < size2; ++i) {
            cy[i] = Double.parseDouble(fields[j++]);
        }
        this.swx = new BSplineModel(cx, size, size, 0);
        this.swy = new BSplineModel(cy, size, size, 0);
    }

    public String toDataString() {
        StringBuffer text = new StringBuffer(this.width + " " + this.height + " " + this.intervals);
        int size = (this.intervals + 3) * (this.intervals + 3);
        double[] cx = this.swx.getCoefficients();
        for (int i = 0; i < size; ++i) {
            text.append(" " + cx[i]);
        }
        double[] cy = this.swy.getCoefficients();
        for (int i = 0; i < size; ++i) {
            text.append(" " + cy[i]);
        }
        return text.toString();
    }

    public final String toXML(String indent) {
        return indent + "<ict_transform class=\"" + ((Object)((Object)this)).getClass().getCanonicalName() + "\" data=\"" + this.toDataString() + "\"/>";
    }

    public final CubicBSplineTransform copy() {
        CubicBSplineTransform transf = new CubicBSplineTransform();
        transf.init(this.toDataString());
        return transf;
    }

    public <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        Stack<Point> sourcePoints = new Stack<Point>();
        Stack<Point> targetPoints = new Stack<Point>();
        for (PointMatch pm : matches) {
            double[] p1 = pm.getP1().getL();
            double[] p2 = pm.getP2().getL();
            targetPoints.add(new Point((int)Math.round(p1[0]), (int)Math.round(p1[1])));
            sourcePoints.add(new Point((int)Math.round(p2[0]), (int)Math.round(p2[1])));
        }
        Transformation transf = bUnwarpJ_.computeTransformationBatch((int)this.sourceWidth, (int)this.sourceHeight, (int)this.width, (int)this.height, sourcePoints, targetPoints, (Param)this.parameter);
        this.set(transf.getIntervals(), transf.getDirectDeformationCoefficientsX(), transf.getDirectDeformationCoefficientsY(), this.width, this.height);
    }

    public void scale(double xScale, double yScale) {
        double[] cx = this.swx.getCoefficients();
        double[] cy = this.swy.getCoefficients();
        double xScaleFactor = 1.0 / xScale;
        double yScaleFactor = 1.0 / yScale;
        int i = 0;
        while (i < cx.length) {
            int n = i;
            cx[n] = cx[n] * xScaleFactor;
            int n2 = i++;
            cy[n2] = cy[n2] * yScaleFactor;
        }
    }

    public void set(Param p, int sourceWidth, int sourceHeight, int targetWidth, int targetHeight) {
        this.parameter = p;
        this.sourceHeight = sourceHeight;
        this.sourceWidth = sourceWidth;
        this.width = targetWidth;
        this.height = targetHeight;
    }

    public int getMinNumMatches() {
        return 0;
    }

    public void set(CubicBSplineTransform m) {
        this.init(m.toDataString());
    }

    public String toString() {
        return this.toDataString();
    }
}

