/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.io;

import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mpicbg.models.TransformList;
import mpicbg.trakem2.transform.CoordinateTransform;
import mpicbg.trakem2.transform.CoordinateTransformList;
import mpicbg.trakem2.transform.InvertibleCoordinateTransform;
import mpicbg.trakem2.transform.InvertibleCoordinateTransformList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class CoordinateTransformXML {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoordinateTransform parse(String xmlPath) throws Exception {
        InputStream istream = null;
        try {
            SAXParserFactory f = SAXParserFactory.newInstance();
            f.setValidating(false);
            SAXParser parser = f.newSAXParser();
            istream = Utils.createStream(xmlPath);
            Parser p = new Parser();
            parser.parse(new InputSource(istream), (DefaultHandler)p);
            CoordinateTransform coordinateTransform = p.ct;
            return coordinateTransform;
        }
        finally {
            try {
                if (null != istream) {
                    istream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static class Parser
    extends DefaultHandler {
        final ArrayList<TransformList<Object>> ct_list_stack = new ArrayList();
        private CoordinateTransform ct = null;

        private Parser() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            HashMap<String, String> t = new HashMap<String, String>();
            for (int i = attributes.getLength() - 1; i > -1; --i) {
                t.put(attributes.getQName(i).toLowerCase(), attributes.getValue(i));
            }
            this.makeCoordinateTransform(qName.toLowerCase(), t);
        }

        @Override
        public void endElement(String namespace_URI, String local_name, String qualified_name) {
            if (qualified_name.endsWith("ict_transform_list")) {
                this.ct_list_stack.remove(this.ct_list_stack.size() - 1);
            }
        }

        private final void makeCoordinateTransform(String type, HashMap<String, String> ht_attributes) {
            try {
                if (type.equals("ict_transform")) {
                    CoordinateTransform ct = (CoordinateTransform)Class.forName(ht_attributes.get("class")).newInstance();
                    ct.init(ht_attributes.get("data"));
                    if (this.ct_list_stack.isEmpty()) {
                        this.ct = ct;
                    } else {
                        this.ct_list_stack.get(this.ct_list_stack.size() - 1).add((Object)ct);
                    }
                } else if (type.equals("iict_transform")) {
                    InvertibleCoordinateTransform ict = (InvertibleCoordinateTransform)Class.forName(ht_attributes.get("class")).newInstance();
                    ict.init(ht_attributes.get("data"));
                    if (this.ct_list_stack.isEmpty()) {
                        this.ct = ict;
                    } else {
                        this.ct_list_stack.get(this.ct_list_stack.size() - 1).add((Object)ict);
                    }
                } else if (type.equals("ict_transform_list")) {
                    CoordinateTransformList ctl = new CoordinateTransformList();
                    if (this.ct_list_stack.isEmpty()) {
                        this.ct = ctl;
                    } else {
                        this.ct_list_stack.get(this.ct_list_stack.size() - 1).add((Object)ctl);
                    }
                    this.ct_list_stack.add((TransformList<Object>)ctl);
                } else if (type.equals("iict_transform_list")) {
                    InvertibleCoordinateTransformList ictl = new InvertibleCoordinateTransformList();
                    if (this.ct_list_stack.isEmpty()) {
                        this.ct = ictl;
                    } else {
                        this.ct_list_stack.get(this.ct_list_stack.size() - 1).add((Object)ictl);
                    }
                    this.ct_list_stack.add((TransformList<Object>)ictl);
                }
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
    }
}

