/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import sc.fiji.io.AnimatedGifEncoder2;

public class Gif_Stack_Writer
implements PlugIn {
    static String type = "gif";

    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.showMessage((String)"Save As ", (String)"No images are open.");
            return;
        }
        String name = imp.getTitle();
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex >= 0) {
            name = name.substring(0, dotIndex);
        }
        AnimatedGifEncoder2 fr = new AnimatedGifEncoder2();
        fr.name = name;
        if (!fr.setoptions()) {
            return;
        }
        name = fr.name;
        IJ.register(Gif_Stack_Writer.class);
        SaveDialog sd = new SaveDialog("Filename", name + "." + type, "." + type);
        String file = sd.getFileName();
        if (file == null) {
            return;
        }
        String directory = sd.getDirectory();
        ImageStack stack = imp.getStack();
        ImagePlus tmp = new ImagePlus();
        int nSlices = stack.getSize();
        fr.start(directory + file);
        for (int i = 1; i <= nSlices; ++i) {
            IJ.showStatus((String)("writing: " + i + "/" + nSlices));
            IJ.showProgress((double)((double)i / (double)nSlices));
            tmp.setProcessor(null, stack.getProcessor(i));
            try {
                fr.addFrame(tmp);
            }
            catch (Exception e) {
                IJ.showMessage((String)("Save as " + type), (String)("" + e));
                break;
            }
            System.gc();
        }
        fr.finish();
        IJ.showStatus((String)"");
        IJ.showProgress((double)1.0);
    }
}

