/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.VirtualStack;
import ij.WindowManager;
import ij.io.FileInfo;
import ij.io.ImageWriter;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.zip.GZIPOutputStream;
import sc.fiji.io.NrrdFileInfo;

public class Nrrd_Writer
implements PlugIn {
    private static final String plugInName = "Nrrd Writer";
    private static final String noImages = "Nrrd Writer...\nNo images are open.";
    private static final String supportedTypes = "Nrrd Writer...Supported types:\n\n32-bit Grayscale float : FLOAT\n(32-bit Grayscale integer) : LONG\n16-bit Grayscale integer: INT\n(16-bit Grayscale unsigned integer) : UINT\n8-bit Grayscale : BYTE\n8-bit Colour LUT (converted to greyscale): BYTE\n";
    public static final int NRRD_VERSION = 4;
    private String imgTypeString = null;
    String nrrdEncoding = "raw";
    static final String defaultNrrdCentering = "node";

    public String setNrrdEncoding(String enc) throws IOException {
        if ((enc = enc.toLowerCase()).equals("raw")) {
            this.nrrdEncoding = "raw";
        } else if (enc.equals("gz") || enc.equals("gzip")) {
            this.nrrdEncoding = "gzip";
        } else {
            if (enc.equals("bz2") || enc.equals("bzip2")) {
                throw new IOException("bzip2 encoding not yet supported");
            }
            if (enc.equals("txt") || enc.equals("text") || enc.equals("ascii")) {
                throw new IOException("text encoding not yet supported");
            }
            if (enc.equals("hex")) {
                throw new IOException("hex encoding not yet supported");
            }
            throw new IOException("Unknown encoding " + enc);
        }
        return this.nrrdEncoding;
    }

    public void run(String arg) {
        SaveDialog sd;
        String file;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.showMessage((String)noImages);
            return;
        }
        String name = arg;
        if (arg == null || arg.equals("")) {
            name = imp.getTitle();
        }
        if (IJ.altKeyDown()) {
            if (IJ.debugMode) {
                IJ.log((String)"Setting gzip encoding");
            }
            try {
                this.setNrrdEncoding("gzip");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((file = (sd = new SaveDialog("Nrrd Writer...", name, ".nrrd")).getFileName()) == null) {
            return;
        }
        String directory = sd.getDirectory();
        this.save(imp, directory, file);
    }

    public void save(ImagePlus imp, String directory, String file) {
        boolean virtualStack;
        if (imp == null) {
            IJ.showMessage((String)noImages);
            return;
        }
        FileInfo fi = imp.getFileInfo();
        boolean bl = virtualStack = imp.getStackSize() > 1 && imp.getStack().isVirtual();
        if (virtualStack) {
            fi.virtualStack = (VirtualStack)imp.getStack();
        }
        if (this.imgTypeString == null) {
            this.imgTypeString = Nrrd_Writer.imgType(fi.fileType);
            if (this.imgTypeString.equals("unsupported")) {
                IJ.showMessage((String)supportedTypes);
                return;
            }
        }
        fi.fileName = file;
        fi.directory = directory;
        try {
            this.writeImage(fi, imp.getCalibration());
        }
        catch (IOException e) {
            IJ.error((String)("An error occured writing the file.\n \n" + e));
            IJ.showStatus((String)"");
        }
    }

    public void save(ImagePlus imp, String path) {
        File f = new File(path);
        this.save(imp, f.getParent(), f.getName());
    }

    void writeImage(FileInfo fi, Calibration cal) throws IOException {
        FileOutputStream out = new FileOutputStream(new File(fi.directory, fi.fileName));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out));
        if (this.nrrdEncoding.equals("gzip")) {
            fi.compression = 1001;
        }
        bw.write(Nrrd_Writer.makeHeader(fi, cal) + "\n");
        ((Writer)bw).flush();
        ImageWriter writer = new ImageWriter(fi);
        if (this.nrrdEncoding.equals("gzip")) {
            GZIPOutputStream zStream = new GZIPOutputStream(new BufferedOutputStream(out));
            writer.write((OutputStream)zStream);
            zStream.close();
        } else {
            writer.write((OutputStream)out);
            out.close();
        }
        IJ.showStatus((String)("Saved " + fi.fileName));
    }

    public static String makeDetachedHeader(FileInfo fi, Calibration cal, boolean withDataFile) {
        StringWriter out = new StringWriter();
        out.write(Nrrd_Writer.makeHeader(fi, cal));
        out.write("byte skip: " + (fi.longOffset > 0L ? fi.longOffset : (long)fi.offset) + "\n");
        if (withDataFile) {
            out.write("data file: " + fi.fileName + "\n");
        }
        return out.toString();
    }

    public static String makeHeader(FileInfo fi, Calibration cal) {
        String units;
        StringWriter out = new StringWriter();
        out.write("NRRD0004\n");
        out.write("# Created by Nrrd_Writer at " + new Date() + "\n");
        out.write("type: " + Nrrd_Writer.imgType(fi.fileType) + "\n");
        out.write("encoding: " + Nrrd_Writer.getEncoding(fi) + "\n");
        if (fi.intelByteOrder) {
            out.write("endian: little\n");
        } else {
            out.write("endian: big\n");
        }
        int dimension = fi.nImages == 1 ? 2 : 3;
        out.write("dimension: " + dimension + "\n");
        out.write(Nrrd_Writer.dimmedLine("sizes", dimension, fi.width + "", fi.height + "", fi.nImages + ""));
        if (cal != null) {
            out.write("space dimension: " + dimension + "\n");
            out.write(Nrrd_Writer.dimmedLine("space directions", dimension, "(" + cal.pixelWidth + ",0,0)", "(0," + cal.pixelHeight + ",0)", "(0,0," + cal.pixelDepth + ")"));
        }
        if ((units = cal != null ? cal.getUnit() : fi.unit).equals("\u00b5m")) {
            units = "microns";
        }
        if (units.equals("micron")) {
            units = "microns";
        }
        if (!units.equals("")) {
            out.write(Nrrd_Writer.dimmedQuotedLine("space units", dimension, units, units, units));
        }
        if (cal != null && (cal.xOrigin != 0.0 || cal.yOrigin != 0.0 || cal.zOrigin != 0.0)) {
            out.write("space origin: (" + cal.xOrigin * cal.pixelWidth + "," + cal.yOrigin * cal.pixelHeight + "," + cal.zOrigin * cal.pixelDepth + ")\n");
        }
        return out.toString();
    }

    public static String imgType(int fiType) {
        switch (fiType) {
            case 4: {
                return "float";
            }
            case 3: {
                return "int32";
            }
            case 11: {
                return "uint32";
            }
            case 1: {
                return "int16";
            }
            case 2: {
                return "uint16";
            }
            case 0: 
            case 5: {
                return "uint8";
            }
        }
        return "unsupported";
    }

    public static String getEncoding(FileInfo fi) {
        if (IJ.debugMode) {
            IJ.log((String)("fi :" + fi));
        }
        try {
            NrrdFileInfo nfi = (NrrdFileInfo)fi;
            if (IJ.debugMode) {
                IJ.log((String)("nfi :" + (Object)((Object)nfi)));
            }
            if (nfi.encoding != null && !nfi.encoding.equals("")) {
                return nfi.encoding;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (fi.compression) {
            case 1001: {
                return "gzip";
            }
            case 1003: {
                return null;
            }
        }
        switch (fi.fileFormat) {
            case 1002: 
            case 1003: {
                return null;
            }
        }
        return "raw";
    }

    private static String dimmedQuotedLine(String tag, int dimension, String x1, String x2, String x3) {
        x1 = "\"" + x1 + "\"";
        x2 = "\"" + x2 + "\"";
        x3 = "\"" + x3 + "\"";
        return Nrrd_Writer.dimmedLine(tag, dimension, x1, x2, x3);
    }

    private static String dimmedLine(String tag, int dimension, String x1, String x2, String x3) {
        String rval = null;
        if (dimension == 2) {
            rval = tag + ": " + x1 + " " + x2 + "\n";
        } else if (dimension == 3) {
            rval = tag + ": " + x1 + " " + x2 + " " + x3 + "\n";
        }
        return rval;
    }
}

