/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.fife.rsta.ac.AbstractSourceTree;
import org.fife.rsta.ac.java.tree.JavaOutlineTree;
import org.fife.rsta.ac.js.tree.JavaScriptOutlineTree;
import org.fife.rsta.ac.xml.tree.XmlOutlineTree;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.scijava.script.ScriptLanguage;
import org.scijava.ui.swing.script.EditorPane;
import org.scijava.ui.swing.script.TextEditor;

class OutlineTreePanel
extends JScrollPane {
    private static final long serialVersionUID = -710040159139542578L;
    private AbstractSourceTree sourceTree;
    private final Color placeholdColor;
    private float fontSize = this.getFont().getSize();
    private boolean sorted;
    private boolean major;

    OutlineTreePanel() {
        this.setViewportView(new UnsupportedLangTree());
        this.placeholdColor = TextEditor.GuiUtils.getDisabledComponentColor();
    }

    protected void rebuildSourceTree(EditorPane pane) {
        ScriptLanguage sLanguage;
        String language;
        if (!this.isVisible()) {
            return;
        }
        if (this.sourceTree != null) {
            this.sourceTree.uninstall();
        }
        switch (language = (sLanguage = pane.getCurrentLanguage()) == null ? "" : sLanguage.getLanguageName()) {
            case "Java": {
                this.sourceTree = new JavaOutlineTree(this.sorted);
                break;
            }
            case "JavaScript": {
                this.sourceTree = new JavaScriptOutlineTree(this.sorted);
                break;
            }
            default: {
                this.sourceTree = "text/xml".equals(pane.getSyntaxEditingStyle()) ? new XmlOutlineTree(this.sorted) : null;
            }
        }
        this.fontSize = pane.getFontSize();
        if (this.sourceTree == null) {
            this.setViewportView(new UnsupportedLangTree(pane));
        } else {
            this.sourceTree.setShowMajorElementsOnly(this.major);
            this.sourceTree.setFont(this.sourceTree.getFont().deriveFont(this.fontSize));
            this.sourceTree.listenTo((RSyntaxTextArea)pane);
            this.setViewportView((Component)this.sourceTree);
            this.setPopupMenu((JTree)this.sourceTree, pane);
        }
        this.revalidate();
    }

    private void setPopupMenu(JTree tree, EditorPane pane) {
        JMenuItem jmi;
        JPopupMenu popup = new JPopupMenu();
        if (tree instanceof AbstractSourceTree) {
            jmi = new JMenuItem("Collapse All");
            jmi.addActionListener(e -> TextEditor.GuiUtils.collapseAllTreeNodes(tree));
            popup.add(jmi);
            jmi = new JMenuItem("Expand All");
            jmi.addActionListener(e -> TextEditor.GuiUtils.expandAllTreeNodes(tree));
            popup.add(jmi);
            popup.addSeparator();
            JCheckBoxMenuItem jcmi1 = new JCheckBoxMenuItem("Hide 'Minor' Elements", this.major);
            jcmi1.setToolTipText("Whether non-proeminent elements (e.g., local variables) should be displayed");
            jcmi1.addItemListener(e -> {
                this.major = jcmi1.isSelected();
                ((AbstractSourceTree)tree).setShowMajorElementsOnly(this.major);
                ((AbstractSourceTree)tree).refresh();
            });
            popup.add(jcmi1);
            JCheckBoxMenuItem jcmi2 = new JCheckBoxMenuItem("Sort Elements", this.sorted);
            jcmi2.addItemListener(e -> {
                this.sorted = jcmi2.isSelected();
                ((AbstractSourceTree)tree).setSorted(this.sorted);
            });
            popup.add(jcmi2);
            popup.addSeparator();
        }
        jmi = new JMenuItem("Rebuild");
        jmi.addActionListener(e -> this.rebuildSourceTree(pane));
        popup.add(jmi);
        tree.setComponentPopupMenu(popup);
    }

    private class UnsupportedLangTree
    extends JTree {
        private static final long serialVersionUID = 1L;
        private static final String HOLDER = "Outline not available... (Currently, only Java, JS, & XML are supported)";

        public UnsupportedLangTree() {
            super((TreeNode)null);
        }

        public UnsupportedLangTree(EditorPane pane) {
            this();
            outlineTreePanel.setPopupMenu(this, pane);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setColor(OutlineTreePanel.this.placeholdColor);
            Insets i = this.getInsets();
            float yTop = i.top;
            int w = this.getWidth() - i.left - i.right;
            int lastIndex = HOLDER.length();
            AttributedString ac = new AttributedString(HOLDER);
            ac.addAttribute(TextAttribute.SIZE, Float.valueOf(OutlineTreePanel.this.fontSize), 0, lastIndex);
            ac.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, 0, lastIndex);
            AttributedCharacterIterator aci = ac.getIterator();
            FontRenderContext frc = g2.getFontRenderContext();
            LineBreakMeasurer lbm = new LineBreakMeasurer(aci, frc);
            while (lbm.getPosition() < aci.getEndIndex()) {
                TextLayout tl = lbm.nextLayout(w);
                float xPos = (float)((double)i.left + ((double)this.getWidth() - tl.getBounds().getWidth()) / 2.0);
                float yPos = (float)((double)yTop + ((double)this.getHeight() - tl.getBounds().getHeight()) / 2.0);
                tl.draw(g2, xPos, yPos + tl.getAscent());
                yTop += tl.getDescent() + tl.getLeading() + tl.getAscent();
            }
            g2.dispose();
        }
    }
}

