/*
 * Decompiled with CFR 0.152.
 */
package de.biomedical_imaging.ij.steger;

import de.biomedical_imaging.ij.steger.Crossref;
import de.biomedical_imaging.ij.steger.Junction;
import de.biomedical_imaging.ij.steger.Junctions;
import de.biomedical_imaging.ij.steger.Line;
import de.biomedical_imaging.ij.steger.Lines;
import de.biomedical_imaging.ij.steger.LinesUtil;
import de.biomedical_imaging.ij.steger.Offset;
import de.biomedical_imaging.ij.steger.Region;
import de.biomedical_imaging.ij.steger.Threshold;
import de.biomedical_imaging.ij.steger.Width;
import java.util.Arrays;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableInt;

public class Link {
    public static final double MAX_ANGLE_DIFFERENCE = 0.5235987755982988;
    static final int[][][] dirtab = new int[][][]{new int[][]{{1, 0}, {1, -1}, {1, 1}}, new int[][]{{1, 1}, {1, 0}, {0, 1}}, new int[][]{{0, 1}, {1, 1}, {-1, 1}}, new int[][]{{-1, 1}, {0, 1}, {-1, 0}}, new int[][]{{-1, 0}, {-1, 1}, {-1, -1}}, new int[][]{{-1, -1}, {-1, 0}, {0, -1}}, new int[][]{{0, -1}, {-1, -1}, {1, -1}}, new int[][]{{1, -1}, {0, -1}, {1, 0}}};
    static final int[][][] cleartab = new int[][][]{new int[][]{{0, 1}, {0, -1}}, new int[][]{{-1, 1}, {1, -1}}, new int[][]{{-1, 0}, {1, 0}}, new int[][]{{-1, -1}, {1, 1}}, new int[][]{{0, -1}, {0, 1}}, new int[][]{{1, -1}, {-1, 1}}, new int[][]{{1, 0}, {-1, 0}}, new int[][]{{1, 1}, {-1, -1}}};

    private double interpolate_response(float[] resp, int x, int y, double px, double py, int width, int height) {
        double i1 = resp[LinesUtil.LINCOOR(LinesUtil.BR(x - 1, height), LinesUtil.BC(y - 1, width), width)];
        double i2 = resp[LinesUtil.LINCOOR(LinesUtil.BR(x - 1, height), y, width)];
        double i3 = resp[LinesUtil.LINCOOR(LinesUtil.BR(x - 1, height), LinesUtil.BC(y + 1, width), width)];
        double i4 = resp[LinesUtil.LINCOOR(x, LinesUtil.BC(y - 1, width), width)];
        double i5 = resp[LinesUtil.LINCOOR(x, y, width)];
        double i6 = resp[LinesUtil.LINCOOR(x, LinesUtil.BC(y + 1, width), width)];
        double i7 = resp[LinesUtil.LINCOOR(LinesUtil.BR(x + 1, height), LinesUtil.BC(y - 1, width), width)];
        double i8 = resp[LinesUtil.LINCOOR(LinesUtil.BR(x + 1, height), y, width)];
        double i9 = resp[LinesUtil.LINCOOR(LinesUtil.BR(x + 1, height), LinesUtil.BC(y + 1, width), width)];
        double t1 = i1 + i2 + i3;
        double t2 = i4 + i5 + i6;
        double t3 = i7 + i8 + i9;
        double t4 = i1 + i4 + i7;
        double t5 = i2 + i5 + i8;
        double t6 = i3 + i6 + i9;
        double d = (-i1 + 2.0 * i2 - i3 + 2.0 * i4 + 5.0 * i5 + 2.0 * i6 - i7 + 2.0 * i8 - i9) / 9.0;
        double dr = (t3 - t1) / 6.0;
        double dc = (t6 - t4) / 6.0;
        double drr = (t1 - 2.0 * t2 + t3) / 6.0;
        double dcc = (t4 - 2.0 * t5 + t6) / 6.0;
        double drc = (i1 - i3 - i7 + i9) / 4.0;
        double xx = px - (double)x;
        double yy = py - (double)y;
        return d + xx * dr + yy * dc + xx * xx * drr + xx * yy * drc + yy * yy * dcc;
    }

    private void closest_point(double lx, double ly, double dx, double dy, double px, double py, MutableDouble cx, MutableDouble cy, MutableDouble t) {
        double mx = px - lx;
        double my = py - ly;
        double den = dx * dx + dy * dy;
        double nom = mx * dx + my * dy;
        double tt = den != 0.0 ? nom / den : 0.0;
        cx.setValue(lx + tt * dx);
        cy.setValue(ly + tt * dy);
        t.setValue(tt);
    }

    private void interpolate_gradient(float[] gradx, float[] grady, double px, double py, int width, MutableDouble gx, MutableDouble gy) {
        int gix = (int)Math.floor(px);
        int giy = (int)Math.floor(py);
        double gfx = px % 1.0;
        double gfy = py % 1.0;
        int gpos = LinesUtil.LINCOOR(gix, giy, width);
        double gx1 = gradx[gpos];
        double gy1 = grady[gpos];
        gpos = LinesUtil.LINCOOR(gix + 1, giy, width);
        double gx2 = gradx[gpos];
        double gy2 = grady[gpos];
        gpos = LinesUtil.LINCOOR(gix, giy + 1, width);
        double gx3 = gradx[gpos];
        double gy3 = grady[gpos];
        gpos = LinesUtil.LINCOOR(gix + 1, giy + 1, width);
        double gx4 = gradx[gpos];
        double gy4 = grady[gpos];
        gx.setValue((1.0 - gfy) * ((1.0 - gfx) * gx1 + gfx * gx2) + gfy * ((1.0 - gfx) * gx3 + gfx * gx4));
        gy.setValue((1.0 - gfy) * ((1.0 - gfx) * gy1 + gfx * gy2) + gfy * ((1.0 - gfx) * gy3 + gfx * gy4));
    }

    /*
     * Unable to fully structure code
     */
    public void compute_contours(byte[] ismax, float[] eigval, float[] normx, float[] normy, float[] posx, float[] posy, float[] gradx, float[] grady, Lines contours, MutableInt num_result, double sigma, boolean extend_lines, int mode, double low, double high, int width, int height, Junctions junctions) {
        i = 0;
        j = 0;
        nextpx = 0.0;
        nextpy = 0.0;
        m = 0;
        num_line = new MutableInt();
        end_angle = 0.0;
        end_resp = 0.0;
        t = new MutableDouble();
        seg = new Region();
        w = new Width();
        label = new int[width * height];
        Arrays.fill(label, 0);
        indx = new int[width * height];
        Arrays.fill(indx, 0);
        num_cont = 0;
        num_junc = 0;
        size_cont = 100;
        size_pnt = 100;
        size_junc = 100;
        cont = new Line[size_cont];
        for (o = 0; o < cont.length; ++o) {
            cont[o] = new Line();
        }
        row = new float[size_pnt];
        col = new float[size_pnt];
        angle = new float[size_pnt];
        resp = new float[size_pnt];
        junc = new Junction[size_junc];
        for (o = 0; o < junc.length; ++o) {
            junc[o] = new Junction();
        }
        Threshold.threshold(ismax, 2, width, height, seg);
        area = 0;
        for (i = 0; i < seg.num; ++i) {
            area += seg.rl[i].ce - seg.rl[i].cb + 1;
        }
        cross = new Crossref[area];
        for (o = 0; o < cross.length; ++o) {
            cross[o] = new Crossref();
        }
        k = 0;
        rl = seg.rl;
        for (i = 0; i < seg.num; ++i) {
            x = rl[i].r;
            for (y = rl[i].cb; y <= rl[i].ce; ++y) {
                pos = LinesUtil.LINCOOR(x, y, width);
                cross[k].x = (short)x;
                cross[k].y = (short)y;
                cross[k].value = eigval[pos];
                cross[k].done = false;
                ++k;
            }
        }
        Arrays.sort(cross);
        for (i = 0; i < area; ++i) {
            indx[LinesUtil.LINCOOR((int)cross[i].x, (int)cross[i].y, (int)width)] = i + 1;
        }
        indx_max = 0;
        block13: while (true) {
            cls = LinesUtil.contour_class.cont_no_junc;
            while (indx_max < area && cross[indx_max].done) {
                ++indx_max;
            }
            if (indx_max == area) break;
            max = cross[indx_max].value;
            maxx = cross[indx_max].x;
            maxy = cross[indx_max].y;
            if (max == 0.0) break;
            num_pnt = 0;
            pos = LinesUtil.LINCOOR(maxx, maxy, width);
            label[pos] = num_cont + 1;
            if (indx[pos] != 0) {
                cross[indx[pos] - 1].done = true;
            }
            row[num_pnt] = posx[pos];
            col[num_pnt] = posy[pos];
            ny = normx[pos];
            nx = -normy[pos];
            alpha = Math.atan2(ny, nx);
            if (alpha < 0.0) {
                alpha += 6.283185307179586;
            }
            if (alpha >= 3.141592653589793) {
                alpha -= 3.141592653589793;
            }
            octant = (int)Math.floor(1.2732395447351628 * alpha + 0.5) % 4;
            beta = alpha + 1.5707963267948966;
            if (beta >= 6.283185307179586) {
                beta -= 6.283185307179586;
            }
            angle[num_pnt] = (float)beta;
            resp[num_pnt] = (float)this.interpolate_response(eigval, maxx, maxy, posx[pos], posy[pos], width, height);
            ++num_pnt;
            for (i = 0; i < 2; ++i) {
                nextx = maxx + Link.cleartab[octant][i][0];
                nexty = maxy + Link.cleartab[octant][i][1];
                if (nextx < 0 || nextx >= height || nexty < 0 || nexty >= width || ismax[nextpos = LinesUtil.LINCOOR(nextx, nexty, width)] <= 0) continue;
                ny = normx[nextpos];
                nx = -normy[nextpos];
                nextalpha = Math.atan2(ny, nx);
                if (nextalpha < 0.0) {
                    nextalpha += 6.283185307179586;
                }
                if (nextalpha >= 3.141592653589793) {
                    nextalpha -= 3.141592653589793;
                }
                if ((diff = Math.abs(alpha - nextalpha)) >= 1.5707963267948966) {
                    diff = 3.141592653589793 - diff;
                }
                if (!(diff < 0.5235987755982988)) continue;
                label[nextpos] = num_cont + 1;
                if (indx[nextpos] == 0) continue;
                cross[indx[nextpos] - 1].done = true;
            }
            block16: for (it = 1; it <= 2; ++it) {
                if (it == 1) {
                    x = maxx;
                    y = maxy;
                    pos = LinesUtil.LINCOOR(x, y, width);
                    ny = normx[pos];
                    alpha = Math.atan2(ny, nx = (double)(-normy[pos]));
                    if (alpha < 0.0) {
                        alpha += 6.283185307179586;
                    }
                    if (alpha >= 3.141592653589793) {
                        alpha -= 3.141592653589793;
                    }
                    last_octant = (int)Math.floor(1.2732395447351628 * alpha + 0.5) % 4;
                    last_beta = alpha + 1.5707963267948966;
                    if (last_beta >= 6.283185307179586) {
                        last_beta -= 6.283185307179586;
                    }
                } else {
                    x = maxx;
                    y = maxy;
                    pos = LinesUtil.LINCOOR(x, y, width);
                    ny = normx[pos];
                    alpha = Math.atan2(ny, nx = (double)(-normy[pos]));
                    if (alpha < 0.0) {
                        alpha += 6.283185307179586;
                    }
                    if (alpha >= 3.141592653589793) {
                        alpha -= 3.141592653589793;
                    }
                    last_octant = (int)Math.floor(1.2732395447351628 * alpha + 0.5) % 4 + 4;
                    last_beta = alpha + 1.5707963267948966;
                    if (last_beta >= 6.283185307179586) {
                        last_beta -= 6.283185307179586;
                    }
                }
                if (it == 2) {
                    for (i = 0; i < num_pnt / 2; ++i) {
                        tmp = row[i];
                        row[i] = row[num_pnt - 1 - i];
                        row[num_pnt - 1 - i] = tmp;
                        tmp = col[i];
                        col[i] = col[num_pnt - 1 - i];
                        col[num_pnt - 1 - i] = tmp;
                        tmp = angle[i];
                        angle[i] = angle[num_pnt - 1 - i];
                        angle[num_pnt - 1 - i] = tmp;
                        tmp = resp[i];
                        resp[i] = resp[num_pnt - 1 - i];
                        resp[num_pnt - 1 - i] = tmp;
                    }
                }
                while (true) {
                    pos = LinesUtil.LINCOOR(x, y, width);
                    nx = -normy[pos];
                    ny = normx[pos];
                    px = posx[pos];
                    py = posy[pos];
                    alpha = Math.atan2(ny, nx);
                    if (alpha < 0.0) {
                        alpha += 6.283185307179586;
                    }
                    if (alpha >= 3.141592653589793) {
                        alpha -= 3.141592653589793;
                    }
                    octant = (int)Math.floor(1.2732395447351628 * alpha + 0.5) % 4;
                    switch (octant) {
                        case 0: {
                            if (last_octant < 3 || last_octant > 5) break;
                            octant = 4;
                            break;
                        }
                        case 1: {
                            if (last_octant < 4 || last_octant > 6) break;
                            octant = 5;
                            break;
                        }
                        case 2: {
                            if (last_octant < 4 || last_octant > 7) break;
                            octant = 6;
                            break;
                        }
                        case 3: {
                            if (last_octant != 0 && last_octant < 6) break;
                            octant = 7;
                        }
                    }
                    last_octant = octant;
                    nextismax = false;
                    nexti = 1;
                    mindiff = 1.7976931348623157E308;
                    for (i = 0; i < 3; ++i) {
                        nextx = x + Link.dirtab[octant][i][0];
                        nexty = y + Link.dirtab[octant][i][1];
                        if (nextx < 0 || nextx >= height || nexty < 0 || nexty >= width || ismax[nextpos = LinesUtil.LINCOOR(nextx, nexty, width)] == 0) continue;
                        nextpx = posx[nextpos];
                        nextpy = posy[nextpos];
                        dx = nextpx - px;
                        dy = nextpy - py;
                        dist = Math.sqrt(dx * dx + dy * dy);
                        ny = normx[nextpos];
                        nx = -normy[nextpos];
                        nextalpha = Math.atan2(ny, nx);
                        if (nextalpha < 0.0) {
                            nextalpha += 6.283185307179586;
                        }
                        if (nextalpha >= 3.141592653589793) {
                            nextalpha -= 3.141592653589793;
                        }
                        if ((diff = Math.abs(alpha - nextalpha)) >= 1.5707963267948966) {
                            diff = 3.141592653589793 - diff;
                        }
                        if ((diff = dist + diff) < mindiff) {
                            mindiff = diff;
                            nexti = i;
                        }
                        if (ismax[nextpos] == 0) continue;
                        nextismax = true;
                    }
                    for (i = 0; i < 2; ++i) {
                        nextx = x + Link.cleartab[octant][i][0];
                        nexty = y + Link.cleartab[octant][i][1];
                        if (nextx < 0 || nextx >= height || nexty < 0 || nexty >= width || ismax[nextpos = LinesUtil.LINCOOR(nextx, nexty, width)] <= 0) continue;
                        ny = normx[nextpos];
                        nx = -normy[nextpos];
                        nextalpha = Math.atan2(ny, nx);
                        if (nextalpha < 0.0) {
                            nextalpha += 6.283185307179586;
                        }
                        if (nextalpha >= 3.141592653589793) {
                            nextalpha -= 3.141592653589793;
                        }
                        if ((diff = Math.abs(alpha - nextalpha)) >= 1.5707963267948966) {
                            diff = 3.141592653589793 - diff;
                        }
                        if (!(diff < 0.5235987755982988)) continue;
                        label[nextpos] = num_cont + 1;
                        if (indx[nextpos] == 0) continue;
                        cross[indx[nextpos] - 1].done = true;
                    }
                    if (!nextismax) continue block16;
                    x += Link.dirtab[octant][nexti][0];
                    y += Link.dirtab[octant][nexti][1];
                    if (num_pnt >= size_pnt) {
                        size_pnt = (int)Math.floor(size_pnt * 2);
                        newArr = new float[size_pnt];
                        for (o = 0; o < row.length; ++o) {
                            newArr[o] = row[o];
                        }
                        row = newArr;
                        newArr = new float[size_pnt];
                        for (o = 0; o < col.length; ++o) {
                            newArr[o] = col[o];
                        }
                        col = newArr;
                        newArr = new float[size_pnt];
                        for (o = 0; o < angle.length; ++o) {
                            newArr[o] = angle[o];
                        }
                        angle = newArr;
                        newArr = new float[size_pnt];
                        for (o = 0; o < resp.length; ++o) {
                            resp[o] = resp[o];
                        }
                        resp = newArr;
                    }
                    pos = LinesUtil.LINCOOR(x, y, width);
                    row[num_pnt] = posx[pos];
                    col[num_pnt] = posy[pos];
                    ny = normy[pos];
                    nx = normx[pos];
                    beta = Math.atan2(ny, nx);
                    if (beta < 0.0) {
                        beta += 6.283185307179586;
                    }
                    if (beta >= 3.141592653589793) {
                        beta -= 3.141592653589793;
                    }
                    if ((diff1 = Math.abs(beta - last_beta)) >= 3.141592653589793) {
                        diff1 = 6.283185307179586 - diff1;
                    }
                    if ((diff2 = Math.abs(beta + 3.141592653589793 - last_beta)) >= 3.141592653589793) {
                        diff2 = 6.283185307179586 - diff2;
                    }
                    if (diff1 < diff2) {
                        angle[num_pnt] = (float)beta;
                        last_beta = beta;
                    } else {
                        angle[num_pnt] = (float)(beta + 3.141592653589793);
                        last_beta = beta + 3.141592653589793;
                    }
                    resp[num_pnt] = (float)this.interpolate_response(eigval, x, y, posx[pos], posy[pos], width, height);
                    ++num_pnt;
                    if (label[pos] > 0) {
                        if (num_junc >= size_junc) {
                            size_junc = (int)Math.floor(size_junc * 2);
                            junch = new Junction[size_junc];
                            for (o = 0; o < junch.length; ++o) {
                                junch[o] = o < junc.length ? junc[o] : new Junction();
                            }
                            junc = junch;
                        }
                        if ((k = label[pos] - 1) == num_cont) {
                            for (j = 0; j < num_pnt - 1; ++j) {
                                if (row[j] != posx[pos] || col[j] != posy[pos]) continue;
                                if (j == 0) {
                                    cls = LinesUtil.contour_class.cont_closed;
                                    for (i = 0; i < num_pnt / 2; ++i) {
                                        tmp = row[i];
                                        row[i] = row[num_pnt - 1 - i];
                                        row[num_pnt - 1 - i] = tmp;
                                        tmp = col[i];
                                        col[i] = col[num_pnt - 1 - i];
                                        col[num_pnt - 1 - i] = tmp;
                                        tmp = angle[i];
                                        angle[i] = angle[num_pnt - 1 - i];
                                        angle[num_pnt - 1 - i] = tmp;
                                        tmp = resp[i];
                                        resp[i] = resp[num_pnt - 1 - i];
                                        resp[num_pnt - 1 - i] = tmp;
                                    }
                                    it = 2;
                                    break;
                                }
                                if (it == 2) {
                                    cls = cls == LinesUtil.contour_class.cont_start_junc ? LinesUtil.contour_class.cont_both_junc : LinesUtil.contour_class.cont_end_junc;
                                    junc[num_junc].cont1 = num_cont;
                                    junc[num_junc].cont2 = num_cont;
                                    junc[num_junc].pos = j;
                                    junc[num_junc].x = posx[pos];
                                    junc[num_junc].y = posy[pos];
                                    ++num_junc;
                                    break;
                                }
                                cls = LinesUtil.contour_class.cont_start_junc;
                                junc[num_junc].cont1 = num_cont;
                                junc[num_junc].cont2 = num_cont;
                                junc[num_junc].pos = num_pnt - 1 - j;
                                junc[num_junc].x = posx[pos];
                                junc[num_junc].y = posy[pos];
                                ++num_junc;
                                break;
                            }
                            j = -1;
                        } else {
                            for (j = 0; j < cont[k].num && (cont[k].row[j] != posx[pos] || cont[k].col[j] != posy[pos]); ++j) {
                            }
                            if (j == cont[k].num) {
                                mindist = 1.7976931348623157E308;
                                j = -1;
                                for (l = 0; l < cont[k].num; ++l) {
                                    dx = posx[pos] - cont[k].row[l];
                                    dy = posy[pos] - cont[k].col[l];
                                    dist = Math.sqrt(dx * dx + dy * dy);
                                    if (!(dist < mindist)) continue;
                                    mindist = dist;
                                    j = l;
                                }
                                if (num_pnt >= size_pnt) {
                                    size_pnt = (int)Math.floor(size_pnt * 2);
                                    newArr = new float[size_pnt];
                                    for (o = 0; o < row.length; ++o) {
                                        newArr[o] = row[o];
                                    }
                                    row = newArr;
                                    newArr = new float[size_pnt];
                                    for (o = 0; o < col.length; ++o) {
                                        newArr[o] = col[o];
                                    }
                                    col = newArr;
                                    newArr = new float[size_pnt];
                                    for (o = 0; o < angle.length; ++o) {
                                        newArr[o] = angle[o];
                                    }
                                    angle = newArr;
                                    newArr = new float[size_pnt];
                                    for (o = 0; o < resp.length; ++o) {
                                        resp[o] = resp[o];
                                    }
                                    resp = newArr;
                                }
                                row[num_pnt] = cont[k].row[j];
                                col[num_pnt] = cont[k].col[j];
                                beta = cont[k].angle[j];
                                if (beta >= 3.141592653589793) {
                                    beta -= 3.141592653589793;
                                }
                                if ((diff1 = Math.abs(beta - last_beta)) >= 3.141592653589793) {
                                    diff1 = 6.283185307179586 - diff1;
                                }
                                if ((diff2 = Math.abs(beta + 3.141592653589793 - last_beta)) >= 3.141592653589793) {
                                    diff2 = 6.283185307179586 - diff2;
                                }
                                angle[num_pnt] = diff1 < diff2 ? (float)beta : (float)(beta + 3.141592653589793);
                                resp[num_pnt] = cont[k].response[j];
                                ++num_pnt;
                            }
                        }
                        if (j <= 0 || j >= cont[k].num - 1) continue block16;
                        cls = it == 1 ? LinesUtil.contour_class.cont_start_junc : (cls == LinesUtil.contour_class.cont_start_junc ? LinesUtil.contour_class.cont_both_junc : LinesUtil.contour_class.cont_end_junc);
                        junc[num_junc].cont1 = k;
                        junc[num_junc].cont2 = num_cont;
                        junc[num_junc].pos = j;
                        junc[num_junc].x = row[num_pnt - 1];
                        junc[num_junc].y = col[num_pnt - 1];
                        ++num_junc;
                        continue block16;
                    }
                    label[pos] = num_cont + 1;
                    if (indx[pos] == 0) continue;
                    cross[indx[pos] - 1].done = true;
                }
            }
            if (num_pnt > 1) {
                if (num_cont >= size_cont) {
                    size_cont = (int)Math.floor(size_cont * 2);
                    conth = new Line[size_cont];
                    for (o = 0; o < conth.length; ++o) {
                        conth[o] = o < cont.length ? cont[o] : new Line();
                    }
                    cont = conth;
                }
                cont[num_cont] = new Line();
                cont[num_cont].row = Arrays.copyOf(row, num_pnt);
                cont[num_cont].col = Arrays.copyOf(col, num_pnt);
                cont[num_cont].angle = Arrays.copyOf(angle, num_pnt);
                cont[num_cont].response = Arrays.copyOf(resp, num_pnt);
                cont[num_cont].width_r = null;
                cont[num_cont].width_l = null;
                cont[num_cont].asymmetry = null;
                cont[num_cont].intensity = null;
                cont[num_cont].num = num_pnt;
                cont[num_cont].setContourClass(cls);
                ++num_cont;
                continue;
            }
            i = -1;
            while (true) {
                if (i <= 1) ** break;
                continue block13;
                for (j = -1; j <= 1; ++j) {
                    pos = LinesUtil.LINCOOR(LinesUtil.BR(maxx + i, height), LinesUtil.BC(maxy + j, width), width);
                    if (label[pos] != num_cont + 1) continue;
                    label[pos] = 0;
                }
                ++i;
            }
            break;
        }
        if (extend_lines) {
            s = mode == 1 ? 1.0 : -1.0;
            length = MAX_LINE_EXTENSION = 2.5 * sigma;
            max_line = (int)Math.ceil(length * 3.0);
            line = new Offset[max_line];
            for (o = 0; o < line.length; ++o) {
                line[o] = new Offset();
            }
            extx = new float[max_line];
            exty = new float[max_line];
            for (i = 0; i < num_cont; ++i) {
                tmp_cont = cont[i];
                num_pnt = tmp_cont.num;
                if (num_pnt == 1 || tmp_cont.getContourClass() == LinesUtil.contour_class.cont_closed) continue;
                trow = tmp_cont.row;
                tcol = tmp_cont.col;
                tangle = tmp_cont.angle;
                tresp = tmp_cont.response;
                for (it = -1; it <= 1; it += 2) {
                    if (it == -1) {
                        if (tmp_cont.getContourClass() == LinesUtil.contour_class.cont_start_junc || tmp_cont.getContourClass() == LinesUtil.contour_class.cont_both_junc) continue;
                        dx = trow[1] - trow[0];
                        dy = tcol[1] - tcol[0];
                        alpha = tangle[0];
                        nx = Math.cos(alpha);
                        if (nx * dy - (ny = Math.sin(alpha)) * dx < 0.0) {
                            mx = -ny;
                            my = nx;
                        } else {
                            mx = ny;
                            my = -nx;
                        }
                        px = trow[0];
                        py = tcol[0];
                        response = tresp[0];
                    } else {
                        if (tmp_cont.getContourClass() == LinesUtil.contour_class.cont_end_junc || tmp_cont.getContourClass() == LinesUtil.contour_class.cont_both_junc) continue;
                        dx = trow[num_pnt - 1] - trow[num_pnt - 2];
                        dy = tcol[num_pnt - 1] - tcol[num_pnt - 2];
                        alpha = tangle[num_pnt - 1];
                        nx = Math.cos(alpha);
                        if (nx * dy - (ny = Math.sin(alpha)) * dx < 0.0) {
                            mx = ny;
                            my = -nx;
                        } else {
                            mx = -ny;
                            my = nx;
                        }
                        px = trow[num_pnt - 1];
                        py = tcol[num_pnt - 1];
                        response = tresp[num_pnt - 1];
                    }
                    x = (int)Math.floor(px + 0.5);
                    y = (int)Math.floor(py + 0.5);
                    dx = px - (double)x;
                    dy = py - (double)y;
                    w.bresenham(mx, my, dx, dy, length, line, num_line);
                    num_add = 0;
                    add_ext = false;
                    for (k = 0; k < num_line.intValue(); ++k) {
                        nextx = x + line[k].x;
                        nexty = y + line[k].y;
                        hnextpx = new MutableDouble(nextpx);
                        hnextpy = new MutableDouble(nextpy);
                        this.closest_point(px, py, mx, my, nextx, nexty, hnextpx, hnextpy, t);
                        nextpx = hnextpx.getValue();
                        nextpy = hnextpy.getValue();
                        if (t.getValue() <= 0.5) continue;
                        if (nextpx < 0.0 || nextpy < 0.0 || nextpx >= (double)(height - 1) || nextpy >= (double)(width - 1) || nextx < 0 || nexty < 0 || nextx >= height || nexty >= width) break;
                        hgx = new MutableDouble();
                        hgy = new MutableDouble();
                        this.interpolate_gradient(gradx, grady, nextpx, nextpy, width, hgx, hgy);
                        gx = hgx.getValue();
                        gy = hgy.getValue();
                        nextpos = LinesUtil.LINCOOR(nextx, nexty, width);
                        if (s * (mx * gx + my * gy) < 0.0 && label[nextpos] == 0) break;
                        if (label[nextpos] > 0) {
                            m = label[nextpos] - 1;
                            mindist = 1.7976931348623157E308;
                            j = -1;
                            for (l = 0; l < cont[m].num; ++l) {
                                dx = nextpx - (double)cont[m].row[l];
                                dy = nextpy - (double)cont[m].col[l];
                                dist = Math.sqrt(dx * dx + dy * dy);
                                if (!(dist < mindist)) continue;
                                mindist = dist;
                                j = l;
                            }
                            if (mindist > 3.0) break;
                            extx[num_add] = cont[m].row[j];
                            exty[num_add] = cont[m].col[j];
                            end_resp = cont[m].response[j];
                            end_angle = cont[m].angle[j];
                            beta = end_angle;
                            if (beta >= 3.141592653589793) {
                                beta -= 3.141592653589793;
                            }
                            if ((diff1 = Math.abs(beta - alpha)) >= 3.141592653589793) {
                                diff1 = 6.283185307179586 - diff1;
                            }
                            if ((diff2 = Math.abs(beta + 3.141592653589793 - alpha)) >= 3.141592653589793) {
                                diff2 = 6.283185307179586 - diff2;
                            }
                            end_angle = diff1 < diff2 ? beta : beta + 3.141592653589793;
                            ++num_add;
                            add_ext = true;
                            break;
                        }
                        extx[num_add] = (float)nextpx;
                        exty[num_add] = (float)nextpy;
                        ++num_add;
                    }
                    if (!add_ext) continue;
                    newArr = new float[num_pnt += num_add];
                    for (o = 0; o < trow.length; ++o) {
                        newArr[o] = trow[o];
                    }
                    trow = newArr;
                    newArr = new float[num_pnt];
                    for (o = 0; o < tcol.length; ++o) {
                        newArr[o] = tcol[o];
                    }
                    tcol = newArr;
                    newArr = new float[num_pnt];
                    for (o = 0; o < tangle.length; ++o) {
                        newArr[o] = tangle[o];
                    }
                    tangle = newArr;
                    newArr = new float[num_pnt];
                    for (o = 0; o < tresp.length; ++o) {
                        newArr[o] = tresp[o];
                    }
                    tresp = newArr;
                    tmp_cont.row = trow;
                    tmp_cont.col = tcol;
                    tmp_cont.angle = tangle;
                    tmp_cont.response = tresp;
                    tmp_cont.num = num_pnt;
                    if (it == -1) {
                        for (k = num_pnt - 1 - num_add; k >= 0; --k) {
                            trow[k + num_add] = trow[k];
                            tcol[k + num_add] = tcol[k];
                            tangle[k + num_add] = tangle[k];
                            tresp[k + num_add] = tresp[k];
                        }
                        for (k = 0; k < num_add; ++k) {
                            trow[k] = extx[num_add - 1 - k];
                            tcol[k] = exty[num_add - 1 - k];
                            tangle[k] = (float)alpha;
                            tresp[k] = (float)response;
                        }
                        tangle[0] = (float)end_angle;
                        tresp[0] = (float)end_resp;
                        for (k = 0; k < num_junc; ++k) {
                            if (junc[k].cont1 != i) continue;
                            junc[k].pos += num_add;
                        }
                    } else {
                        for (k = 0; k < num_add; ++k) {
                            trow[num_pnt - num_add + k] = extx[k];
                            tcol[num_pnt - num_add + k] = exty[k];
                            tangle[num_pnt - num_add + k] = (float)alpha;
                            tresp[num_pnt - num_add + k] = (float)response;
                        }
                        tangle[num_pnt - 1] = (float)end_angle;
                        tresp[num_pnt - 1] = (float)end_resp;
                    }
                    if (num_junc >= size_junc) {
                        size_junc = (int)Math.floor(size_junc * 2);
                        junch = new Junction[size_junc];
                        for (o = 0; o < junch.length; ++o) {
                            junch[o] = o < junc.length ? junc[o] : new Junction();
                        }
                        junc = junch;
                    }
                    if (j <= 0 || j >= cont[m].num - 1) continue;
                    if (it == -1) {
                        if (tmp_cont.getContourClass() == LinesUtil.contour_class.cont_end_junc) {
                            tmp_cont.setContourClass(LinesUtil.contour_class.cont_both_junc);
                        } else {
                            tmp_cont.setContourClass(LinesUtil.contour_class.cont_start_junc);
                        }
                    } else if (tmp_cont.getContourClass() == LinesUtil.contour_class.cont_start_junc) {
                        tmp_cont.setContourClass(LinesUtil.contour_class.cont_both_junc);
                    } else {
                        tmp_cont.setContourClass(LinesUtil.contour_class.cont_end_junc);
                    }
                    junc[num_junc].cont1 = m;
                    junc[num_junc].cont2 = i;
                    junc[num_junc].pos = j;
                    if (it == -1) {
                        junc[num_junc].x = trow[0];
                        junc[num_junc].y = tcol[0];
                    } else {
                        junc[num_junc].x = trow[num_pnt - 1];
                        junc[num_junc].y = tcol[num_pnt - 1];
                    }
                    ++num_junc;
                }
            }
        }
        Arrays.sort(junc);
        for (i = 0; i < num_junc; i += k) {
            j = junc[i].cont1;
            tmp_cont = cont[j];
            num_pnt = tmp_cont.num;
            k = 0;
            while (junc[i + k].cont1 == j && i + k < num_junc) {
                ++k;
            }
            if (k == 1 && tmp_cont.row[0] == tmp_cont.row[num_pnt - 1] && tmp_cont.col[0] == tmp_cont.col[num_pnt - 1]) {
                begin = junc[i].pos;
                trow = tmp_cont.row;
                tcol = tmp_cont.col;
                tangle = tmp_cont.angle;
                tresp = tmp_cont.response;
                tmp_cont.row = new float[num_pnt];
                tmp_cont.col = new float[num_pnt];
                tmp_cont.angle = new float[num_pnt];
                tmp_cont.response = new float[num_pnt];
                for (l = 0; l < num_pnt; ++l) {
                    pos = begin + l;
                    if (pos >= num_pnt) {
                        pos = begin + l - num_pnt + 1;
                    }
                    tmp_cont.row[l] = trow[pos];
                    tmp_cont.col[l] = tcol[pos];
                    tmp_cont.angle[l] = tangle[pos];
                    tmp_cont.response[l] = tresp[pos];
                }
                tmp_cont.setContourClass(LinesUtil.contour_class.cont_both_junc);
                continue;
            }
            for (l = 0; l <= k; ++l) {
                end = l == k ? tmp_cont.num - 1 : junc[i + l].pos;
                num_pnt = end - (begin = l == 0 ? 0 : junc[i + l - 1].pos) + 1;
                if (num_pnt == 1 && k > 1) continue;
                if (num_cont >= size_cont) {
                    size_cont = (int)Math.floor(size_cont * 2);
                    conth = new Line[size_cont];
                    for (o = 0; o < cont.length; ++o) {
                        conth[o] = cont[o];
                    }
                    cont = conth;
                }
                cont[num_cont] = new Line();
                cont[num_cont].row = new float[num_pnt];
                cont[num_cont].col = new float[num_pnt];
                cont[num_cont].angle = new float[num_pnt];
                cont[num_cont].response = new float[num_pnt];
                System.arraycopy(tmp_cont.row, begin, cont[num_cont].row, 0, num_pnt);
                System.arraycopy(tmp_cont.col, begin, cont[num_cont].col, 0, num_pnt);
                System.arraycopy(tmp_cont.angle, begin, cont[num_cont].angle, 0, num_pnt);
                System.arraycopy(tmp_cont.response, begin, cont[num_cont].response, 0, num_pnt);
                cont[num_cont].width_r = null;
                cont[num_cont].width_l = null;
                cont[num_cont].asymmetry = null;
                cont[num_cont].intensity = null;
                cont[num_cont].num = num_pnt;
                if (l == 0) {
                    if (tmp_cont.getContourClass() == LinesUtil.contour_class.cont_start_junc || tmp_cont.getContourClass() == LinesUtil.contour_class.cont_both_junc) {
                        cont[num_cont].setContourClass(LinesUtil.contour_class.cont_both_junc);
                    } else {
                        cont[num_cont].setContourClass(LinesUtil.contour_class.cont_end_junc);
                    }
                } else if (l == k) {
                    if (tmp_cont.getContourClass() == LinesUtil.contour_class.cont_end_junc || tmp_cont.getContourClass() == LinesUtil.contour_class.cont_both_junc) {
                        cont[num_cont].setContourClass(LinesUtil.contour_class.cont_both_junc);
                    } else {
                        cont[num_cont].setContourClass(LinesUtil.contour_class.cont_start_junc);
                    }
                } else {
                    cont[num_cont].setContourClass(LinesUtil.contour_class.cont_both_junc);
                }
                ++num_cont;
            }
            cont[j] = cont[--num_cont];
        }
        for (i = 0; i < num_cont; ++i) {
            tmp_cont = cont[i];
            num_pnt = tmp_cont.num;
            if (num_pnt <= 1) continue;
            trow = tmp_cont.row;
            tcol = tmp_cont.col;
            tangle = tmp_cont.angle;
            k = (num_pnt - 1) / 2;
            dx = trow[k + 1] - trow[k];
            dy = tcol[k + 1] - tcol[k];
            nx = Math.cos(tangle[k]);
            if (!(nx * dy - (ny = Math.sin(tangle[k])) * dx < 0.0)) continue;
            for (j = 0; j < num_pnt; ++j) {
                v0 = j;
                tangle[v0] = (float)((double)tangle[v0] + 3.141592653589793);
                if (!((double)tangle[j] >= 6.283185307179586)) continue;
                v1 = j;
                tangle[v1] = (float)((double)tangle[v1] - 6.283185307179586);
            }
        }
        for (Line c : cont) {
            if (c == null || c.getContourClass() == null) continue;
            c.setFrame(contours.getFrame());
            contours.add(c);
        }
        for (Object jun : junc) {
            if (jun == null || jun.cont1 == 0 && jun.cont2 == 0) continue;
            junctions.add(jun);
        }
        num_result.setValue(num_cont);
    }
}

