/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.view;

import java.util.List;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import sc.fiji.filamentdetector.event.TrackedFilamentSelectedEvent;
import sc.fiji.filamentdetector.gui.GUIUtils;
import sc.fiji.filamentdetector.gui.controller.DetailedTrackedFilamentController;
import sc.fiji.filamentdetector.gui.model.TrackedFilamentModel;
import sc.fiji.filamentdetector.model.TrackedFilament;
import sc.fiji.filamentdetector.model.TrackedFilaments;
import sc.fiji.filamentdetector.overlay.FilamentOverlayService;

public class TrackedFilamentsTableView
extends TableView<TrackedFilamentModel> {
    @Parameter
    FilamentOverlayService overlayService;
    @Parameter
    private LogService log;
    @Parameter
    private StatusService status;
    @Parameter
    private EventService eventService;
    private AnchorPane detailPane;
    private TrackedFilaments trackedFilaments;
    private Label nFilamentsField;
    private Pane infoPane;

    public TrackedFilamentsTableView(Context context, TrackedFilaments trackedFilaments) {
        context.inject((Object)this);
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        TableColumn idColumn = new TableColumn("ID");
        TableColumn sizeColumn = new TableColumn("Size");
        TableColumn colorColumn = new TableColumn("Color");
        this.getColumns().add((Object)idColumn);
        this.getColumns().add((Object)sizeColumn);
        this.getColumns().add((Object)colorColumn);
        idColumn.setStyle("-fx-alignment: CENTER;");
        sizeColumn.setStyle("-fx-alignment: CENTER;");
        colorColumn.setStyle("-fx-alignment: CENTER;");
        idColumn.setCellValueFactory(cellData -> ((TrackedFilamentModel)cellData.getValue()).getId().asObject());
        sizeColumn.setCellValueFactory(cellData -> ((TrackedFilamentModel)cellData.getValue()).getSize().asObject());
        colorColumn.setCellValueFactory(cellData -> ((TrackedFilamentModel)cellData.getValue()).getColor());
        colorColumn.setCellFactory(column -> new TableCell<TrackedFilamentModel, String>(){

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                    this.setStyle("-fx-background-color: none");
                } else {
                    this.setText(" ");
                    this.setStyle("-fx-background-color:" + item);
                }
            }
        });
        this.detailPane = new AnchorPane(new Node[]{this});
        AnchorPane.setTopAnchor((Node)this.detailPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.detailPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.detailPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.detailPane, (Double)0.0);
        this.detailPane.setPrefHeight(-1.0);
        this.detailPane.setPrefWidth(-1.0);
        this.setNoDetail();
        this.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            ObservableList trackedFilamentModels = this.getSelectionModel().getSelectedItems();
            if (trackedFilamentModels.size() == 1 && oldSelection != newSelection) {
                this.overlayService.setSelected(newSelection.getTrackedFilament(), true, true);
                DetailedTrackedFilamentController controller = new DetailedTrackedFilamentController(newSelection.getTrackedFilament());
                Pane pane = GUIUtils.loadFXML("/sc/fiji/filamentdetector/gui/view/tracking/DetailedTrackedFilamentView.fxml", controller);
                this.detailPane.getChildren().clear();
                this.detailPane.getChildren().add((Object)pane);
                AnchorPane.setTopAnchor((Node)pane, (Double)0.0);
                AnchorPane.setLeftAnchor((Node)pane, (Double)0.0);
                AnchorPane.setRightAnchor((Node)pane, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)pane, (Double)0.0);
                pane.setPrefHeight(-1.0);
                pane.setPrefWidth(-1.0);
                controller.getRemoveFilamentLabel().setOnAction(event -> this.removeTrackedFilament(controller.getTrackedFilament()));
            } else if (trackedFilamentModels.size() > 1) {
                this.setMultipleSelectionDetail();
            } else {
                this.setNoDetail();
            }
        });
        this.infoPane = new Pane();
        this.infoPane.setMinHeight(25.0);
        VBox vbox = new VBox();
        vbox.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        vbox.setSpacing(3.0);
        this.nFilamentsField = new Label("");
        vbox.getChildren().add((Object)this.nFilamentsField);
        this.infoPane.getChildren().add((Object)vbox);
        this.setTrackedFilaments(trackedFilaments);
        this.eventService.subscribe((Object)this);
    }

    public TrackedFilaments getTrackedFilaments() {
        return this.trackedFilaments;
    }

    public void setTrackedFilaments(TrackedFilaments trackedFilaments) {
        this.trackedFilaments = trackedFilaments;
        ObservableList trackedFilamentModelList = FXCollections.observableArrayList();
        for (TrackedFilament trackedFilament : trackedFilaments) {
            trackedFilamentModelList.add((Object)new TrackedFilamentModel(trackedFilament));
        }
        this.setItems(trackedFilamentModelList);
        this.overlayService.reset();
        this.overlayService.add(trackedFilaments);
        this.updateNFilamentsField();
    }

    public void addTrackedFilament(TrackedFilament trackedFilament) {
        this.getItems().add((Object)new TrackedFilamentModel(trackedFilament));
        this.trackedFilaments.add(trackedFilament);
        this.overlayService.add(trackedFilament);
        this.updateNFilamentsField();
    }

    public Pane getDetailPane() {
        return this.detailPane;
    }

    private void setNoDetail() {
        Label noDetail = new Label("No tracked filament selected.");
        this.detailPane.getChildren().clear();
        this.detailPane.getChildren().add((Object)noDetail);
    }

    private void setMultipleSelectionDetail() {
        ObservableList trackedFilamentModels = this.getSelectionModel().getSelectedItems();
        for (TrackedFilamentModel trackedFilamentModel : trackedFilamentModels) {
            this.overlayService.setSelected(trackedFilamentModel.getTrackedFilament(), true, false);
        }
        VBox vbox = new VBox();
        vbox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        vbox.setSpacing(10.0);
        Label label = new Label(trackedFilamentModels.size() + " tracked filaments selected.");
        Button button = new Button("Delete Tracked Filaments");
        button.setOnAction(event -> {
            this.removeTrackedFilaments((List<TrackedFilamentModel>)this.getSelectionModel().getSelectedItems());
            this.getSelectionModel().clearSelection();
        });
        vbox.getChildren().add((Object)label);
        vbox.getChildren().add((Object)button);
        this.detailPane.getChildren().clear();
        this.detailPane.getChildren().add((Object)vbox);
    }

    private void removeTrackedFilament(TrackedFilament trackedFilament) {
        TrackedFilamentModel trackedFilamentModel = this.getItems().stream().filter(f -> f.getTrackedFilament().equals(trackedFilament)).findFirst().orElse(null);
        this.removeTrackedFilament(trackedFilamentModel);
    }

    private void removeTrackedFilament(TrackedFilamentModel trackedFilamentModel) {
        this.getItems().remove((Object)trackedFilamentModel);
        this.trackedFilaments.remove(trackedFilamentModel.getTrackedFilament());
        this.overlayService.remove(trackedFilamentModel.getTrackedFilament());
        this.updateNFilamentsField();
    }

    private void removeTrackedFilaments(List<TrackedFilamentModel> trackedFilamentModels) {
        for (TrackedFilamentModel trackedFilamentModel : trackedFilamentModels) {
            this.overlayService.remove(trackedFilamentModel.getTrackedFilament());
            this.trackedFilaments.remove(trackedFilamentModel.getTrackedFilament());
        }
        this.getItems().removeAll(trackedFilamentModels);
        this.updateNFilamentsField();
    }

    @EventHandler
    public void filamentSelected(TrackedFilamentSelectedEvent event) {
        TrackedFilamentModel trackedFilamentModel = this.getItems().stream().filter(f -> f.getTrackedFilament().equals(event.getTrackedFilament())).findFirst().orElse(null);
        if (trackedFilamentModel != null) {
            Platform.runLater(() -> {
                this.getSelectionModel().clearSelection();
                this.getSelectionModel().select((Object)trackedFilamentModel);
            });
        }
    }

    public Pane getInfoPane() {
        return this.infoPane;
    }

    public void updateNFilamentsField() {
        if (this.trackedFilaments.size() == 0) {
            this.nFilamentsField.setText("");
        } else {
            this.nFilamentsField.setText(this.trackedFilaments.size() + " Tracked Filaments.");
        }
    }
}

