/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.analyzeSkeleton;

import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import sc.fiji.analyzeSkeleton.Edge;
import sc.fiji.analyzeSkeleton.Vertex;

public class Graph {
    private ArrayList<Edge> edges = new ArrayList();
    private ArrayList<Vertex> vertices = new ArrayList();
    private Vertex root = null;

    public boolean addEdge(Edge e) {
        if (this.edges.contains(e)) {
            return false;
        }
        e.getV1().setBranch(e);
        if (!e.getV1().equals(e.getV2())) {
            e.getV2().setBranch(e);
        }
        this.edges.add(e);
        return true;
    }

    public boolean addVertex(Vertex v) {
        if (this.vertices.contains(v)) {
            return false;
        }
        this.vertices.add(v);
        return true;
    }

    public ArrayList<Vertex> getVertices() {
        return this.vertices;
    }

    public ArrayList<Edge> getEdges() {
        return this.edges;
    }

    void setRoot(Vertex v) {
        this.root = v;
    }

    public Vertex getRoot() {
        return this.root;
    }

    ArrayList<Edge> depthFirstSearch() {
        ArrayList<Edge> backEdges = new ArrayList<Edge>();
        Stack<Vertex> stack = new Stack<Vertex>();
        for (Vertex v : this.vertices) {
            v.setVisited(false);
        }
        stack.push(this.root);
        int visitOrder = 0;
        while (!stack.empty()) {
            Vertex u = (Vertex)stack.pop();
            if (u.isVisited()) continue;
            if (u.getPredecessor() != null) {
                u.getPredecessor().setType(0);
            }
            u.setVisited(true, visitOrder++);
            for (Edge e : u.getBranches()) {
                if (e.getType() != -1) continue;
                Vertex ov = e.getOppositeVertex(u);
                if (!ov.isVisited()) {
                    stack.push(ov);
                    ov.setPredecessor(e);
                    continue;
                }
                e.setType(1);
                backEdges.add(e);
            }
        }
        return backEdges;
    }

    public Graph clone() {
        Graph clone = new Graph();
        Map vertexMap = this.vertices.stream().collect(Collectors.toMap(Function.identity(), Vertex::cloneUnconnected));
        Function<Edge, Edge> cloner = e -> e.clone((Vertex)vertexMap.get(e.getV1()), (Vertex)vertexMap.get(e.getV2()));
        Map edgeMap = this.edges.stream().collect(Collectors.toMap(Function.identity(), cloner));
        this.vertices.forEach(v -> ((Vertex)vertexMap.get(v)).setPredecessor((Edge)edgeMap.get(v.getPredecessor())));
        this.edges.stream().map(edgeMap::get).forEach(clone::addEdge);
        this.vertices.stream().map(vertexMap::get).forEach(clone::addVertex);
        clone.setRoot(vertexMap.get(this.root));
        return clone;
    }
}

