/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import math3d.Point3d;
import util.XMLFunctions;
import vib.FastMatrix;
import vib.transforms.OrderedTransformations;

public class NamedPointWorld {
    public double x;
    public double y;
    public double z;
    public boolean set;
    String name;

    public NamedPointWorld(String name, double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.name = name;
        this.set = true;
    }

    public NamedPointWorld(String name) {
        this.name = name;
        this.set = false;
    }

    public NamedPointWorld transformWith(FastMatrix m) {
        m.apply(this.x, this.y, this.z);
        return new NamedPointWorld(this.name, m.x, m.y, m.z);
    }

    public NamedPointWorld transformWith(OrderedTransformations o) {
        double[] result = new double[3];
        o.apply(this.x, this.y, this.z, result);
        return new NamedPointWorld(this.name, result[0], result[1], result[2]);
    }

    public static String escape(String s) {
        String result = s.replaceAll("\\\\", "\\\\\\\\");
        result = result.replaceAll("\\\"", "\\\\\"");
        return result;
    }

    public static String unescape(String s) {
        StringBuffer result = new StringBuffer(s);
        int startNextSearch = 0;
        int nextBackslash;
        while ((nextBackslash = result.indexOf(s, startNextSearch)) >= 0) {
            result.deleteCharAt(nextBackslash);
            startNextSearch = nextBackslash + 1;
        }
        return result.toString();
    }

    public Point3d toPoint3d() {
        return new Point3d(this.x, this.y, this.z);
    }

    public String getName() {
        return this.name;
    }

    public String toXMLElement() {
        StringBuffer result = new StringBuffer("<pointworld set=\"");
        result.append(this.set);
        result.append("\" name=\"");
        result.append(XMLFunctions.escapeForXMLAttributeValue(this.name));
        result.append("\"");
        if (this.set) {
            result.append(" x=\"");
            result.append(this.x);
            result.append("\" y=\"");
            result.append(this.y);
            result.append("\" z=\"");
            result.append(this.z);
            result.append("\"");
        }
        result.append("/>");
        return result.toString();
    }

    public String toYAML() {
        if (this.set) {
            return "\"" + NamedPointWorld.escape(this.name) + "\": [ " + this.x + ", " + this.y + ", " + this.z + " ]";
        }
        return "\"" + NamedPointWorld.escape(this.name) + "\":";
    }

    public String toString() {
        if (this.set) {
            return "\"" + this.name + "\" at " + this.x + ", " + this.y + ", " + this.z;
        }
        return "\"" + this.name + "\" [not set]";
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void unset() {
        this.set = false;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public void set(double x, double y, double z) {
        this.set = true;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public String toIGS() {
        return "landmark {\n\tname \"" + NamedPointWorld.escape(this.name) + "\"\n\tlocation " + this.x + " " + this.y + " " + this.z + "\n}";
    }
}

