/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.basictypeaccess.nio;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.imglib2.img.basictypeaccess.array.AbstractIntArray;
import net.imglib2.img.basictypeaccess.nio.AbstractBufferAccess;
import net.imglib2.img.basictypeaccess.volatiles.VolatileIntAccess;

public class IntBufferAccess
extends AbstractBufferAccess<IntBufferAccess, IntBuffer>
implements VolatileIntAccess {
    private static final long serialVersionUID = -7265085228179236189L;
    private static final int NUM_BYTES_PER_ENTITY = 4;

    public IntBufferAccess(IntBuffer buffer, boolean isValid) {
        super(buffer, isValid);
    }

    public IntBufferAccess(int numEntities, boolean isValid) {
        super(IntBuffer.allocate(numEntities), isValid);
    }

    public IntBufferAccess(ByteBuffer buffer, boolean isValid) {
        super(buffer.asIntBuffer(), isValid);
    }

    public IntBufferAccess(IntBuffer buffer) {
        this(buffer, true);
    }

    public IntBufferAccess(int numEntities) {
        this(numEntities, true);
    }

    public IntBufferAccess(ByteBuffer buffer) {
        this(buffer, true);
    }

    public IntBufferAccess() {
        this((IntBuffer)null, false);
    }

    @Override
    public int getValue(int index) {
        return ((IntBuffer)this.buffer).get(index);
    }

    @Override
    public void setValue(int index, int value) {
        ((IntBuffer)this.buffer).put(index, value);
    }

    @Override
    public int getNumBytesPerEntity() {
        return 4;
    }

    @Override
    public IntBufferAccess newInstance(ByteBuffer buffer, boolean isValid) {
        return IntBufferAccess.fromByteBuffer(buffer, isValid);
    }

    @Override
    public IntBufferAccess newInstance(IntBuffer buffer, boolean isValid) {
        return new IntBufferAccess(buffer, isValid);
    }

    @Override
    IntBuffer duplicateBuffer(IntBuffer buffer) {
        return buffer.duplicate();
    }

    @Override
    IntBufferAccess allocate(int numEntities, boolean isDirect, boolean isValid) {
        if (isDirect) {
            return (IntBufferAccess)super.allocate(numEntities, isDirect, isValid);
        }
        return new IntBufferAccess(numEntities, isValid);
    }

    public static IntBufferAccess fromByteBuffer(ByteBuffer buffer, boolean isValid) {
        return new IntBufferAccess(buffer, isValid);
    }

    public IntBuffer getValues(AbstractIntArray<?> array) {
        return ((IntBuffer)this.buffer).duplicate().get(array.getCurrentStorageArray());
    }

    public IntBuffer getValues(AbstractIntArray<?> array, int offset, int length) {
        return ((IntBuffer)this.buffer).duplicate().get(array.getCurrentStorageArray(), offset, length);
    }

    public IntBuffer setValues(AbstractIntArray<?> array) {
        return ((IntBuffer)this.buffer).duplicate().put(array.getCurrentStorageArray());
    }

    public IntBuffer setValues(AbstractIntArray<?> array, int offset, int length) {
        return ((IntBuffer)this.buffer).duplicate().put(array.getCurrentStorageArray(), offset, length);
    }

    public IntBuffer setValues(IntBufferAccess access) {
        return ((IntBuffer)this.buffer).duplicate().put((IntBuffer)access.getCurrentStorageArray());
    }
}

