/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.loops;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.IterableRealInterval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.img.array.AbstractArrayCursor;
import net.imglib2.img.cell.CellCursor;
import net.imglib2.img.planar.PlanarCursor;
import net.imglib2.loops.BindActionToSamplers;
import net.imglib2.loops.FastCursorLoops;
import net.imglib2.loops.IntervalChunks;
import net.imglib2.loops.ListUtils;
import net.imglib2.loops.LoopUtils;
import net.imglib2.loops.SyncedPositionables;
import net.imglib2.parallel.Parallelization;
import net.imglib2.parallel.TaskExecutor;
import net.imglib2.parallel.TaskExecutors;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import net.imglib2.view.iteration.SlicingCursor;

public class LoopBuilder<T> {
    private final Dimensions dimensions;
    private final RandomAccessibleInterval<?>[] images;
    private TaskExecutor taskExecutor = TaskExecutors.singleThreaded();
    private boolean useFlatIterationOrder = false;

    public static <A> LoopBuilder<Consumer<A>> setImages(RandomAccessibleInterval<A> a) {
        return new LoopBuilder<Consumer<A>>(a);
    }

    public static <A, B> LoopBuilder<BiConsumer<A, B>> setImages(RandomAccessibleInterval<A> a, RandomAccessibleInterval<B> b) {
        return new LoopBuilder<BiConsumer<A, B>>(a, b);
    }

    public static <A, B, C> LoopBuilder<TriConsumer<A, B, C>> setImages(RandomAccessibleInterval<A> a, RandomAccessibleInterval<B> b, RandomAccessibleInterval<C> c) {
        return new LoopBuilder<TriConsumer<A, B, C>>(a, b, c);
    }

    public static <A, B, C, D> LoopBuilder<FourConsumer<A, B, C, D>> setImages(RandomAccessibleInterval<A> a, RandomAccessibleInterval<B> b, RandomAccessibleInterval<C> c, RandomAccessibleInterval<D> d) {
        return new LoopBuilder<FourConsumer<A, B, C, D>>(a, b, c, d);
    }

    public static <A, B, C, D, E> LoopBuilder<FiveConsumer<A, B, C, D, E>> setImages(RandomAccessibleInterval<A> a, RandomAccessibleInterval<B> b, RandomAccessibleInterval<C> c, RandomAccessibleInterval<D> d, RandomAccessibleInterval<E> e) {
        return new LoopBuilder<FiveConsumer<A, B, C, D, E>>(a, b, c, d, e);
    }

    public static <A, B, C, D, E, F> LoopBuilder<SixConsumer<A, B, C, D, E, F>> setImages(RandomAccessibleInterval<A> a, RandomAccessibleInterval<B> b, RandomAccessibleInterval<C> c, RandomAccessibleInterval<D> d, RandomAccessibleInterval<E> e, RandomAccessibleInterval<F> f) {
        return new LoopBuilder<SixConsumer<A, B, C, D, E, F>>(a, b, c, d, e, f);
    }

    public void forEachPixel(T action) {
        Objects.requireNonNull(action);
        this.forEachChunk(chunk -> {
            chunk.forEachPixel(action);
            return null;
        });
    }

    public <R> List<R> forEachChunk(Function<Chunk<T>, R> action) {
        Objects.requireNonNull(action);
        if (Intervals.numElements(this.dimensions) == 0L) {
            return Collections.emptyList();
        }
        List<IterableInterval<?>> iterableIntervals = this.imagesAsIterableIntervals();
        if (this.allCursorsAreFast(iterableIntervals)) {
            return this.runUsingCursors(iterableIntervals, action);
        }
        return this.runUsingRandomAccesses(action);
    }

    private boolean allCursorsAreFast(List<IterableInterval<?>> iterableIntervals) {
        return ListUtils.allMatch(this::cursorIsFast, iterableIntervals);
    }

    private boolean cursorIsFast(IterableInterval<?> image) {
        RealCursor cursor = image.cursor();
        return cursor instanceof AbstractArrayCursor || cursor instanceof SlicingCursor || cursor instanceof PlanarCursor || cursor instanceof CellCursor;
    }

    public LoopBuilder<T> multiThreaded() {
        return this.multiThreaded(Parallelization.getTaskExecutor());
    }

    public LoopBuilder<T> multiThreaded(boolean multiThreaded) {
        return this.multiThreaded(multiThreaded ? Parallelization.getTaskExecutor() : TaskExecutors.singleThreaded());
    }

    public LoopBuilder<T> multiThreaded(TaskExecutor taskExecutor) {
        this.taskExecutor = Objects.requireNonNull(taskExecutor);
        return this;
    }

    public LoopBuilder<T> flatIterationOrder() {
        return this.flatIterationOrder(true);
    }

    public LoopBuilder<T> flatIterationOrder(boolean value) {
        this.useFlatIterationOrder = value;
        return this;
    }

    private LoopBuilder(RandomAccessibleInterval<?> ... images) {
        this.images = images;
        this.dimensions = new FinalInterval(images[0]);
        this.checkDimensions();
    }

    private void checkDimensions() {
        long[] dims = Intervals.dimensionsAsLongArray(this.dimensions);
        boolean equal = ListUtils.allMatch(image -> Arrays.equals(dims, Intervals.dimensionsAsLongArray(image)), this.images);
        if (!equal) {
            StringJoiner joiner = new StringJoiner(", ");
            for (RandomAccessibleInterval<?> interval : this.images) {
                joiner.add(Arrays.toString(Intervals.dimensionsAsLongArray(interval)));
            }
            throw new IllegalArgumentException("LoopBuilder, image dimensions do not match: " + joiner + ".");
        }
    }

    private <R> List<R> runUsingRandomAccesses(Function<Chunk<T>, R> chunkAction) {
        int nTasks = this.taskExecutor.suggestNumberOfTasks();
        FinalInterval interval = new FinalInterval(this.dimensions);
        List<Interval> chunks = IntervalChunks.chunkInterval(interval, nTasks);
        return this.taskExecutor.forEachApply(chunks, chunk -> LoopBuilder.runOnChunkUsingRandomAccesses(this.images, chunkAction, chunk));
    }

    static <T, R> R runOnChunkUsingRandomAccesses(RandomAccessibleInterval[] images, Function<Chunk<T>, R> chunkAction, Interval subInterval) {
        List<RandomAccess> samplers = ListUtils.map(LoopBuilder::initRandomAccess, images);
        Positionable synced = SyncedPositionables.create(samplers);
        if (!Views.isZeroMin(subInterval)) {
            synced.move(Intervals.minAsLongArray(subInterval));
        }
        return chunkAction.apply(pixelAction -> {
            Runnable runnable = BindActionToSamplers.bindActionToSamplers(pixelAction, samplers);
            LoopUtils.createIntervalLoop(synced, subInterval, runnable).run();
        });
    }

    private static RandomAccess<?> initRandomAccess(RandomAccessibleInterval<?> image) {
        RandomAccess ra = image.randomAccess();
        ra.setPosition(Intervals.minAsLongArray(image));
        return ra;
    }

    private List<IterableInterval<?>> imagesAsIterableIntervals() {
        return this.useFlatIterationOrder ? this.flatIterableIntervals() : this.equalIterationOrderIterableIntervals();
    }

    private <R> List<R> runUsingCursors(List<IterableInterval<?>> iterableIntervals, Function<Chunk<T>, R> chunkAction) {
        int nTasks = this.taskExecutor.suggestNumberOfTasks();
        FinalInterval indices = new FinalInterval(Intervals.numElements(this.images[0]));
        List<Interval> chunks = IntervalChunks.chunkInterval(indices, nTasks);
        return this.taskExecutor.forEachApply(chunks, chunk -> LoopBuilder.runOnChunkUsingCursors(iterableIntervals, chunkAction, chunk.min(0), chunk.dimension(0)));
    }

    static <T, R> R runOnChunkUsingCursors(List<IterableInterval<?>> iterableIntervals, Function<Chunk<T>, R> chunkAction, long offset, long numElements) {
        List<Cursor<?>> cursors = ListUtils.map(IterableInterval::cursor, iterableIntervals);
        if (offset != 0L) {
            LoopBuilder.jumpFwd(cursors, offset);
        }
        return chunkAction.apply(pixelAction -> {
            LongConsumer cursorLoop = FastCursorLoops.createLoop(pixelAction, cursors);
            cursorLoop.accept(numElements);
        });
    }

    private static void jumpFwd(List<Cursor<?>> cursors, long offset) {
        for (Cursor<?> cursor : cursors) {
            cursor.jumpFwd(offset);
        }
    }

    private List<IterableInterval<?>> equalIterationOrderIterableIntervals() {
        List<IterableInterval<?>> iterableIntervals = ListUtils.map(Views::iterable, this.images);
        List<Object> iterationOrders = ListUtils.map(IterableRealInterval::iterationOrder, iterableIntervals);
        if (LoopBuilder.allEqual(iterationOrders)) {
            return iterableIntervals;
        }
        return this.flatIterableIntervals();
    }

    private List<IterableInterval<?>> flatIterableIntervals() {
        return ListUtils.map(Views::flatIterable, this.images);
    }

    private static boolean allEqual(List<Object> values) {
        Object first = values.get(0);
        return ListUtils.allMatch(first::equals, values);
    }

    public static interface Chunk<T> {
        public void forEachPixel(T var1);
    }

    public static interface SixConsumer<A, B, C, D, E, F> {
        public void accept(A var1, B var2, C var3, D var4, E var5, F var6);
    }

    public static interface FiveConsumer<A, B, C, D, E> {
        public void accept(A var1, B var2, C var3, D var4, E var5);
    }

    public static interface FourConsumer<A, B, C, D> {
        public void accept(A var1, B var2, C var3, D var4);
    }

    public static interface TriConsumer<A, B, C> {
        public void accept(A var1, B var2, C var3);
    }
}

