/*
 * Decompiled with CFR 0.152.
 */
package mmorpho;

import ij.IJ;
import ij.process.ImageProcessor;
import mmorpho.Constants;
import mmorpho.LocalHistogram;
import mmorpho.StructureElement;

public class MorphoProcessor
implements Constants {
    private static final String version = "1.5";
    private StructureElement se;
    private StructureElement minus_se;
    private StructureElement plus_se;
    private LocalHistogram bh;
    private LocalHistogram p_h;
    private LocalHistogram m_h;
    private int[][] pg;
    private int[][] pg_plus;
    private int[][] pg_minus;
    int width;
    int height;
    private static final int ORIG = 0;
    private static final int PLUS = 1;
    private static final int MINUS = -1;
    public static final int BINF = -256;

    public MorphoProcessor(StructureElement se) {
        this.se = se;
        this.width = se.getWidth();
        this.height = se.getHeight();
        this.minus_se = new StructureElement(se.H(se.Delta(SGRAD), -1), this.width);
        this.plus_se = new StructureElement(se.H(se.Delta(NGRAD), -1), this.width);
        this.bh = new LocalHistogram();
        this.p_h = new LocalHistogram();
        this.m_h = new LocalHistogram();
        this.pg = se.getVect();
        this.pg_plus = this.plus_se.getVect();
        this.pg_minus = this.minus_se.getVect();
    }

    public StructureElement getSE(int options) {
        switch (options) {
            case 0: {
                return this.se;
            }
            case 1: {
                return this.plus_se;
            }
            case -1: {
                return this.minus_se;
            }
        }
        return this.se;
    }

    public void fastErode(ImageProcessor ip) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        int min = -32767;
        byte[] pixels = (byte[])ip.getPixels();
        byte[] newpix = new byte[pixels.length];
        int row = 0;
        int z = 0;
        int index = 0;
        for (row = 1; row <= height; ++row) {
            z = (row - 1) * width;
            this.bh.init(z, width, height, pixels, this.pg, 1);
            min = this.bh.getMinimum();
            newpix[z] = (byte)(min & 0xFF);
            for (int col = 1; col < width; ++col) {
                index = z + col;
                try {
                    this.p_h.init(index, width, height, pixels, this.pg_plus, 1);
                    this.m_h.init(index - 1, width, height, pixels, this.pg_minus, 1);
                    this.bh.sub(this.m_h);
                    this.bh.add(this.p_h);
                    this.bh.doMinimum();
                    min = this.bh.getMinimum();
                    newpix[index] = (byte)(min & 0xFF);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aiob) {
                    IJ.log((String)(" out index: " + index + " min " + min));
                }
            }
        }
        System.arraycopy(newpix, 0, pixels, 0, pixels.length);
    }

    public void fastDilate(ImageProcessor ip) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        int max = Short.MAX_VALUE;
        byte[] pixels = (byte[])ip.getPixels();
        byte[] newpix = new byte[pixels.length];
        int row = 0;
        int z = 0;
        int index = 0;
        for (row = 1; row <= height; ++row) {
            z = (row - 1) * width;
            this.bh.init(z, width, height, pixels, this.pg, 0);
            max = this.bh.getMaximum();
            newpix[z] = (byte)(max & 0xFF);
            for (int col = 1; col < width; ++col) {
                index = z + col;
                try {
                    this.p_h.init(index, width, height, pixels, this.pg_plus, 0);
                    this.m_h.init(index - 1, width, height, pixels, this.pg_minus, 0);
                    this.bh.sub(this.m_h);
                    this.bh.add(this.p_h);
                    this.bh.doMaximum();
                    max = this.bh.getMaximum();
                    newpix[index] = (byte)(max & 0xFF);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aiob) {
                    IJ.log((String)(" out index: " + index));
                }
            }
        }
        System.arraycopy(newpix, 0, pixels, 0, pixels.length);
    }

    public void erode(ImageProcessor ip) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        int min = -32767;
        int sz = this.pg.length;
        byte[] pixels = (byte[])ip.getPixels();
        int[] wnd = new int[sz];
        byte[] newpix = new byte[pixels.length];
        for (int c = 0; c < pixels.length; ++c) {
            wnd = this.getMinMax(c, width, height, pixels, this.pg, 32);
            min = wnd[0] + 255;
            newpix[c] = (byte)(min & 0xFF);
        }
        System.arraycopy(newpix, 0, pixels, 0, pixels.length);
    }

    public void dilate(ImageProcessor ip) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        int max = 32768;
        int sz = this.pg.length;
        byte[] pixels = (byte[])ip.getPixels();
        int[] wnd = new int[sz];
        byte[] newpix = new byte[pixels.length];
        for (int c = 0; c < pixels.length; ++c) {
            wnd = this.getMinMax(c, width, height, pixels, this.pg, 64);
            max = wnd[1] - 255;
            newpix[c] = (byte)(max & 0xFF);
        }
        System.arraycopy(newpix, 0, pixels, 0, pixels.length);
    }

    private int[] getMinMax(int index, int width, int height, byte[] pixels, int[][] pg, int type) {
        int pgzise = pg.length;
        int[] wnd = new int[2];
        int k = 0;
        int y = 0;
        int min = 255;
        int max = 0;
        int i = index / width;
        int j = index % width;
        for (int g = 0; g < pgzise; ++g) {
            y = i + pg[g][0];
            int x = j + pg[g][1];
            try {
                if (x >= width || y >= height || x < 0 || y < 0) {
                    if (type == 64) {
                        k = 0;
                    }
                    if (type == 32) {
                        k = 255;
                    }
                } else {
                    k = pixels[x + width * y] & 0xFF;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                k = x + width * y;
                IJ.log((String)("AIOB x: " + x + " y: " + y + " index: " + k));
            }
            if (type == 64) {
                k += pg[g][2];
            }
            if (type == 32) {
                k -= pg[g][2];
            }
            if (k < min) {
                min = k;
            }
            if (k <= max) continue;
            max = k;
        }
        wnd[0] = min & 0xFF;
        wnd[1] = max & 0xFF;
        return wnd;
    }

    private int[] getRanks(int index, int width, int height, byte[] pixels, int[][] pg, int type) {
        int pgzise = pg.length;
        int[] wnd = new int[pgzise];
        int k = 0;
        int y = 0;
        int i = index / width;
        int j = index % width;
        block2: for (int g = 0; g < pgzise; ++g) {
            y = i + pg[g][0];
            int x = j + pg[g][1];
            try {
                if (x >= width || y > height - 1 || x < 0 || y < 0) {
                    if (type == 64) {
                        k = 0;
                    }
                    if (type == 32) {
                        k = 255;
                    }
                } else {
                    k = pixels[x + width * y] & 0xFF;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                k = x + width * y;
                IJ.log((String)("AIOB x: " + x + " y: " + y + " index: " + k));
            }
            if (type == 32) {
                k -= pg[g][2];
                for (int v = 0; v <= g; ++v) {
                    if (k >= wnd[v]) {
                        continue;
                    }
                    wnd[v] = k;
                    ++v;
                    break;
                }
            }
            if (type != 64) continue;
            k += pg[g][2];
            for (int v = pgzise - 1; v >= g; --v) {
                if (k <= wnd[v]) {
                    continue;
                }
                wnd[v] = k;
                --v;
                continue block2;
            }
        }
        return wnd;
    }

    public void open(ImageProcessor ip) {
        int col;
        int row;
        int width = ip.getWidth();
        int height = ip.getHeight();
        int min = -32767;
        int max = 32768;
        int w = this.width;
        int h = this.height;
        int sz = this.pg.length;
        byte[] pixels = (byte[])ip.getPixels();
        byte[] newpix = new byte[pixels.length];
        byte[] newpix2 = new byte[pixels.length];
        int[] wnd = new int[sz];
        for (row = 1; row <= height; ++row) {
            for (col = 0; col < width; ++col) {
                int index2;
                int index = (row - 1) * width + col;
                if (index < pixels.length) {
                    wnd = this.getMinMax(index, width, height, pixels, this.pg, 32);
                    min = wnd[0] + 255;
                    newpix[index] = (byte)(min & 0xFF);
                }
                if ((index2 = (row - h - 1) * width + col - w) < 0 || index2 >= pixels.length) continue;
                wnd = this.getMinMax(index2, width, height, newpix, this.pg, 64);
                max = wnd[1] - 255;
                newpix2[index2] = (byte)(max & 0xFF);
            }
        }
        for (row = height; row <= height + h; ++row) {
            for (col = 0; col < width + w; ++col) {
                int index2 = (row - h - 1) * width + col - w;
                if (index2 < 0 || index2 >= pixels.length) continue;
                wnd = this.getMinMax(index2, width, height, newpix, this.pg, 64);
                max = wnd[1] - 255;
                newpix2[index2] = (byte)(max & 0xFF);
            }
        }
        System.arraycopy(newpix2, 0, pixels, 0, pixels.length);
    }

    public void fopen(ImageProcessor ip) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        int min = -32767;
        byte[] pixels = (byte[])ip.getPixels();
        byte[] newpix = new byte[pixels.length];
        int row = 0;
        int z = 0;
        int index = 0;
        for (row = 1; row <= height; ++row) {
            z = (row - 1) * width;
            this.bh.init(z, width, height, pixels, this.pg, 1);
            min = this.bh.getMinimum();
            newpix[z] = (byte)(min & 0xFF);
            for (int col = 1; col < width; ++col) {
                index = z + col;
                try {
                    this.p_h.init(index, width, height, pixels, this.pg_plus, 1);
                    this.m_h.init(index - 1, width, height, pixels, this.pg_minus, 1);
                    this.bh.sub(this.m_h);
                    this.bh.add(this.p_h);
                    this.bh.doMinimum();
                    min = this.bh.getMinimum();
                    newpix[index] = (byte)(min & 0xFF);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aiob) {
                    IJ.log((String)(" out index: " + index + " min " + min));
                }
            }
        }
        int max = Short.MAX_VALUE;
        byte[] newpix2 = new byte[pixels.length];
        for (row = 1; row <= height; ++row) {
            z = (row - 1) * width;
            this.bh.init(z, width, height, newpix, this.pg, 0);
            max = this.bh.getMaximum();
            newpix2[z] = (byte)(max & 0xFF);
            for (int col = 1; col < width; ++col) {
                index = z + col;
                try {
                    this.p_h.init(index, width, height, newpix, this.pg_plus, 0);
                    this.m_h.init(index - 1, width, height, newpix, this.pg_minus, 0);
                    this.bh.sub(this.m_h);
                    this.bh.add(this.p_h);
                    this.bh.doMaximum();
                    max = this.bh.getMaximum();
                    newpix2[index] = (byte)(max & 0xFF);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aiob) {
                    IJ.log((String)(" out index: " + index));
                }
            }
        }
        System.arraycopy(newpix2, 0, pixels, 0, pixels.length);
    }

    public void close(ImageProcessor ip) {
        int col;
        int row;
        int width = ip.getWidth();
        int height = ip.getHeight();
        int w = this.width;
        int h = this.height;
        int min = 0;
        int max = 255;
        int sz = this.pg.length;
        byte[] pixels = (byte[])ip.getPixels();
        byte[] newpix = new byte[pixels.length];
        byte[] newpix2 = new byte[pixels.length];
        int[] wnd = new int[sz];
        for (row = 1; row <= height; ++row) {
            for (col = 0; col < width; ++col) {
                int index2;
                int index = (row - 1) * width + col;
                if (index < pixels.length) {
                    wnd = this.getMinMax(index, width, height, pixels, this.pg, 64);
                    max = wnd[1] - 255;
                    newpix[index] = (byte)(max & 0xFF);
                }
                if ((index2 = (row - h - 1) * width + col - w) < 0 || index2 >= pixels.length) continue;
                wnd = this.getMinMax(index2, width, height, newpix, this.pg, 32);
                min = wnd[0] + 255;
                newpix2[index2] = (byte)(min & 0xFF);
            }
        }
        for (row = height; row <= height + h; ++row) {
            for (col = 0; col < width + w; ++col) {
                int index2 = (row - h - 1) * width + col - w;
                if (index2 < 0 || index2 >= pixels.length) continue;
                wnd = this.getMinMax(index2, width, height, newpix, this.pg, 32);
                min = wnd[0] + 255;
                newpix2[index2] = (byte)(min & 0xFF);
            }
        }
        System.arraycopy(newpix2, 0, pixels, 0, pixels.length);
    }

    public void fclose(ImageProcessor ip) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        int max = Short.MAX_VALUE;
        byte[] pixels = (byte[])ip.getPixels();
        byte[] newpix = new byte[pixels.length];
        int row = 0;
        int z = 0;
        int index = 0;
        for (row = 1; row <= height; ++row) {
            z = (row - 1) * width;
            this.bh.init(z, width, height, pixels, this.pg, 0);
            max = this.bh.getMaximum();
            newpix[z] = (byte)(max & 0xFF);
            for (int col = 1; col < width; ++col) {
                index = z + col;
                try {
                    this.p_h.init(index, width, height, pixels, this.pg_plus, 0);
                    this.m_h.init(index - 1, width, height, pixels, this.pg_minus, 0);
                    this.bh.sub(this.m_h);
                    this.bh.add(this.p_h);
                    this.bh.doMaximum();
                    max = this.bh.getMaximum();
                    newpix[index] = (byte)(max & 0xFF);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aiob) {
                    IJ.log((String)(" out index: " + index));
                }
            }
        }
        int min = -32767;
        byte[] newpix2 = new byte[pixels.length];
        for (row = 1; row <= height; ++row) {
            z = (row - 1) * width;
            this.bh.init(z, width, height, newpix, this.pg, 1);
            min = this.bh.getMinimum();
            newpix2[z] = (byte)(min & 0xFF);
            for (int col = 1; col < width; ++col) {
                index = z + col;
                try {
                    this.p_h.init(index, width, height, newpix, this.pg_plus, 1);
                    this.m_h.init(index - 1, width, height, newpix, this.pg_minus, 1);
                    this.bh.sub(this.m_h);
                    this.bh.add(this.p_h);
                    this.bh.doMinimum();
                    min = this.bh.getMinimum();
                    newpix2[index] = (byte)(min & 0xFF);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aiob) {
                    IJ.log((String)(" out index: " + index + " min " + min));
                }
            }
        }
        System.arraycopy(newpix2, 0, pixels, 0, pixels.length);
    }

    public void LineErode(ImageProcessor ip) {
        int j;
        int j2;
        int i;
        int k;
        int width = ip.getWidth();
        int height = ip.getHeight();
        int min = -32767;
        int w = Math.max(this.width, this.height);
        int shift = this.se.getShift();
        int p = w - 2 * shift;
        int[] wnd = new int[2 * p];
        int[] R = new int[p];
        int[] S = new int[p];
        int type = this.se.getType();
        byte[] pixels = (byte[])ip.getPixels();
        byte[] newpix = new byte[pixels.length];
        int z = 0;
        int index = 0;
        if (type == 4) {
            for (int row = 0; row < height; ++row) {
                z = row * width;
                for (int col = 0; col <= width + p; col += p) {
                    k = 0;
                    for (i = -p; i < p; ++i) {
                        int x = col + i;
                        index = z + x;
                        try {
                            k = x > width || x < 0 || index >= width * height ? 255 : pixels[index] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            IJ.log((String)("AIOB row: " + row + " col: " + col + " index: " + index + "x: " + x));
                        }
                        wnd[i + p] = k;
                    }
                    R[0] = wnd[p];
                    S[0] = wnd[p];
                    for (j2 = 1; j2 < p; ++j2) {
                        R[j2] = Math.min(R[j2 - 1], wnd[p - j2]);
                        S[j2] = Math.min(S[j2 - 1], wnd[j2 + p]);
                    }
                    int offset = 0;
                    for (j = 0; j < p; ++j) {
                        try {
                            min = Math.min(R[j], S[p - j - 1]);
                            offset = -j + p / 2;
                            if (col + offset < 0 || col + offset >= width) continue;
                            newpix[z + col + offset] = (byte)(min & 0xFF);
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException aiob) {
                            IJ.log((String)("row: " + row + " col: " + col + " off: " + offset));
                        }
                    }
                }
            }
        }
        if (type == 3) {
            for (int col = 0; col < width; ++col) {
                for (int row = 0; row < height + p; row += p) {
                    k = 0;
                    for (i = -p; i < p; ++i) {
                        int y = row + i;
                        index = col + y * width;
                        try {
                            k = y > height || y < 0 || index > width * height - 1 ? 255 : pixels[index] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            IJ.log((String)("AIOB row: " + row + " col: " + col + " index: " + index + "y: " + y));
                        }
                        wnd[i + p] = k;
                    }
                    R[0] = wnd[p];
                    S[0] = wnd[p];
                    for (j2 = 1; j2 < p; ++j2) {
                        R[j2] = Math.min(R[j2 - 1], wnd[p - j2]);
                        S[j2] = Math.min(S[j2 - 1], wnd[j2 + p]);
                    }
                    int y = 0;
                    for (j = 0; j < p; ++j) {
                        try {
                            min = Math.min(R[j], S[p - j - 1]);
                            y = p / 2 - j;
                            if (row + y < 0 || col + (row + y) * width >= height * width) continue;
                            newpix[col + (row + y) * width] = (byte)(min & 0xFF);
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException aiob) {
                            IJ.log((String)("row: " + row + " col: " + col + " off: " + y));
                        }
                    }
                }
            }
        }
        System.arraycopy(newpix, 0, pixels, 0, pixels.length);
    }

    public void LineDilate(ImageProcessor ip) {
        int j;
        int j2;
        int i;
        int k;
        int width = ip.getWidth();
        int height = ip.getHeight();
        int min = -32767;
        int w = Math.max(this.width, this.height);
        int shift = this.se.getShift();
        int p = w - 2 * shift;
        int[] wnd = new int[2 * p];
        int[] R = new int[p];
        int[] S = new int[p];
        int type = this.se.getType();
        byte[] pixels = (byte[])ip.getPixels();
        byte[] newpix = new byte[pixels.length];
        int z = 0;
        int index = 0;
        if (type == 4) {
            for (int row = 0; row < height; ++row) {
                z = row * width;
                for (int col = 0; col <= width + p; col += p) {
                    k = 0;
                    for (i = -p; i < p; ++i) {
                        int x = col + i;
                        index = z + x;
                        try {
                            k = x > width || x < 0 || index >= width * height ? 0 : pixels[index] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            IJ.log((String)("AIOB row: " + row + " col: " + col + " index: " + index + "x: " + x));
                        }
                        wnd[i + p] = k;
                    }
                    R[0] = wnd[p];
                    S[0] = wnd[p];
                    for (j2 = 1; j2 < p; ++j2) {
                        R[j2] = Math.max(R[j2 - 1], wnd[p - j2]);
                        S[j2] = Math.max(S[j2 - 1], wnd[j2 + p]);
                    }
                    int offset = 0;
                    for (j = 0; j < p; ++j) {
                        try {
                            min = Math.max(R[j], S[p - j - 1]);
                            offset = -j + p / 2;
                            if (col + offset < 0 || col + offset >= width) continue;
                            newpix[z + col + offset] = (byte)(min & 0xFF);
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException aiob) {
                            IJ.log((String)("row: " + row + " col: " + col + " off: " + offset));
                        }
                    }
                }
            }
        }
        if (type == 3) {
            for (int col = 0; col < width; ++col) {
                for (int row = 0; row < height + p; row += p) {
                    k = 0;
                    for (i = -p; i < p; ++i) {
                        int y = row + i;
                        index = col + y * width;
                        try {
                            k = y > height || y < 0 || index > width * height - 1 ? 0 : pixels[index] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            IJ.log((String)("AIOB row: " + row + " col: " + col + " index: " + index + "y: " + y));
                        }
                        wnd[i + p] = k;
                    }
                    R[0] = wnd[p];
                    S[0] = wnd[p];
                    for (j2 = 1; j2 < p; ++j2) {
                        R[j2] = Math.max(R[j2 - 1], wnd[p - j2]);
                        S[j2] = Math.max(S[j2 - 1], wnd[j2 + p]);
                    }
                    int y = 0;
                    for (j = 0; j < p; ++j) {
                        try {
                            min = Math.max(R[j], S[p - j - 1]);
                            y = p / 2 - j;
                            if (row + y < 0 || col + (row + y) * width >= height * width) continue;
                            newpix[col + (row + y) * width] = (byte)(min & 0xFF);
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException aiob) {
                            IJ.log((String)("row: " + row + " col: " + col + " off: " + y));
                        }
                    }
                }
            }
        }
        System.arraycopy(newpix, 0, pixels, 0, pixels.length);
    }

    private void Log(int[][] a) {
        String aStr = "";
        int h = a.length;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                aStr = aStr + a[i][j] + "  ";
            }
            IJ.log((String)aStr);
            aStr = "";
        }
    }
}

