/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.awt;

import edu.mines.jtk.awt.ColorMap;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.FloatByteMap;
import java.awt.image.IndexColorModel;

public class FloatColorMap
extends ColorMap {
    private FloatByteMap _fbmic;
    private FloatByteMap _fbmi0;
    private FloatByteMap _fbmi1;
    private FloatByteMap _fbmi2;
    private FloatByteMap _fbmi3;
    private boolean _hsb;
    private float _hue000;
    private float _hue255;

    public FloatColorMap(float[][] f, IndexColorModel icm) {
        this(new float[][][]{f}, 0, icm);
    }

    public FloatColorMap(float[][][] f, int ic, IndexColorModel icm) {
        super(icm);
        Check.argument(f.length == 1 || f.length == 3 || f.length == 4, "number of arrays (color components) equals 1, 3, or 4");
        int nc = f.length;
        FloatByteMap[] fbm = new FloatByteMap[nc];
        for (int jc = 0; jc < nc; ++jc) {
            fbm[jc] = new FloatByteMap(f[jc]);
        }
        this._fbmi0 = fbm[0];
        this._fbmi1 = nc > 1 ? fbm[1] : fbm[0];
        this._fbmi2 = nc > 1 ? fbm[2] : fbm[0];
        this._fbmi3 = nc > 3 ? fbm[3] : null;
        this._fbmic = fbm[ic];
    }

    public void setHSB(boolean hsb) {
        this._hsb = hsb;
    }

    public void setHues(double hue000, double hue255) {
        this._hue000 = (float)hue000;
        this._hue255 = (float)hue255;
    }

    public int getIndex(float f) {
        return this._fbmic.getByte(f);
    }

    public int getARGB(float f) {
        return this.getColorModel().getRGB(this.getIndex(f));
    }

    public int getRGB(float f0, float f1, float f2) {
        int i0 = this._fbmi0.getByte(f0);
        int i1 = this._fbmi1.getByte(f1);
        int i2 = this._fbmi2.getByte(f2);
        return this._hsb ? this.rgbFromHsb(i0, i1, i2) : this.rgbFromRgb(i0, i1, i2);
    }

    public int getARGB(float f0, float f1, float f2, float f3) {
        int i0 = this._fbmi0.getByte(f0);
        int i1 = this._fbmi1.getByte(f1);
        int i2 = this._fbmi2.getByte(f2);
        int i3 = this._fbmi3 != null ? this._fbmi3.getByte(f3) : 255;
        return this._hsb ? this.argbFromHsba(i0, i1, i2, i3) : this.argbFromRgba(i0, i1, i2, i3);
    }

    @Override
    public int getIndex(double v) {
        return this.getIndex((float)v);
    }

    @Override
    public double getMinValue() {
        return this._fbmic.getClipMin();
    }

    @Override
    public double getMaxValue() {
        return this._fbmic.getClipMax();
    }

    @Override
    public void setValueRange(double vmin, double vmax) {
        if ((double)((float)vmin) != this.getMinValue() || (double)((float)vmax) != this.getMaxValue()) {
            this._fbmic.setClips((float)vmin, (float)vmax);
            super.setValueRange(vmin, vmax);
        }
    }

    private int argbFromRgba(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    private int rgbFromRgb(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private int argbFromHsba(int hu, int sa, int br, int al) {
        return al << 24 | this.rgbFromHsb(hu, sa, br);
    }

    private int rgbFromHsb(int hu, int sa, int br) {
        float scale = 0.003921569f;
        if (hu < 0) {
            hu += 256;
        }
        if (sa < 0) {
            sa += 256;
        }
        if (br < 0) {
            br += 256;
        }
        float hue = this._hue000 + (this._hue255 - this._hue000) * (float)hu * scale;
        float sat = (float)sa * scale;
        float bri = (float)br * scale;
        int r = 0;
        int g = 0;
        int b = 0;
        if (sat == 0.0f) {
            g = b = (int)(bri * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = bri * (1.0f - sat);
            float q = bri * (1.0f - sat * f);
            float t = bri * (1.0f - sat * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(bri * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(bri * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(bri * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(bri * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(bri * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(bri * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return this.rgbFromRgb(r, g, b);
    }
}

