/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mesh;

import edu.mines.jtk.mesh.Geometry;
import edu.mines.jtk.mesh.TetMesh;
import edu.mines.jtk.util.Check;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class TriSurf {
    private static final int FACE_MARK_MAX = 0x7FFFFFFE;
    private TetMesh _mesh = new TetMesh();
    private Set<TetMesh.Face> _faceSet = new HashSet<TetMesh.Face>();
    private Map<TetMesh.Face, Face> _faceMap = new HashMap<TetMesh.Face, Face>();
    private Map<TetMesh.Edge, EdgeFace> _edgeMap = new HashMap<TetMesh.Edge, EdgeFace>();
    private SortedSet<EdgeFace> _edgeQueue = new TreeSet<EdgeFace>();
    private int _faceMarkRed;
    private int _faceMarkBlue;
    private static final double VV_SLIVER = Math.cos(2.6179938779914944);
    private static final double VV_LARGE = Math.cos(1.7278759594743864);
    private static final boolean TRACE = false;

    public synchronized boolean addNode(Node node) {
        boolean added = this._mesh.addNode(node._meshNode);
        if (added) {
            this.rebuild();
        }
        return added;
    }

    public synchronized boolean addNodes(Node[] nodes) {
        int nnode = nodes.length;
        int nadded = 0;
        for (int inode = 0; inode < nnode; ++inode) {
            if (!this._mesh.addNode(nodes[inode]._meshNode)) continue;
            ++nadded;
        }
        if (nadded > 0) {
            this.rebuild();
        }
        return nadded == nnode;
    }

    public synchronized boolean removeNode(Node node) {
        boolean removed = this._mesh.removeNode(node._meshNode);
        if (removed) {
            this.rebuild();
        }
        return removed;
    }

    public synchronized boolean removeNodes(Node[] nodes) {
        int nnode = nodes.length;
        int nremoved = 0;
        for (int inode = 0; inode < nnode; ++inode) {
            if (!this._mesh.removeNode(nodes[inode]._meshNode)) continue;
            ++nremoved;
        }
        if (nremoved > 0) {
            this.rebuild();
        }
        return nremoved == nnode;
    }

    public int countNodes() {
        return this._mesh.countNodes();
    }

    public int countFaces() {
        return this._faceMap.size();
    }

    public synchronized NodeIterator getNodes() {
        return new NodeIterator(){
            private TetMesh.NodeIterator _i;
            {
                this._i = TriSurf.this._mesh.getNodes();
            }

            @Override
            public final boolean hasNext() {
                return this._i.hasNext();
            }

            @Override
            public final Node next() {
                return (Node)this._i.next().data;
            }
        };
    }

    public synchronized FaceIterator getFaces() {
        return new FaceIterator(){
            private Iterator<Face> _i;
            {
                this._i = TriSurf.this._faceMap.values().iterator();
            }

            @Override
            public final boolean hasNext() {
                return this._i.hasNext();
            }

            @Override
            public final Face next() {
                return this._i.next();
            }
        };
    }

    public synchronized Node findNodeNearest(float x, float y, float z) {
        TetMesh.Node meshNode = this._mesh.findNodeNearest(x, y, z);
        return (Node)meshNode.data;
    }

    public synchronized Face[] getFaceNabors(Node node) {
        FaceList nabors = new FaceList();
        this.getFaceNabors(node, nabors);
        return nabors.trim();
    }

    public synchronized void getFaceNabors(Node node, FaceList nabors) {
        this.clearFaceMarks();
        this.getFaceNabors(node, node._face, nabors);
    }

    public Face findFace(Node node) {
        return node._face;
    }

    public synchronized Face findFace(Node node1, Node node2) {
        Face face = this.findFace(node1);
        if (face != null) {
            if (face.references(node2)) {
                return face;
            }
            Face face1 = face;
            face = node1.faceNext(face1);
            while (face != face1 && face != null) {
                if (face.references(node2)) {
                    return face;
                }
                face = node1.faceNext(face);
            }
            if (face == null) {
                face = node1.facePrev(face1);
                while (face != face1 && face != null) {
                    if (face.references(node2)) {
                        return face;
                    }
                    face = node1.facePrev(face);
                }
            }
        }
        return null;
    }

    public synchronized Face findFace(Node node1, Node node2, Node node3) {
        Face face = this.findFace(node1, node2);
        if (face != null) {
            if (face.references(node3)) {
                return face;
            }
            if ((face = face.faceNabor(node3)) != null && face.references(node3)) {
                return face;
            }
        }
        return null;
    }

    public synchronized Edge findEdge(Node nodeA, Node nodeB) {
        Node nodeC;
        Face face;
        TetMesh.Edge meshEdge = this.findMeshEdge(nodeA, nodeB);
        Edge edge = this.getEdge(meshEdge);
        if (meshEdge != null && edge == null && (face = this.findFace(nodeA, nodeB)) != null && TriSurf.nodesInOrder(face, nodeA, nodeB, nodeC = TriSurf.otherNode(face, nodeA, nodeB))) {
            edge = new Edge(meshEdge, face);
        }
        return edge;
    }

    private void validate() {
        NodeIterator ni = this.getNodes();
        while (ni.hasNext()) {
            Node node = ni.next();
            node.validate();
        }
        FaceIterator fi = this.getFaces();
        while (fi.hasNext()) {
            Face face = fi.next();
            face.validate();
        }
    }

    private static double distanceSquared(Node node, double x, double y, double z) {
        double dx = x - (double)node.x();
        double dy = y - (double)node.y();
        double dz = z - (double)node.z();
        return dx * dx + dy * dy + dz * dz;
    }

    private Face findFace(Face face, Node n1, Node n2) {
        if (face != null) {
            this.mark(face);
            Node na = face.nodeA();
            Node nb = face.nodeB();
            Node nc = face.nodeC();
            Face fa = face.faceA();
            Face fb = face.faceB();
            Face fc = face.faceC();
            if (n1 == na) {
                if (n2 == nb || n2 == nc || fb != null && !this.isMarked(fb) && (face = this.findFace(fb, n1, n2)) != null || fc != null && !this.isMarked(fc) && (face = this.findFace(fc, n1, n2)) != null) {
                    return face;
                }
            } else if (n1 == nb) {
                if (n2 == nc || n2 == na || fc != null && !this.isMarked(fc) && (face = this.findFace(fc, n1, n2)) != null || fa != null && !this.isMarked(fa) && (face = this.findFace(fa, n1, n2)) != null) {
                    return face;
                }
            } else if (n1 == nc) {
                if (n2 == na || n2 == nb || fa != null && !this.isMarked(fa) && (face = this.findFace(fa, n1, n2)) != null || fb != null && !this.isMarked(fb) && (face = this.findFace(fb, n1, n2)) != null) {
                    return face;
                }
            } else assert (false) : "n1 is referenced by face";
        }
        return null;
    }

    private Face findFace(Face face, Node n1, Node n2, Node n3) {
        if (face != null) {
            this.mark(face);
            Node na = face.nodeA();
            Node nb = face.nodeB();
            Node nc = face.nodeC();
            Face fa = face.faceA();
            Face fb = face.faceB();
            Face fc = face.faceC();
            if (n1 == na) {
                if (n2 == nb) {
                    if (n3 == nc || fc != null && !this.isMarked(fc) && (face = this.findFace(fc, n1, n2, n3)) != null) {
                        return face;
                    }
                } else if (n2 == nc) {
                    if (n3 == nb || fb != null && !this.isMarked(fb) && (face = this.findFace(fb, n1, n2, n3)) != null) {
                        return face;
                    }
                } else assert (false) : "n2 is referenced by face";
            } else if (n1 == nb) {
                if (n2 == na) {
                    if (n3 == nc || fc != null && !this.isMarked(fc) && (face = this.findFace(fc, n1, n2, n3)) != null) {
                        return face;
                    }
                } else if (n2 == nc) {
                    if (n3 == na || fa != null && !this.isMarked(fa) && (face = this.findFace(fa, n1, n2, n3)) != null) {
                        return face;
                    }
                } else assert (false) : "n2 is referenced by face";
            } else if (n1 == nc) {
                if (n2 == na) {
                    if (n3 == nb || fb != null && !this.isMarked(fb) && (face = this.findFace(fb, n1, n2, n3)) != null) {
                        return face;
                    }
                } else if (n2 == nb) {
                    if (n3 == na || fa != null && !this.isMarked(fa) && (face = this.findFace(fa, n1, n2, n3)) != null) {
                        return face;
                    }
                } else assert (false) : "n2 is referenced by face";
            } else assert (false) : "n1 is referenced by face";
        }
        return null;
    }

    private void mark(Face face) {
        face._mark = this._faceMarkRed;
    }

    private void markRed(Face face) {
        face._mark = this._faceMarkRed;
    }

    private void markBlue(Face face) {
        face._mark = this._faceMarkBlue;
    }

    private boolean isMarked(Face face) {
        return face._mark == this._faceMarkRed;
    }

    private boolean isMarkedRed(Face face) {
        return face._mark == this._faceMarkRed;
    }

    private boolean isMarkedBlue(Face face) {
        return face._mark == this._faceMarkBlue;
    }

    private synchronized void clearFaceMarks() {
        if (this._faceMarkRed == 0x7FFFFFFE) {
            for (Face face : this._faceMap.values()) {
                face._mark = 0;
            }
            this._faceMarkRed = 0;
            this._faceMarkBlue = 0;
        }
        ++this._faceMarkRed;
        --this._faceMarkBlue;
    }

    private void getFaceNabors(Node node, Face face, FaceList nabors) {
        if (face != null) {
            this.mark(face);
            nabors.add(face);
            Node na = face.nodeA();
            Node nb = face.nodeB();
            Node nc = face.nodeC();
            Face fa = face.faceA();
            Face fb = face.faceB();
            Face fc = face.faceC();
            if (node == na) {
                if (fb != null && !this.isMarked(fb)) {
                    this.getFaceNabors(node, fb, nabors);
                }
                if (fc != null && !this.isMarked(fc)) {
                    this.getFaceNabors(node, fc, nabors);
                }
            } else if (node == nb) {
                if (fc != null && !this.isMarked(fc)) {
                    this.getFaceNabors(node, fc, nabors);
                }
                if (fa != null && !this.isMarked(fa)) {
                    this.getFaceNabors(node, fa, nabors);
                }
            } else if (node == nc) {
                if (fa != null && !this.isMarked(fa)) {
                    this.getFaceNabors(node, fa, nabors);
                }
                if (fb != null && !this.isMarked(fb)) {
                    this.getFaceNabors(node, fb, nabors);
                }
            } else assert (false) : "node is referenced by face";
        }
    }

    private Edge getEdge(TetMesh.Edge meshEdge) {
        EdgeFace edgeFace = this._edgeMap.get(meshEdge);
        return edgeFace != null ? edgeFace.edge : null;
    }

    private EdgeFace getEdgeFace(Edge edge) {
        return this._edgeMap.get(edge._meshEdge);
    }

    private EdgeFace getBestEdgeFace() {
        return !this._edgeQueue.isEmpty() ? this._edgeQueue.last() : null;
    }

    private EdgeFace getNextEdgeFace(EdgeFace edgeFace) {
        SortedSet<EdgeFace> headSet = this._edgeQueue.headSet(edgeFace);
        return !headSet.isEmpty() ? headSet.last() : null;
    }

    private EdgeFace addEdge(Edge edge) {
        EdgeFace edgeFace = this.makeEdgeFace(edge);
        assert (edgeFace != null) : "edgeFace!=null";
        EdgeFace edgeFaceOld = this._edgeMap.put(edge._meshEdge, edgeFace);
        assert (edgeFaceOld == null) : "edge was not mapped";
        boolean added = this._edgeQueue.add(edgeFace);
        assert (added) : "edgeFace was not in queue";
        return edgeFace;
    }

    private void removeEdge(Edge edge) {
        EdgeFace edgeFace = this.getEdgeFace(edge);
        assert (edgeFace != null) : "edgeFace!=null";
        EdgeFace edgeFaceOld = this._edgeMap.remove(edge._meshEdge);
        assert (edgeFaceOld != null) : "edge was mapped";
        boolean removed = this._edgeQueue.remove(edgeFace);
        assert (removed) : "edgeFace was in queue";
    }

    private void addFace(Face face) {
        boolean removed;
        boolean bl = removed = this._faceSet.remove(face._meshFace) || this._faceSet.remove(face._meshFace.mate());
        assert (removed) : "face not already in surface";
        Face faceOld = this._faceMap.put(face._meshFace, face);
        assert (faceOld == null) : "face not already in surface";
    }

    private void removeFace(Face face) {
        this._faceMap.remove(face._meshFace);
    }

    private void init(Face face) {
        TriSurf.trace("init: face=" + face);
        TriSurf.trace("  meshFace A=" + face._meshFace.nodeA());
        TriSurf.trace("  meshFace B=" + face._meshFace.nodeB());
        TriSurf.trace("  meshFace C=" + face._meshFace.nodeC());
        face._faceA = null;
        face._faceB = null;
        face._faceC = null;
        Node nodeA = face.nodeA();
        Node nodeB = face.nodeB();
        Node nodeC = face.nodeC();
        nodeA.setFace(face);
        nodeB.setFace(face);
        nodeC.setFace(face);
        Edge edgeCB = this.makeEdge(nodeC, nodeB, face);
        Edge edgeBA = this.makeEdge(nodeB, nodeA, face);
        Edge edgeAC = this.makeEdge(nodeA, nodeC, face);
        nodeA.setEdgeBefore(edgeBA);
        nodeB.setEdgeBefore(edgeCB);
        nodeC.setEdgeBefore(edgeAC);
        nodeA.setEdgeAfter(edgeAC);
        nodeB.setEdgeAfter(edgeBA);
        nodeC.setEdgeAfter(edgeCB);
        this.addEdge(edgeCB);
        this.addEdge(edgeBA);
        this.addEdge(edgeAC);
        this.addFace(face);
    }

    private void extend(Edge edge, Face face) {
        TriSurf.trace("extend: edge=" + edge + " face=" + face);
        TriSurf.trace("  meshEdge A=" + edge._meshEdge.nodeA());
        TriSurf.trace("  meshEdge B=" + edge._meshEdge.nodeB());
        TriSurf.trace("  meshFace A=" + face._meshFace.nodeA());
        TriSurf.trace("  meshFace B=" + face._meshFace.nodeB());
        TriSurf.trace("  meshFace C=" + face._meshFace.nodeC());
        assert (edge.isOnBoundary());
        Node nodeA = edge.nodeA();
        Node nodeB = edge.nodeB();
        Node nodeC = TriSurf.otherNode(face, nodeA, nodeB);
        nodeC.setFace(face);
        TriSurf.linkFaces(face, nodeC, edge.faceRight(), edge.nodeRight());
        Edge edgeAC = this.makeEdge(nodeA, nodeC, face);
        Edge edgeCB = this.makeEdge(nodeC, nodeB, face);
        nodeA.setEdgeAfter(edgeAC);
        nodeB.setEdgeBefore(edgeCB);
        nodeC.setEdgeAfter(edgeCB);
        nodeC.setEdgeBefore(edgeAC);
        this.removeEdge(edge);
        this.addFace(face);
        this.addEdge(edgeAC);
        this.addEdge(edgeCB);
    }

    private void fillEar(Edge edge, Face face) {
        TriSurf.trace("fillEar: edge=" + edge + " face=" + face);
        TriSurf.trace("  meshEdge A=" + edge._meshEdge.nodeA());
        TriSurf.trace("  meshEdge B=" + edge._meshEdge.nodeB());
        TriSurf.trace("  meshFace A=" + face._meshFace.nodeA());
        TriSurf.trace("  meshFace B=" + face._meshFace.nodeB());
        TriSurf.trace("  meshFace C=" + face._meshFace.nodeC());
        Node nodeA = edge.nodeA();
        Node nodeB = edge.nodeB();
        Node nodeC = TriSurf.otherNode(face, nodeA, nodeB);
        Edge edge1 = nodeC.edgeBefore();
        Edge edge2 = nodeC.edgeAfter();
        Node node1 = edge1.nodeA();
        Node node2 = edge2.nodeB();
        if (node2 == nodeA) {
            TriSurf.linkFaces(face, nodeC, edge.faceRight(), edge.nodeRight());
            TriSurf.linkFaces(face, nodeB, edge2.faceRight(), edge2.nodeRight());
            Edge edgeCB = this.makeEdge(nodeC, nodeB, face);
            nodeC.setEdgeAfter(edgeCB);
            nodeB.setEdgeBefore(edgeCB);
            nodeA.setEdgeAfter(null);
            nodeA.setEdgeBefore(null);
            this.removeEdge(edge);
            this.removeEdge(edge2);
            this.addFace(face);
            this.addEdge(edgeCB);
        } else if (node1 == nodeB) {
            TriSurf.linkFaces(face, nodeC, edge.faceRight(), edge.nodeRight());
            TriSurf.linkFaces(face, nodeA, edge1.faceRight(), edge1.nodeRight());
            Edge edgeAC = this.makeEdge(nodeA, nodeC, face);
            nodeA.setEdgeAfter(edgeAC);
            nodeC.setEdgeBefore(edgeAC);
            nodeB.setEdgeAfter(null);
            nodeB.setEdgeBefore(null);
            this.removeEdge(edge);
            this.removeEdge(edge1);
            this.addFace(face);
            this.addEdge(edgeAC);
        } else assert (false) : "ear is valid";
    }

    private void fillHole(Edge edge, Face face) {
        TriSurf.trace("fillHole: edge=" + edge + " face=" + face);
        TriSurf.trace("  meshEdge A=" + edge._meshEdge.nodeA());
        TriSurf.trace("  meshEdge B=" + edge._meshEdge.nodeB());
        TriSurf.trace("  meshFace A=" + face._meshFace.nodeA());
        TriSurf.trace("  meshFace B=" + face._meshFace.nodeB());
        TriSurf.trace("  meshFace C=" + face._meshFace.nodeC());
        Edge edgeAB = edge;
        Edge edgeBC = edge.edgeAfter();
        Edge edgeCA = edge.edgeBefore();
        assert (edgeAB.isOnBoundary());
        assert (edgeBC.isOnBoundary());
        assert (edgeCA.isOnBoundary());
        Face faceAB = edgeAB.faceRight();
        Face faceBC = edgeBC.faceRight();
        Face faceCA = edgeCA.faceRight();
        Node nodeA = edgeAB.nodeA();
        Node nodeB = edgeBC.nodeA();
        Node nodeC = edgeCA.nodeA();
        TriSurf.linkFaces(face, nodeA, faceBC, TriSurf.otherNode(faceBC, nodeB, nodeC));
        TriSurf.linkFaces(face, nodeB, faceCA, TriSurf.otherNode(faceCA, nodeA, nodeC));
        TriSurf.linkFaces(face, nodeC, faceAB, TriSurf.otherNode(faceAB, nodeA, nodeB));
        nodeA.setEdgeBefore(null);
        nodeB.setEdgeBefore(null);
        nodeC.setEdgeBefore(null);
        nodeA.setEdgeAfter(null);
        nodeB.setEdgeAfter(null);
        nodeC.setEdgeAfter(null);
        this.removeEdge(edgeAB);
        this.removeEdge(edgeBC);
        this.removeEdge(edgeCA);
        this.addFace(face);
    }

    private EdgeFace findTwin(EdgeFace edgeFace) {
        Edge edge = edgeFace.edge;
        Face face = edgeFace.face;
        double grade = edgeFace.grade;
        Node nodeA = edge.nodeA();
        Node nodeB = edge.nodeB();
        Node nodeC = TriSurf.otherNode(face, nodeA, nodeB);
        assert (nodeA.isOnBoundary());
        assert (nodeB.isOnBoundary());
        assert (nodeC.isOnBoundary());
        Node node1 = nodeC.edgeBefore().nodeA();
        assert (node1 != nodeA);
        assert (node1 != nodeB);
        if (node1.isOnBoundary()) {
            Edge edgeTwin = node1.edgeAfter();
            assert (nodeC == edgeTwin.nodeB());
            this.removeEdge(edgeTwin);
            EdgeFace edgeFaceTwin = this.addEdge(edgeTwin);
            Face faceTwin = edgeFaceTwin.face;
            double gradeTwin = edgeFaceTwin.grade;
            if (faceTwin != null && TriSurf.nodesInOrder(faceTwin, node1, nodeC, nodeB) && gradeTwin > grade) {
                return edgeFaceTwin;
            }
        }
        Node node2 = nodeC.edgeAfter().nodeB();
        assert (node2 != nodeA);
        assert (node2 != nodeB);
        if (node2.isOnBoundary()) {
            Edge edgeTwin = node2.edgeBefore();
            assert (nodeC == edgeTwin.nodeA());
            this.removeEdge(edgeTwin);
            EdgeFace edgeFaceTwin = this.addEdge(edgeTwin);
            Face faceTwin = edgeFaceTwin.face;
            double gradeTwin = edgeFaceTwin.grade;
            if (faceTwin != null && TriSurf.nodesInOrder(faceTwin, node2, nodeA, nodeC) && gradeTwin > grade) {
                return edgeFaceTwin;
            }
        }
        return null;
    }

    private void glue(Edge edge, Face face, Edge edgeTwin, Face faceTwin) {
        TriSurf.trace("glue: edge=" + edge + " face=" + face);
        TriSurf.trace("  meshEdge A=" + edge._meshEdge.nodeA());
        TriSurf.trace("  meshEdge B=" + edge._meshEdge.nodeB());
        TriSurf.trace("  meshFace A=" + face._meshFace.nodeA());
        TriSurf.trace("  meshFace B=" + face._meshFace.nodeB());
        TriSurf.trace("  meshFace C=" + face._meshFace.nodeC());
        TriSurf.trace("  meshEdgeTwin A=" + edgeTwin._meshEdge.nodeA());
        TriSurf.trace("  meshEdgeTwin B=" + edgeTwin._meshEdge.nodeB());
        TriSurf.trace("  meshFaceTwin A=" + faceTwin._meshFace.nodeA());
        TriSurf.trace("  meshFaceTwin B=" + faceTwin._meshFace.nodeB());
        TriSurf.trace("  meshFaceTwin C=" + faceTwin._meshFace.nodeC());
        Node nodeA = edge.nodeA();
        Node nodeB = edge.nodeB();
        Node nodeC = TriSurf.otherNode(face, nodeA, nodeB);
        assert (nodeA.isOnBoundary());
        assert (nodeB.isOnBoundary());
        assert (nodeC.isOnBoundary());
        this.removeEdge(edge);
        this.removeEdge(edgeTwin);
        this.addFace(face);
        this.addFace(faceTwin);
        if (faceTwin.references(nodeA)) {
            Node nodeD = nodeC.edgeAfter().nodeB();
            assert (nodeD.isOnBoundary());
            if (nodeD.edgeAfter() == nodeA.edgeBefore()) {
                Edge edgeDA = nodeD.edgeAfter();
                nodeA.setEdgeBefore(null);
                nodeD.setEdgeBefore(null);
                nodeA.setEdgeAfter(null);
                nodeD.setEdgeAfter(null);
                this.removeEdge(edgeDA);
            } else {
                Edge edgeAD = this.makeEdge(nodeA, nodeD, faceTwin);
                nodeA.setEdgeAfter(edgeAD);
                nodeD.setEdgeBefore(edgeAD);
                this.addEdge(edgeAD);
            }
            Edge edgeCB = this.makeEdge(nodeC, nodeB, face);
            nodeC.setEdgeAfter(edgeCB);
            nodeB.setEdgeBefore(edgeCB);
            this.addEdge(edgeCB);
            TriSurf.linkFaces(face, nodeB, faceTwin, nodeD);
            TriSurf.linkFaces(face, nodeC, edge.faceRight(), edge.nodeRight());
            TriSurf.linkFaces(faceTwin, nodeA, edgeTwin.faceRight(), edgeTwin.nodeRight());
        } else if (faceTwin.references(nodeB)) {
            Node nodeD = nodeC.edgeBefore().nodeA();
            assert (nodeD.isOnBoundary());
            if (nodeD.edgeBefore() == nodeB.edgeAfter()) {
                Edge edgeBD = nodeD.edgeBefore();
                nodeB.setEdgeBefore(null);
                nodeD.setEdgeBefore(null);
                nodeB.setEdgeAfter(null);
                nodeD.setEdgeAfter(null);
                this.removeEdge(edgeBD);
            } else {
                Edge edgeDB = this.makeEdge(nodeD, nodeB, faceTwin);
                nodeD.setEdgeAfter(edgeDB);
                nodeB.setEdgeBefore(edgeDB);
                this.addEdge(edgeDB);
            }
            Edge edgeAC = this.makeEdge(nodeA, nodeC, face);
            nodeA.setEdgeAfter(edgeAC);
            nodeC.setEdgeBefore(edgeAC);
            this.addEdge(edgeAC);
            TriSurf.linkFaces(face, nodeA, faceTwin, nodeD);
            TriSurf.linkFaces(face, nodeC, edge.faceRight(), edge.nodeRight());
            TriSurf.linkFaces(faceTwin, nodeB, edgeTwin.faceRight(), edgeTwin.nodeRight());
        }
    }

    private boolean stitch(EdgeFace edgeFace) {
        Node nodeC;
        Node nodeB;
        Edge edge = edgeFace.edge;
        Face face = edgeFace.face;
        Node nodeA = edge.nodeA();
        if (!this.validForFace(nodeA, nodeB = edge.nodeB(), nodeC = TriSurf.otherNode(face, nodeA, nodeB))) {
            this.removeEdge(edge);
            this.addEdge(edge);
            return true;
        }
        if (!nodeC.isInSurface()) {
            this.extend(edge, face);
            return true;
        }
        if (nodeC.isOnBoundary()) {
            Node node1 = nodeC.edgeBefore().nodeA();
            Node node2 = nodeC.edgeAfter().nodeB();
            if (node1 == nodeB && node2 == nodeA) {
                this.fillHole(edge, face);
                return true;
            }
            if (node1 == nodeB || node2 == nodeA) {
                this.fillEar(edge, face);
                return true;
            }
            EdgeFace edgeFaceTwin = this.findTwin(edgeFace);
            if (edgeFaceTwin != null) {
                Edge edgeTwin = edgeFaceTwin.edge;
                Face faceTwin = edgeFaceTwin.face;
                this.glue(edge, face, edgeTwin, faceTwin);
                return true;
            }
            return false;
        }
        assert (false) : "valid face for extend, fill ear, fill hole, or glue";
        return false;
    }

    private void rebuild() {
        TriSurf.trace("rebuild");
        this.init();
        while (this.surf()) {
        }
    }

    private void init() {
        TriSurf.trace("  init: ntets=" + this._mesh.countTets());
        this._faceSet.clear();
        this._faceMap.clear();
        this._edgeMap.clear();
        this._edgeQueue.clear();
        TetMesh.TetIterator ti = this._mesh.getTets();
        while (ti.hasNext()) {
            TetMesh.Tet tet = ti.next();
            TetMesh.Node a = tet.nodeA();
            TetMesh.Node b = tet.nodeB();
            TetMesh.Node c = tet.nodeC();
            TetMesh.Node d = tet.nodeD();
            TetMesh.Face[] meshFaces = new TetMesh.Face[]{new TetMesh.Face(a, b, c, tet), new TetMesh.Face(b, d, c, tet), new TetMesh.Face(c, d, a, tet), new TetMesh.Face(d, b, a, tet)};
            for (int i = 0; i < 4; ++i) {
                TetMesh.Face meshFacei = meshFaces[i];
                if (this._faceSet.contains(meshFacei.mate())) continue;
                this._faceSet.add(meshFacei);
                TriSurf.trace("  init: added face" + meshFacei);
                TriSurf.trace("        node A=" + meshFacei.nodeA());
                TriSurf.trace("        node B=" + meshFacei.nodeB());
                TriSurf.trace("        node C=" + meshFacei.nodeC());
            }
            ((Node)a.data).init();
            ((Node)b.data).init();
            ((Node)c.data).init();
            ((Node)d.data).init();
        }
        TriSurf.trace("  init: _faceSet size=" + this._faceSet.size());
    }

    private boolean surf() {
        int nface = this.countFaces();
        if (this._faceSet.isEmpty()) {
            return false;
        }
        TetMesh.Face meshFace = null;
        double rrmin = Double.MAX_VALUE;
        double[] cc = new double[3];
        for (TetMesh.Face meshFacei : this._faceSet) {
            double rr = meshFacei.centerCircle(cc);
            if (!(rr < rrmin)) continue;
            meshFace = meshFacei;
            rrmin = rr;
        }
        assert (meshFace != null);
        Face face = new Face(meshFace);
        this.init(face);
        TriSurf.trace("  surf: stitching");
        EdgeFace edgeFace = this.getBestEdgeFace();
        while (edgeFace != null && edgeFace.face != null) {
            if (this.stitch(edgeFace)) {
                edgeFace = this.getBestEdgeFace();
                continue;
            }
            edgeFace = this.getNextEdgeFace(edgeFace);
        }
        TriSurf.trace("  surf: removing faces");
        ArrayList<TetMesh.Face> faceList = new ArrayList<TetMesh.Face>();
        for (TetMesh.Face meshFacei : this._faceSet) {
            Node nodeA = (Node)meshFacei.nodeA().data;
            Node nodeB = (Node)meshFacei.nodeB().data;
            Node nodeC = (Node)meshFacei.nodeC().data;
            if (!nodeA.isInSurface() && !nodeB.isInSurface() && !nodeC.isInSurface()) continue;
            faceList.add(meshFacei);
        }
        for (TetMesh.Face meshFacei : faceList) {
            this._faceSet.remove(meshFacei);
        }
        TriSurf.trace("  surf: more faces = " + (this.countFaces() > nface));
        return this.countFaces() > nface;
    }

    private static boolean nodesInOrder(Face face, Node na, Node nb, Node nc) {
        Node fa = face.nodeA();
        Node fb = face.nodeB();
        Node fc = face.nodeC();
        return na == fa && nb == fb && nc == fc || na == fb && nb == fc && nc == fa || na == fc && nb == fa && nc == fb;
    }

    private static Node otherNode(Face face, Node na, Node nb) {
        Node fa = face.nodeA();
        Node fb = face.nodeB();
        Node fc = face.nodeC();
        if (na == fa) {
            if (nb == fb) {
                return fc;
            }
            if (nb == fc) {
                return fb;
            }
            return null;
        }
        if (na == fb) {
            if (nb == fa) {
                return fc;
            }
            if (nb == fc) {
                return fa;
            }
            return null;
        }
        if (na == fc) {
            if (nb == fa) {
                return fb;
            }
            if (nb == fb) {
                return fa;
            }
            return null;
        }
        return null;
    }

    private static TetMesh.Node otherNode(TetMesh.Face face, TetMesh.Node na, TetMesh.Node nb) {
        TetMesh.Node fa = face.nodeA();
        TetMesh.Node fb = face.nodeB();
        TetMesh.Node fc = face.nodeC();
        if (na == fa) {
            if (nb == fb) {
                return fc;
            }
            if (nb == fc) {
                return fb;
            }
            return null;
        }
        if (na == fb) {
            if (nb == fa) {
                return fc;
            }
            if (nb == fc) {
                return fa;
            }
            return null;
        }
        if (na == fc) {
            if (nb == fa) {
                return fb;
            }
            if (nb == fb) {
                return fa;
            }
            return null;
        }
        return null;
    }

    private static void linkFaces(Face face, Node node, Face faceNabor, Node nodeNabor) {
        if (face != null) {
            if (node == face.nodeA()) {
                face._faceA = faceNabor;
            } else if (node == face.nodeB()) {
                face._faceB = faceNabor;
            } else if (node == face.nodeC()) {
                face._faceC = faceNabor;
            } else assert (false) : "node referenced by face";
        }
        if (faceNabor != null) {
            if (nodeNabor == faceNabor.nodeA()) {
                faceNabor._faceA = face;
            } else if (nodeNabor == faceNabor.nodeB()) {
                faceNabor._faceB = face;
            } else if (nodeNabor == faceNabor.nodeC()) {
                faceNabor._faceC = face;
            } else assert (false) : "nodeNabor referenced by faceNabor";
        }
    }

    static float normalVector(TetMesh.Face meshFace, float[] v) {
        double scale;
        double z2;
        double x0;
        double x1;
        double y2;
        double zc;
        double z0;
        double y1;
        double z1;
        TetMesh.Node na = meshFace.nodeA();
        TetMesh.Node nb = meshFace.nodeB();
        TetMesh.Node nc = meshFace.nodeC();
        double xa = na.x();
        double ya = na.y();
        double za = na.z();
        double xb = nb.x();
        double yb = nb.y();
        double zb = nb.z();
        double xc = nc.x();
        double yc = nc.y();
        double y0 = yc - ya;
        double x2 = y0 * (z1 = za - zb) - (y1 = ya - yb) * (z0 = (zc = (double)nc.z()) - za);
        double alpha = x2 * x2 + (y2 = (x1 = xa - xb) * z0 - (x0 = xc - xa) * z1) * y2 + (z2 = x0 * y1 - x1 * y0) * z2;
        double delta = Math.sqrt(alpha);
        double d = scale = delta > 0.0 ? 1.0 / delta : 1.0;
        if (v != null) {
            v[0] = (float)(x2 * scale);
            v[1] = (float)(y2 * scale);
            v[2] = (float)(z2 * scale);
        }
        return (float)(0.5 * scale * alpha);
    }

    static double normalVector(TetMesh.Face meshFace, double[] v) {
        double scale;
        double z2;
        double x0;
        double x1;
        double y2;
        double zc;
        double z0;
        double y1;
        double z1;
        TetMesh.Node na = meshFace.nodeA();
        TetMesh.Node nb = meshFace.nodeB();
        TetMesh.Node nc = meshFace.nodeC();
        double xa = na.x();
        double ya = na.y();
        double za = na.z();
        double xb = nb.x();
        double yb = nb.y();
        double zb = nb.z();
        double xc = nc.x();
        double yc = nc.y();
        double y0 = yc - ya;
        double x2 = y0 * (z1 = za - zb) - (y1 = ya - yb) * (z0 = (zc = (double)nc.z()) - za);
        double alpha = x2 * x2 + (y2 = (x1 = xa - xb) * z0 - (x0 = xc - xa) * z1) * y2 + (z2 = x0 * y1 - x1 * y0) * z2;
        double delta = Math.sqrt(alpha);
        double d = scale = delta > 0.0 ? 1.0 / delta : 1.0;
        if (v != null) {
            v[0] = x2 * scale;
            v[1] = y2 * scale;
            v[2] = z2 * scale;
        }
        return 0.5 * scale * alpha;
    }

    private static double angle(TetMesh.Face face1, TetMesh.Face face2) {
        double[] v1 = new double[3];
        double[] v2 = new double[3];
        TriSurf.normalVector(face1, v1);
        TriSurf.normalVector(face2, v2);
        double cos12 = v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
        return Math.acos(cos12);
    }

    private TetMesh.Edge findMeshEdge(Node nodeA, Node nodeB) {
        TetMesh.Node meshNodeB;
        TetMesh.Node meshNodeA = nodeA._meshNode;
        TetMesh.Edge meshEdge = this._mesh.findEdge(meshNodeA, meshNodeB = nodeB._meshNode);
        if (meshEdge != null && meshNodeA != meshEdge.nodeA()) {
            meshEdge = meshEdge.mate();
        }
        return meshEdge;
    }

    private Edge makeEdge(Node nodeA, Node nodeB, Face face) {
        TetMesh.Edge meshEdge = this.findMeshEdge(nodeA, nodeB);
        return meshEdge != null ? new Edge(meshEdge, face) : null;
    }

    private EdgeFace makeEdgeFace(Edge edge) {
        double grade;
        assert (edge.isOnBoundary());
        Node nodeA = edge.nodeA();
        Node nodeB = edge.nodeB();
        TetMesh.Face meshFace = edge.faceRight()._meshFace;
        double[] v = new double[3];
        TriSurf.normalVector(meshFace, v);
        TetMesh.Edge meshEdge = edge._meshEdge;
        TetMesh.Node meshNodeA = meshEdge.nodeA();
        TetMesh.Node meshNodeB = meshEdge.nodeB();
        double[] cc = new double[3];
        double[] vi = new double[3];
        double rrBest = Double.MAX_VALUE;
        double vvBest = -1.0;
        TetMesh.Face mfBest = null;
        TetMesh.Face mfMate = meshFace.mate();
        for (TetMesh.Face mf : this._mesh.getFaceNabors(meshEdge)) {
            double rr;
            if (mf.equals(mfMate)) continue;
            TetMesh.Node fa = mf.nodeA();
            TetMesh.Node fb = mf.nodeB();
            TetMesh.Node fc = mf.nodeC();
            Node nodeC = fc == meshNodeA ? (Node)fb.data : (fc == meshNodeB ? (Node)fa.data : (Node)fc.data);
            if (!this.validForFace(nodeA, nodeB, nodeC)) continue;
            TriSurf.normalVector(mf, vi);
            double vv = v[0] * vi[0] + v[1] * vi[1] + v[2] * vi[2];
            if (!(vv > VV_SLIVER) || !((rr = mf.centerCircle(cc)) < rrBest)) continue;
            rrBest = rr;
            vvBest = vv;
            mfBest = mf;
        }
        assert (!this._faceMap.containsKey(mfBest) && !this._faceMap.containsKey(mfBest));
        Face face = mfBest != null ? new Face(mfBest) : null;
        double d = grade = vvBest > VV_LARGE ? 1.0 / rrBest : vvBest - 1.0;
        if (grade <= 0.0) {
            face = null;
        }
        return new EdgeFace(edge, face, grade);
    }

    private boolean hasInternalEdge(Node nodeA, Node nodeB) {
        Face face = this.findFace(nodeA, nodeB);
        if (face == null) {
            return false;
        }
        return (face = face.faceNabor(TriSurf.otherNode(face, nodeA, nodeB))) != null;
    }

    private boolean validForFace(Node nodeA, Node nodeB, Node nodeC) {
        return !nodeC.isInSurface() || nodeC.isOnBoundary() && !this.hasInternalEdge(nodeB, nodeC) && !this.hasInternalEdge(nodeC, nodeA);
    }

    private static void trace(String s) {
    }

    private static class EdgeFace
    implements Comparable<EdgeFace> {
        Edge edge;
        Face face;
        double grade;

        EdgeFace(Edge edge, Face face, double grade) {
            this.edge = edge;
            this.face = face;
            this.grade = grade;
        }

        @Override
        public int compareTo(EdgeFace other) {
            int hashOther;
            double gradeOther = other.grade;
            if (this.grade < gradeOther) {
                return -1;
            }
            if (this.grade > gradeOther) {
                return 1;
            }
            Edge edgeOther = other.edge;
            int hash = this.edge.hashCode();
            if (hash < (hashOther = edgeOther.hashCode())) {
                return -1;
            }
            if (hash > hashOther) {
                return 1;
            }
            return 0;
        }
    }

    public static class FaceList {
        private int _n = 0;
        private Face[] _a = new Face[64];

        public final void add(Face face) {
            if (this._n == this._a.length) {
                Face[] t = new Face[this._a.length * 2];
                System.arraycopy(this._a, 0, t, 0, this._n);
                this._a = t;
            }
            this._a[this._n++] = face;
        }

        public final Face remove(int index) {
            Face face = this._a[index];
            --this._n;
            if (this._n > index) {
                System.arraycopy(this._a, index + 1, this._a, index, this._n - index);
            }
            return face;
        }

        public final Face[] trim() {
            if (this._n < this._a.length) {
                Face[] t = new Face[this._n];
                System.arraycopy(this._a, 0, t, 0, this._n);
                this._a = t;
            }
            return this._a;
        }

        public final void clear() {
            this._n = 0;
        }

        public final int nface() {
            return this._n;
        }

        public final Face[] faces() {
            return this._a;
        }
    }

    public static interface FaceIterator {
        public boolean hasNext();

        public Face next();
    }

    public static class Face {
        public int index;
        public Object data;
        private TetMesh.Face _meshFace;
        private Face _faceA;
        private Face _faceB;
        private Face _faceC;
        private int _mark;

        public final Node nodeA() {
            return (Node)this._meshFace.nodeA().data;
        }

        public final Node nodeB() {
            return (Node)this._meshFace.nodeB().data;
        }

        public final Node nodeC() {
            return (Node)this._meshFace.nodeC().data;
        }

        public final Face faceA() {
            return this._faceA;
        }

        public final Face faceB() {
            return this._faceB;
        }

        public final Face faceC() {
            return this._faceC;
        }

        public Face mate() {
            return new Face(this._meshFace.mate());
        }

        public final Node nodeNearest(float x, float y, float z) {
            Node na = this.nodeA();
            Node nb = this.nodeB();
            Node nc = this.nodeC();
            double da = TriSurf.distanceSquared(na, x, y, z);
            double db = TriSurf.distanceSquared(nb, x, y, z);
            double dc = TriSurf.distanceSquared(nc, x, y, z);
            double dmin = da;
            Node nmin = na;
            if (db < dmin) {
                dmin = db;
                nmin = nb;
            }
            if (dc < dmin) {
                dmin = dc;
                nmin = nc;
            }
            return nmin;
        }

        public final Face faceNabor(Node node) {
            if (node == this.nodeA()) {
                return this._faceA;
            }
            if (node == this.nodeB()) {
                return this._faceB;
            }
            if (node == this.nodeC()) {
                return this._faceC;
            }
            Check.argument(false, "node is referenced by face");
            return null;
        }

        public final Node nodeNabor(Face faceNabor) {
            if (faceNabor._faceA == this) {
                return faceNabor.nodeA();
            }
            if (faceNabor._faceB == this) {
                return faceNabor.nodeB();
            }
            if (faceNabor._faceC == this) {
                return faceNabor.nodeC();
            }
            Check.argument(false, "faceNabor is a nabor of face");
            return null;
        }

        public double centerCircle(double[] cc) {
            Node na = this.nodeA();
            Node nb = this.nodeB();
            Node nc = this.nodeC();
            double xa = na.x();
            double ya = na.y();
            double za = na.z();
            double xb = nb.x();
            double yb = nb.y();
            double zb = nb.z();
            double xc = nc.x();
            double yc = nc.y();
            double zc = nc.z();
            Geometry.centerCircle3D(xa, ya, za, xb, yb, zb, xc, yc, zc, cc);
            double xcc = cc[0];
            double ycc = cc[1];
            double zcc = cc[2];
            double dx = xcc - xc;
            double dy = ycc - yc;
            double dz = zcc - yc;
            return dx * dx + dy * dy + dz * dz;
        }

        public double[] centerCircle() {
            double[] cc = new double[3];
            this.centerCircle(cc);
            return cc;
        }

        public float area() {
            return TriSurf.normalVector(this._meshFace, null);
        }

        public float[] normalVector() {
            float[] vn = new float[3];
            TriSurf.normalVector(this._meshFace, vn);
            return vn;
        }

        public float normalVector(float[] vn) {
            return TriSurf.normalVector(this._meshFace, vn);
        }

        public boolean references(Node node) {
            return node == this.nodeA() || node == this.nodeB() || node == this.nodeC();
        }

        public boolean references(Node node1, Node node2) {
            Node na = this.nodeA();
            Node nb = this.nodeB();
            Node nc = this.nodeC();
            if (node1 == na) {
                return node2 == nb || node2 == nc;
            }
            if (node1 == nb) {
                return node2 == na || node2 == nc;
            }
            if (node1 == nc) {
                return node2 == na || node2 == nb;
            }
            return false;
        }

        public boolean references(Node node1, Node node2, Node node3) {
            Node na = this.nodeA();
            Node nb = this.nodeB();
            Node nc = this.nodeC();
            if (node1 == na) {
                if (node2 == nb) {
                    return node3 == nc;
                }
                if (node2 == nc) {
                    return node3 == nb;
                }
                return false;
            }
            if (node1 == nb) {
                if (node2 == na) {
                    return node3 == nc;
                }
                if (node2 == nc) {
                    return node3 == na;
                }
                return false;
            }
            if (node1 == nc) {
                if (node2 == na) {
                    return node3 == nb;
                }
                if (node2 == nb) {
                    return node3 == na;
                }
                return false;
            }
            return false;
        }

        private void validate() {
            assert (this._meshFace != null);
        }

        private Face(TetMesh.Face meshFace) {
            this._meshFace = meshFace;
        }
    }

    public static interface EdgeIterator {
        public boolean hasNext();

        public Edge next();
    }

    public static class Edge {
        private TetMesh.Edge _meshEdge;
        private Face _faceLeft;
        private Face _faceRight;

        public Node nodeA() {
            return (Node)this._meshEdge.nodeA().data;
        }

        public Node nodeB() {
            return (Node)this._meshEdge.nodeB().data;
        }

        public Face faceLeft() {
            return this._faceLeft;
        }

        public Face faceRight() {
            return this._faceRight;
        }

        public Node nodeLeft() {
            return this._faceLeft != null ? TriSurf.otherNode(this._faceLeft, this.nodeA(), this.nodeB()) : null;
        }

        public Node nodeRight() {
            return this._faceRight != null ? TriSurf.otherNode(this._faceRight, this.nodeA(), this.nodeB()) : null;
        }

        public Edge edgeBefore() {
            return this.nodeA()._edgeBefore;
        }

        public Edge edgeAfter() {
            return this.nodeB()._edgeAfter;
        }

        public Edge mate() {
            return new Edge(this._meshEdge.mate(), this._faceRight);
        }

        public boolean isInSurface() {
            return this._faceRight != null;
        }

        public boolean isOnBoundary() {
            return this._faceLeft == null;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object != null && object.getClass() == this.getClass()) {
                Edge other = (Edge)object;
                return other.nodeA() == this.nodeA() && other.nodeB() == this.nodeB();
            }
            return false;
        }

        public int hashCode() {
            return this.nodeA().hashCode() ^ this.nodeB().hashCode();
        }

        private void validate() {
            assert (this._meshEdge != null);
            assert (this._faceLeft == null || this._faceLeft.references(this.nodeA(), this.nodeB()));
            assert (this._faceRight == null || this._faceRight.references(this.nodeA(), this.nodeB()));
        }

        private Edge(TetMesh.Edge meshEdge, Face face) {
            this._meshEdge = meshEdge;
            Node nodeA = (Node)meshEdge.nodeA().data;
            Node nodeB = (Node)meshEdge.nodeB().data;
            Node nodeC = face != null ? TriSurf.otherNode(face, nodeA, nodeB) : null;
            Check.argument(face == null || nodeC != null, "face references edge");
            if (nodeC != null) {
                if (TriSurf.nodesInOrder(face, nodeA, nodeB, nodeC)) {
                    this._faceLeft = face;
                    this._faceRight = face.faceNabor(nodeC);
                } else {
                    this._faceLeft = face.faceNabor(nodeC);
                    this._faceRight = face;
                }
            }
        }
    }

    public static interface NodeIterator {
        public boolean hasNext();

        public Node next();
    }

    public static class Node {
        public int index;
        public Object data;
        private TetMesh.Node _meshNode;
        private Face _face;
        private Edge _edgeBefore;
        private Edge _edgeAfter;

        public Node(float x, float y, float z) {
            this._meshNode = new TetMesh.Node(x, y, z);
            this._meshNode.data = this;
        }

        public final float x() {
            return this._meshNode.x();
        }

        public final float y() {
            return this._meshNode.y();
        }

        public final float z() {
            return this._meshNode.z();
        }

        public boolean isInSurface() {
            return this._face != null;
        }

        public boolean isOnBoundary() {
            return this._edgeBefore != null;
        }

        public Edge edgeBefore() {
            return this._edgeBefore;
        }

        public Edge edgeAfter() {
            return this._edgeAfter;
        }

        public float[] normalVector() {
            float[] vn = new float[3];
            this.normalVector(vn);
            return vn;
        }

        public void normalVector(float[] vn) {
            vn[2] = 0.0f;
            vn[1] = 0.0f;
            vn[0] = 0.0f;
            FaceIterator fi = this.getFaces();
            while (fi.hasNext()) {
                Face face = fi.next();
                Node.accNormalVector(face, vn);
            }
            float x = vn[0];
            float y = vn[1];
            float z = vn[2];
            float s = 1.0f / (float)Math.sqrt(x * x + y * y + z * z);
            vn[0] = vn[0] * s;
            vn[1] = vn[1] * s;
            vn[2] = vn[2] * s;
        }

        public int countFaces() {
            int nface = 0;
            FaceIterator fi = this.getFaces();
            while (fi.hasNext()) {
                fi.next();
                ++nface;
            }
            return nface;
        }

        public FaceIterator getFaces() {
            return new FaceIterator(){
                private Face _next;
                private boolean _ccw;
                {
                    this._next = Node.this._face;
                    this._ccw = true;
                }

                @Override
                public boolean hasNext() {
                    return this._next != null;
                }

                @Override
                public Face next() {
                    if (this._next == null) {
                        throw new NoSuchElementException();
                    }
                    Face face = this._next;
                    this.loadNext();
                    return face;
                }

                private void loadNext() {
                    if (this._ccw) {
                        this._next = Node.this.faceNext(this._next);
                        if (this._next == null) {
                            this._ccw = false;
                            this._next = Node.this._face;
                        } else if (this._next == Node.this._face) {
                            this._next = null;
                        }
                    }
                    if (!this._ccw) {
                        this._next = Node.this.facePrev(this._next);
                    }
                }
            };
        }

        public String toString() {
            return this._meshNode.toString();
        }

        private void validate() {
            assert (this._meshNode != null);
            assert (this._face == null || this._face.references(this));
            if (this._edgeBefore == null) {
                assert (this._edgeAfter == null);
            } else {
                assert (this == this._edgeBefore.nodeB());
                assert (this == this._edgeAfter.nodeA());
                assert (this == this._edgeBefore.nodeA().edgeAfter().nodeB());
                assert (this == this._edgeAfter.nodeB().edgeBefore().nodeA());
            }
            assert (this._edgeBefore == null && this._edgeAfter == null || this._edgeBefore != null && this == this._edgeBefore.nodeB() && this._edgeAfter != null && this == this._edgeAfter.nodeA());
        }

        private void init() {
            this._face = null;
            this._edgeBefore = null;
            this._edgeAfter = null;
        }

        private void setFace(Face face) {
            this._face = face;
        }

        private void setEdgeBefore(Edge edgeBefore) {
            this._edgeBefore = edgeBefore;
        }

        private void setEdgeAfter(Edge edgeAfter) {
            this._edgeAfter = edgeAfter;
        }

        private Face face() {
            return this._face;
        }

        private Face faceNext(Face face) {
            if (this == face.nodeA()) {
                return face.faceB();
            }
            if (this == face.nodeB()) {
                return face.faceC();
            }
            return face.faceA();
        }

        private Face facePrev(Face face) {
            if (this == face.nodeA()) {
                return face.faceC();
            }
            if (this == face.nodeB()) {
                return face.faceA();
            }
            return face.faceB();
        }

        private static void accNormalVector(Face face, float[] v) {
            Node na = face.nodeA();
            Node nb = face.nodeB();
            Node nc = face.nodeC();
            float xa = na.x();
            float ya = na.y();
            float za = na.z();
            float xb = nb.x();
            float yb = nb.y();
            float zb = nb.z();
            float xc = nc.x();
            float yc = nc.y();
            float zc = nc.z();
            float x0 = xc - xa;
            float y0 = yc - ya;
            float z0 = zc - za;
            float x1 = xa - xb;
            float y1 = ya - yb;
            float z1 = za - zb;
            v[0] = v[0] + (y0 * z1 - y1 * z0);
            v[1] = v[1] + (x1 * z0 - x0 * z1);
            v[2] = v[2] + (x0 * y1 - x1 * y0);
        }
    }
}

