/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.mosaic.GridView;
import edu.mines.jtk.mosaic.PlotFrame;
import edu.mines.jtk.mosaic.PlotPanel;
import edu.mines.jtk.mosaic.PointsView;
import edu.mines.jtk.util.ArrayMath;
import java.awt.Component;
import java.awt.Label;
import javax.swing.SwingUtilities;

public class PlotFrameDemo {
    private PlotFrame _plotFrame;
    private PlotPanel _plotPanel;
    private PointsView _pointsView;
    private GridView _gridView;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new PlotFrameDemo();
            }
        });
    }

    public PlotFrameDemo() {
        float[] x = ArrayMath.rampfloat(0.0f, 0.06283186f, 201);
        float[] s = ArrayMath.sin(x);
        this._plotPanel = new PlotPanel();
        this._plotPanel.setTitle("The sine function");
        this._plotPanel.setHLabel("x");
        this._plotPanel.setVLabel("sin(x)");
        this._gridView = this._plotPanel.addGrid();
        this._pointsView = this._plotPanel.addPoints(x, s);
        this._pointsView.setStyle("r-o");
        this._plotFrame = new PlotFrame(this._plotPanel);
        this._plotFrame.setDefaultCloseOperation(3);
        this._plotFrame.setVisible(true);
        this._plotFrame.add((Component)new Label("In either plot or axes, click-drag to zoom, click to unzoom."), "North");
    }

    public PlotFrame getPlotFrame() {
        return this._plotFrame;
    }

    public PlotPanel getPlotPanel() {
        return this._plotPanel;
    }

    public PointsView getPointsView() {
        return this._pointsView;
    }

    public GridView getGridView() {
        return this._gridView;
    }
}

