/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.MathPlus;

public class BrentZeroFinder {
    private Function _f;
    private static final double EPS = 2.220446049250313E-16;

    public BrentZeroFinder(Function f) {
        this._f = f;
    }

    public double f(double x) {
        return this._f.evaluate(x);
    }

    public double findZero(double a, double b, double tol) {
        double fa = this._f.evaluate(a);
        double fb = this._f.evaluate(b);
        return this.findZero(a, fa, b, fb, tol);
    }

    public double findZero(double a, double fa, double b, double fb, double tol) {
        Check.argument(a < b, "Invalid Search Interval");
        Check.argument(fa <= 0.0 && fb >= 0.0 || fa >= 0.0 && fb <= 0.0, "Function values must not have same sign");
        Check.argument(tol > 0.0, "Accuracy must be greater than zero");
        double c = a;
        double fc = fa;
        while (true) {
            double e = b - a;
            if (MathPlus.abs(fc) < MathPlus.abs(fb)) {
                a = b;
                fa = fb;
                b = c;
                fb = fc;
                c = a;
                fc = fa;
            }
            double d = 0.5 * (c - b);
            double dtol = 4.440892098500626E-16 * MathPlus.abs(b) + 0.5 * tol;
            if (MathPlus.abs(d) <= dtol || fb == 0.0) {
                return b;
            }
            if (MathPlus.abs(e) >= dtol && MathPlus.abs(fa) > MathPlus.abs(fb)) {
                double q;
                double p;
                if (a == c) {
                    double s = fb / fa;
                    p = 2.0 * d * s;
                    q = 1.0 - s;
                } else {
                    double r = fb / fc;
                    double s = fb / fa;
                    q = fa / fc;
                    p = s * (2.0 * d * q * (q - r) - (b - a) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                } else {
                    p = -p;
                }
                if (2.0 * p < 3.0 * d * q - MathPlus.abs(dtol * q) && p < MathPlus.abs(0.5 * e * q)) {
                    d = p / q;
                }
            }
            if (MathPlus.abs(d) < dtol) {
                d = d > 0.0 ? dtol : -dtol;
            }
            a = b;
            fa = fb;
            fb = this._f.evaluate(b += d);
            if (!(fb > 0.0 && fc > 0.0) && (!(fb < 0.0) || !(fc < 0.0))) continue;
            c = a;
            fc = fa;
        }
    }

    public static interface Function {
        public double evaluate(double var1);
    }
}

