/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.ogl.Gl;
import edu.mines.jtk.ogl.GlDisplayList;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Direct;
import java.nio.FloatBuffer;

public class EllipsoidGlyph {
    private float[] _m;
    private int _nv;
    private float[] _xyz;
    private GlDisplayList _displayList;

    public EllipsoidGlyph() {
        this(4);
    }

    public EllipsoidGlyph(int m) {
        this.makeTransformMatrix();
        this.makeUnitSphere(m);
    }

    public int countVertices() {
        return this._nv;
    }

    public float[] getVertices() {
        return this._xyz;
    }

    public void draw() {
        if (this._displayList == null) {
            FloatBuffer xyz = Direct.newFloatBuffer(3 * this._nv);
            xyz.put(this._xyz);
            xyz.rewind();
            this._displayList = new GlDisplayList();
            Gl.glEnableClientState(32884);
            Gl.glEnableClientState(32885);
            Gl.glNewList(this._displayList.list(), 4864);
            Gl.glVertexPointer(3, 5126, 0, xyz);
            Gl.glNormalPointer(5126, 0, xyz);
            Gl.glDrawArrays(4, 0, this._nv);
            Gl.glEndList();
            Gl.glDisableClientState(32885);
            Gl.glDisableClientState(32884);
        }
        Gl.glCallList(this._displayList.list());
    }

    public void draw(float cx, float cy, float cz, float r) {
        this.draw(cx, cy, cz, r, r, r);
    }

    public void draw(float cx, float cy, float cz, float dx, float dy, float dz) {
        Gl.glPushMatrix();
        Gl.glTranslatef(cx, cy, cz);
        Gl.glScalef(dx, dy, dz);
        this.draw();
        Gl.glPopMatrix();
    }

    public void draw(float cx, float cy, float cz, float ux, float uy, float uz, float vx, float vy, float vz, float wx, float wy, float wz) {
        if ((double)(ux * (vy * wz - vz * wy) + uy * (vz * wx - vx * wz) + uz * (vx * wy - vy * wx)) < 0.0) {
            ux = -ux;
            uy = -uy;
            uz = -uz;
            vx = -vx;
            vy = -vy;
            vz = -vz;
            wx = -wx;
            wy = -wy;
            wz = -wz;
        }
        this._m[0] = ux;
        this._m[4] = vx;
        this._m[8] = wx;
        this._m[12] = cx;
        this._m[1] = uy;
        this._m[5] = vy;
        this._m[9] = wy;
        this._m[13] = cy;
        this._m[2] = uz;
        this._m[6] = vz;
        this._m[10] = wz;
        this._m[14] = cz;
        Gl.glPushMatrix();
        Gl.glMultMatrixf(this._m, 0);
        this.draw();
        Gl.glPopMatrix();
    }

    private void makeTransformMatrix() {
        this._m = new float[16];
        this._m[15] = 1.0f;
    }

    private void makeUnitSphere(int m) {
        this._nv = 24;
        for (int i = 0; i < m; ++i) {
            this._nv *= 4;
        }
        int n = this._nv * 3;
        this._xyz = new float[n];
        float xm = -1.0f;
        float x0 = 0.0f;
        float xp = 1.0f;
        float ym = -1.0f;
        float y0 = 0.0f;
        float yp = 1.0f;
        float zm = -1.0f;
        float z0 = 0.0f;
        float zp = 1.0f;
        n = 0;
        n = this.addTri(xp, y0, z0, x0, yp, z0, x0, y0, zp, m, n);
        n = this.addTri(xm, y0, z0, x0, y0, zp, x0, yp, z0, m, n);
        n = this.addTri(xp, y0, z0, x0, y0, zp, x0, ym, z0, m, n);
        n = this.addTri(xm, y0, z0, x0, ym, z0, x0, y0, zp, m, n);
        n = this.addTri(xp, y0, z0, x0, y0, zm, x0, yp, z0, m, n);
        n = this.addTri(xm, y0, z0, x0, yp, z0, x0, y0, zm, m, n);
        n = this.addTri(xp, y0, z0, x0, ym, z0, x0, y0, zm, m, n);
        n = this.addTri(xm, y0, z0, x0, y0, zm, x0, ym, z0, m, n);
    }

    private int addTri(float xa, float ya, float za, float xb, float yb, float zb, float xc, float yc, float zc, int m, int n) {
        if (m == 0) {
            this._xyz[n++] = xa;
            this._xyz[n++] = ya;
            this._xyz[n++] = za;
            this._xyz[n++] = xb;
            this._xyz[n++] = yb;
            this._xyz[n++] = zb;
            this._xyz[n++] = xc;
            this._xyz[n++] = yc;
            this._xyz[n++] = zc;
        } else {
            float xab = 0.5f * (xa + xb);
            float yab = 0.5f * (ya + yb);
            float zab = 0.5f * (za + zb);
            float xbc = 0.5f * (xb + xc);
            float ybc = 0.5f * (yb + yc);
            float zbc = 0.5f * (zb + zc);
            float xca = 0.5f * (xc + xa);
            float yca = 0.5f * (yc + ya);
            float zca = 0.5f * (zc + za);
            float dab = ArrayMath.sqrt(xab * xab + yab * yab + zab * zab);
            float dbc = ArrayMath.sqrt(xbc * xbc + ybc * ybc + zbc * zbc);
            float dca = ArrayMath.sqrt(xca * xca + yca * yca + zca * zca);
            float sab = 1.0f / dab;
            float sbc = 1.0f / dbc;
            float sca = 1.0f / dca;
            n = this.addTri(xa, ya, za, xab *= sab, yab *= sab, zab *= sab, xca *= sca, yca *= sca, zca *= sca, --m, n);
            n = this.addTri(xb, yb, zb, xbc *= sbc, ybc *= sbc, zbc *= sbc, xab, yab, zab, m, n);
            n = this.addTri(xc, yc, zc, xca, yca, zca, xbc, ybc, zbc, m, n);
            n = this.addTri(xab, yab, zab, xbc, ybc, zbc, xca, yca, zca, m, n);
        }
        return n;
    }
}

