/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.Check;

public class Quantiler {
    private float _q;
    private float _fnull;
    private double _m0;
    private double _m1;
    private double _m2;
    private double _m3;
    private double _m4;
    private double _q0;
    private double _q1;
    private double _q2;
    private double _q3;
    private double _q4;
    private double _f1;
    private double _f2;
    private double _f3;
    private double _d1;
    private double _d2;
    private double _d3;
    private boolean _ignoreNull;
    private boolean _inited;

    public Quantiler(float q) {
        Check.argument(0.0f <= q, "0.0f<=q");
        Check.argument(q <= 1.0f, "q<=1.0f");
        this._q = q;
        this._m0 = -1.0;
        this._q2 = 0.0;
        this._inited = (double)this._q == 0.0 || (double)this._q == 1.0;
    }

    public Quantiler(float q, float fnull) {
        Check.argument(0.0f <= q, "0.0f<=q");
        Check.argument(q <= 1.0f, "q<=1.0f");
        this._q = q;
        this._fnull = fnull;
        this._ignoreNull = true;
        this._m0 = -1.0;
        this._q2 = fnull;
        this._inited = (double)this._q == 0.0 || (double)this._q == 1.0;
    }

    public float estimate() {
        return (float)this._q2;
    }

    public float update(float f) {
        if (!this._inited) {
            this.initOne(f);
        } else {
            this.updateOne(f);
        }
        return this.estimate();
    }

    public float update(float[] f) {
        int i;
        int n = f.length;
        for (i = 0; !this._inited && i < n; ++i) {
            this.initOne(f[i]);
        }
        while (i < n) {
            this.updateOne(f[i]);
            ++i;
        }
        return this.estimate();
    }

    public float update(float[][] f) {
        int n = f.length;
        for (int i = 0; i < n; ++i) {
            this.update(f[i]);
        }
        return this.estimate();
    }

    public float update(float[][][] f) {
        int n = f.length;
        for (int i = 0; i < n; ++i) {
            this.update(f[i]);
        }
        return this.estimate();
    }

    public static float estimate(float q, float[] f) {
        Quantiler qu = new Quantiler(q);
        return qu.update(f);
    }

    public static float estimate(float q, float[][] f) {
        Quantiler qu = new Quantiler(q);
        return qu.update(f);
    }

    public static float estimate(float q, float[][][] f) {
        Quantiler qu = new Quantiler(q);
        return qu.update(f);
    }

    public static float estimate(float q, float fnull, float[] f) {
        Quantiler qu = new Quantiler(q, fnull);
        return qu.update(f);
    }

    public static float estimate(float q, float fnull, float[][] f) {
        Quantiler qu = new Quantiler(q, fnull);
        return qu.update(f);
    }

    public static float estimate(float q, float fnull, float[][][] f) {
        Quantiler qu = new Quantiler(q, fnull);
        return qu.update(f);
    }

    private void initOne(float f) {
        if (this._ignoreNull && f == this._fnull) {
            return;
        }
        if (this._m0 < 0.0) {
            this._m0 = 0.0;
            this._q0 = f;
        } else if (this._m1 == 0.0) {
            this._m1 = 1.0;
            this._q1 = f;
        } else if (this._m2 == 0.0) {
            this._m2 = 2.0;
            this._q2 = f;
        } else if (this._m3 == 0.0) {
            this._m3 = 3.0;
            this._q3 = f;
        } else if (this._m4 == 0.0) {
            this._m4 = 4.0;
            this._q4 = f;
        }
        if (this._m4 == 0.0) {
            return;
        }
        double[] y = new double[]{this._q0, this._q1, this._q2, this._q3, this._q4};
        for (int i = 1; i < 5; ++i) {
            for (int j = i; j > 0 && y[j - 1] > y[j]; --j) {
                double ytemp = y[j - 1];
                y[j - 1] = y[j];
                y[j] = ytemp;
            }
        }
        this._q0 = y[0];
        this._q1 = y[1];
        this._q2 = y[2];
        this._q3 = y[3];
        this._q4 = y[4];
        this._f1 = 2.0 * (double)this._q;
        this._f2 = 4.0 * (double)this._q;
        this._f3 = 2.0 + 2.0 * (double)this._q;
        this._d1 = (double)this._q / 2.0;
        this._d2 = this._q;
        this._d3 = (1.0 + (double)this._q) / 2.0;
        this._inited = true;
    }

    private void updateOne(float f) {
        assert (this._inited) : "quantiler is initialized";
        if (this._ignoreNull && f == this._fnull) {
            return;
        }
        if (this._q == 0.0f) {
            if ((double)f < this._q2) {
                this._q2 = f;
            }
        } else if (this._q == 1.0f) {
            if ((double)f > this._q2) {
                this._q2 = f;
            }
        } else {
            if ((double)f < this._q0) {
                this._m1 += 1.0;
                this._m2 += 1.0;
                this._m3 += 1.0;
                this._m4 += 1.0;
                this._q0 = f;
            } else if ((double)f < this._q1) {
                this._m1 += 1.0;
                this._m2 += 1.0;
                this._m3 += 1.0;
                this._m4 += 1.0;
            } else if ((double)f < this._q2) {
                this._m2 += 1.0;
                this._m3 += 1.0;
                this._m4 += 1.0;
            } else if ((double)f < this._q3) {
                this._m3 += 1.0;
                this._m4 += 1.0;
            } else if ((double)f < this._q4) {
                this._m4 += 1.0;
            } else {
                this._m4 += 1.0;
                this._q4 = f;
            }
            this._f1 += this._d1;
            this._f2 += this._d2;
            this._f3 += this._d3;
            double mm = this._m1 - 1.0;
            double mp = this._m1 + 1.0;
            if (this._f1 >= mp && this._m2 > mp) {
                this._q1 = Quantiler.qp(mp, this._m0, this._m1, this._m2, this._q0, this._q1, this._q2);
                this._m1 = mp;
            } else if (this._f1 <= mm && this._m0 < mm) {
                this._q1 = Quantiler.qm(mm, this._m0, this._m1, this._m2, this._q0, this._q1, this._q2);
                this._m1 = mm;
            }
            mm = this._m2 - 1.0;
            mp = this._m2 + 1.0;
            if (this._f2 >= mp && this._m3 > mp) {
                this._q2 = Quantiler.qp(mp, this._m1, this._m2, this._m3, this._q1, this._q2, this._q3);
                this._m2 = mp;
            } else if (this._f2 <= mm && this._m1 < mm) {
                this._q2 = Quantiler.qm(mm, this._m1, this._m2, this._m3, this._q1, this._q2, this._q3);
                this._m2 = mm;
            }
            mm = this._m3 - 1.0;
            mp = this._m3 + 1.0;
            if (this._f3 >= mp && this._m4 > mp) {
                this._q3 = Quantiler.qp(mp, this._m2, this._m3, this._m4, this._q2, this._q3, this._q4);
                this._m3 = mp;
            } else if (this._f3 <= mm && this._m2 < mm) {
                this._q3 = Quantiler.qm(mm, this._m2, this._m3, this._m4, this._q2, this._q3, this._q4);
                this._m3 = mm;
            }
        }
    }

    private static double qp(double mp, double m0, double m1, double m2, double q0, double q1, double q2) {
        double qt = q1 + ((mp - m0) * (q2 - q1) / (m2 - m1) + (m2 - mp) * (q1 - q0) / (m1 - m0)) / (m2 - m0);
        return qt <= q2 ? qt : q1 + (q2 - q1) / (m2 - m1);
    }

    private static double qm(double mm, double m0, double m1, double m2, double q0, double q1, double q2) {
        double qt = q1 - ((mm - m0) * (q2 - q1) / (m2 - m1) + (m2 - mm) * (q1 - q0) / (m1 - m0)) / (m2 - m0);
        return q0 <= qt ? qt : q1 + (q0 - q1) / (m0 - m1);
    }
}

