/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.geometry;

import org.scijava.java3d.Appearance;
import org.scijava.java3d.Node;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.utils.geometry.GeomBuffer;
import org.scijava.java3d.utils.geometry.Primitive;
import org.scijava.java3d.utils.geometry.Quadrics;

public class Cylinder
extends Primitive {
    float radius;
    float height;
    int xdivisions;
    int ydivisions;
    static final int MID_REZ_DIV_X = 15;
    static final int MID_REZ_DIV_Y = 1;
    public static final int BODY = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;

    public Cylinder() {
        this(1.0f, 2.0f, 1, 15, 1, null);
    }

    public Cylinder(float radius, float height) {
        this(radius, height, 1, 15, 1, null);
    }

    public Cylinder(float radius, float height, Appearance ap) {
        this(radius, height, 1, 15, 1, ap);
    }

    public Cylinder(float radius, float height, int primflags, Appearance ap) {
        this(radius, height, primflags, 15, 1, ap);
    }

    @Override
    public Shape3D getShape(int partId) {
        if (partId > 2 || partId < 0) {
            return null;
        }
        return (Shape3D)this.getChild(partId);
    }

    @Override
    public void setAppearance(Appearance ap) {
        ((Shape3D)this.getChild(0)).setAppearance(ap);
        ((Shape3D)this.getChild(1)).setAppearance(ap);
        ((Shape3D)this.getChild(2)).setAppearance(ap);
    }

    @Override
    public Appearance getAppearance(int partId) {
        if (partId > 2 || partId < 0) {
            return null;
        }
        return this.getShape(partId).getAppearance();
    }

    public Cylinder(float radius, float height, int primflags, int xdivision, int ydivision, Appearance ap) {
        this.radius = radius;
        this.height = height;
        this.xdivisions = xdivision;
        this.ydivisions = ydivision;
        this.flags = primflags;
        boolean outside = (this.flags & 4) == 0;
        boolean texCoordYUp = (this.flags & 8) != 0;
        Quadrics q = new Quadrics();
        GeomBuffer gbuf = null;
        Shape3D[] shape = new Shape3D[3];
        GeomBuffer cache = this.getCachedGeometry(2, 0.0f, radius, height, xdivision, ydivision, primflags);
        if (cache != null) {
            shape[0] = new Shape3D(cache.getComputedGeometry());
            this.numVerts += cache.getNumVerts();
            this.numTris += cache.getNumTris();
        } else {
            gbuf = q.cylinder(height, radius, xdivision, ydivision, outside, texCoordYUp);
            shape[0] = new Shape3D(gbuf.getGeom(this.flags));
            this.numVerts += gbuf.getNumVerts();
            this.numTris += gbuf.getNumTris();
            if ((primflags & 0x10) == 0) {
                this.cacheGeometry(2, 0.0f, radius, height, xdivision, ydivision, primflags, gbuf);
            }
        }
        if ((this.flags & 0x40) != 0) {
            shape[0].setCapability(14);
            shape[0].setCapability(15);
        }
        if ((this.flags & 0x20) != 0) {
            shape[0].setCapability(12);
        }
        this.addChild(shape[0]);
        cache = this.getCachedGeometry(16, radius, radius, height / 2.0f, xdivision, xdivision, primflags);
        if (cache != null) {
            shape[1] = new Shape3D(cache.getComputedGeometry());
            this.numVerts += cache.getNumVerts();
            this.numTris += cache.getNumTris();
        } else {
            gbuf = q.disk(radius, xdivision, (double)height / 2.0, outside, texCoordYUp);
            shape[1] = new Shape3D(gbuf.getGeom(this.flags));
            this.numVerts += gbuf.getNumVerts();
            this.numTris += gbuf.getNumTris();
            if ((primflags & 0x10) == 0) {
                this.cacheGeometry(16, radius, radius, height / 2.0f, xdivision, xdivision, primflags, gbuf);
            }
        }
        if ((this.flags & 0x40) != 0) {
            shape[1].setCapability(14);
            shape[1].setCapability(15);
        }
        if ((this.flags & 0x20) != 0) {
            shape[1].setCapability(12);
        }
        this.addChild(shape[1]);
        cache = this.getCachedGeometry(32, radius, radius, -height / 2.0f, xdivision, xdivision, primflags);
        if (cache != null) {
            shape[2] = new Shape3D(cache.getComputedGeometry());
            this.numVerts += cache.getNumVerts();
            this.numTris += cache.getNumTris();
        } else {
            gbuf = q.disk(radius, xdivision, (double)(-height) / 2.0, !outside, texCoordYUp);
            shape[2] = new Shape3D(gbuf.getGeom(this.flags));
            this.numVerts += gbuf.getNumVerts();
            this.numTris += gbuf.getNumTris();
            if ((primflags & 0x10) == 0) {
                this.cacheGeometry(32, radius, radius, -height / 2.0f, xdivision, xdivision, primflags, gbuf);
            }
        }
        if ((this.flags & 0x40) != 0) {
            shape[2].setCapability(14);
            shape[2].setCapability(15);
        }
        if ((this.flags & 0x20) != 0) {
            shape[2].setCapability(12);
        }
        this.addChild(shape[2]);
        if (ap == null) {
            this.setAppearance();
        } else {
            this.setAppearance(ap);
        }
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        Cylinder c = new Cylinder(this.radius, this.height, this.flags, this.xdivisions, this.ydivisions, this.getAppearance());
        c.duplicateNode(this, forceDuplicate);
        return c;
    }

    @Override
    public void duplicateNode(Node originalNode, boolean forceDuplicate) {
        super.duplicateNode(originalNode, forceDuplicate);
    }

    public float getRadius() {
        return this.radius;
    }

    public float getHeight() {
        return this.height;
    }

    public int getXdivisions() {
        return this.xdivisions;
    }

    public int getYdivisions() {
        return this.ydivisions;
    }
}

