/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import org.scijava.java3d.ImageComponent;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SGIORuntimeException;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.NodeComponentState;

public abstract class ImageComponentState
extends NodeComponentState {
    protected int format;
    protected int height;
    protected int width;
    protected boolean byReference;
    protected boolean yUp;
    private static final int DIRECT_COLOR_MODEL = 1;
    private static final int SINGLE_PIXEL_PACKED_SAMPLE_MODEL = 1;
    private static final int DATA_BUFFER_INT = 1;
    public static final byte NO_COMPRESSION = 0;
    public static final byte GZIP_COMPRESSION = 1;
    public static final byte JPEG_COMPRESSION = 2;

    public ImageComponentState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    protected void writeConstructorParams(DataOutput out) throws IOException {
        super.writeConstructorParams(out);
        out.writeInt(((ImageComponent)this.node).getFormat());
        out.writeInt(((ImageComponent)this.node).getHeight());
        out.writeInt(((ImageComponent)this.node).getWidth());
        out.writeBoolean(((ImageComponent)this.node).isByReference());
        out.writeBoolean(((ImageComponent)this.node).isYUp());
    }

    @Override
    protected void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        this.format = in.readInt();
        this.height = in.readInt();
        this.width = in.readInt();
        this.byReference = in.readBoolean();
        this.yUp = in.readBoolean();
    }

    protected void writeBufferedImage(DataOutput out, BufferedImage image) throws IOException {
        int compressionType = this.control.getImageCompression();
        out.writeByte(compressionType);
        if (compressionType == 0) {
            this.writeBufferedImageNoCompression(out, image);
        } else if (compressionType == 1) {
            this.writeBufferedImageGzipCompression(out, image);
        } else if (compressionType == 2) {
            this.writeBufferedImageJpegCompression(out, image);
        }
    }

    private void writeBufferedImageNoCompression(DataOutput out, BufferedImage image) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(byteStream);
        ColorModel colorModel = image.getColorModel();
        if (colorModel instanceof ComponentColorModel) {
            int type;
            ComponentColorModel cm = (ComponentColorModel)colorModel;
            int numComponents = cm.getNumComponents();
            switch (numComponents) {
                case 3: {
                    type = 1;
                    break;
                }
                case 4: {
                    type = 2;
                    break;
                }
                default: {
                    throw new SGIORuntimeException("Unsupported ColorModel " + colorModel.getClass().getName());
                }
            }
            BufferedImage tmpBuf = new BufferedImage(image.getWidth(), image.getHeight(), type);
            WritableRaster dstRaster = tmpBuf.getRaster();
            WritableRaster srcRaster = image.getRaster();
            dstRaster.setRect(srcRaster);
            image = tmpBuf;
        }
        this.writeColorModel(dataOut, image.getColorModel());
        this.writeWritableRaster(dataOut, image.getRaster());
        dataOut.writeBoolean(image.isAlphaPremultiplied());
        dataOut.close();
        byte[] buffer = byteStream.toByteArray();
        out.writeInt(buffer.length);
        out.write(buffer);
    }

    private void writeBufferedImageGzipCompression(DataOutput out, BufferedImage image) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        GZIPOutputStream gzipStream = new GZIPOutputStream(byteStream);
        DataOutputStream dataOut = new DataOutputStream(gzipStream);
        this.writeColorModel(dataOut, image.getColorModel());
        this.writeWritableRaster(dataOut, image.getRaster());
        dataOut.writeBoolean(image.isAlphaPremultiplied());
        dataOut.flush();
        gzipStream.finish();
        byte[] buffer = byteStream.toByteArray();
        out.writeInt(buffer.length);
        out.write(buffer);
        dataOut.close();
    }

    private void writeBufferedImageJpegCompression(DataOutput out, BufferedImage image) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "jpeg", byteStream);
        byteStream.close();
        byte[] buffer = byteStream.toByteArray();
        out.writeInt(buffer.length);
        out.write(buffer);
    }

    protected BufferedImage readBufferedImage(DataInput in) throws IOException {
        byte compression = in.readByte();
        if (compression == 0) {
            return this.readBufferedImageNoCompression(in);
        }
        if (compression == 1) {
            return this.readBufferedImageGzipCompression(in);
        }
        if (compression == 2) {
            return this.readBufferedImageJpegCompression(in);
        }
        throw new SGIORuntimeException("Unknown Image Compression");
    }

    private BufferedImage readBufferedImageNoCompression(DataInput in) throws IOException {
        int size = in.readInt();
        byte[] buffer = new byte[size];
        in.readFully(buffer);
        ByteArrayInputStream byteIn = new ByteArrayInputStream(buffer);
        DataInputStream dataIn = new DataInputStream(byteIn);
        ColorModel colorModel = this.readColorModel(dataIn);
        WritableRaster raster = this.readWritableRaster(dataIn);
        boolean alphaPreMult = dataIn.readBoolean();
        dataIn.close();
        return new BufferedImage(colorModel, raster, alphaPreMult, null);
    }

    private BufferedImage readBufferedImageGzipCompression(DataInput in) throws IOException {
        int size = in.readInt();
        byte[] buffer = new byte[size];
        in.readFully(buffer);
        ByteArrayInputStream byteIn = new ByteArrayInputStream(buffer);
        GZIPInputStream gzipIn = new GZIPInputStream(byteIn);
        DataInputStream dataIn = new DataInputStream(gzipIn);
        ColorModel colorModel = this.readColorModel(dataIn);
        WritableRaster raster = this.readWritableRaster(dataIn);
        boolean alphaPremult = dataIn.readBoolean();
        dataIn.close();
        return new BufferedImage(colorModel, raster, alphaPremult, null);
    }

    private BufferedImage readBufferedImageJpegCompression(DataInput in) throws IOException {
        int size = in.readInt();
        byte[] buffer = new byte[size];
        in.readFully(buffer);
        ByteArrayInputStream byteStream = new ByteArrayInputStream(buffer);
        return ImageIO.read(byteStream);
    }

    private void writeColorModel(DataOutput out, ColorModel colorModel) throws IOException {
        if (!(colorModel instanceof DirectColorModel)) {
            throw new SGIORuntimeException("Unsupported ColorModel " + colorModel.getClass().getName());
        }
        out.writeInt(1);
        this.writeDirectColorModel(out, (DirectColorModel)colorModel);
    }

    private ColorModel readColorModel(DataInput in) throws IOException {
        switch (in.readInt()) {
            case 1: {
                return this.readDirectColorModel(in);
            }
        }
        throw new SGIORuntimeException("Invalid ColorModel - File corrupt");
    }

    private void writeDirectColorModel(DataOutput out, DirectColorModel colorModel) throws IOException {
        out.writeInt(colorModel.getPixelSize());
        out.writeInt(colorModel.getRedMask());
        out.writeInt(colorModel.getGreenMask());
        out.writeInt(colorModel.getBlueMask());
        out.writeInt(colorModel.getAlphaMask());
    }

    private DirectColorModel readDirectColorModel(DataInput in) throws IOException {
        return new DirectColorModel(in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt());
    }

    private void writeWritableRaster(DataOutput out, WritableRaster raster) throws IOException {
        this.writeSampleModel(out, raster.getSampleModel());
        this.writeDataBuffer(out, raster.getDataBuffer());
        Point origin = new Point();
        out.writeInt(origin.x);
        out.writeInt(origin.y);
    }

    private WritableRaster readWritableRaster(DataInput in) throws IOException {
        return Raster.createWritableRaster(this.readSampleModel(in), this.readDataBuffer(in), new Point(in.readInt(), in.readInt()));
    }

    private void writeSampleModel(DataOutput out, SampleModel model) throws IOException {
        if (!(model instanceof SinglePixelPackedSampleModel)) {
            throw new SGIORuntimeException("Unsupported SampleModel " + model.getClass().getName());
        }
        out.writeInt(1);
        this.writeSinglePixelPackedSampleModel(out, (SinglePixelPackedSampleModel)model);
    }

    private SampleModel readSampleModel(DataInput in) throws IOException {
        switch (in.readInt()) {
            case 1: {
                return this.readSinglePixelPackedSampleModel(in);
            }
        }
        throw new SGIORuntimeException("Invalid SampleModel - file corrupt");
    }

    private void writeSinglePixelPackedSampleModel(DataOutput out, SinglePixelPackedSampleModel model) throws IOException {
        int[] masks = model.getBitMasks();
        out.writeInt(masks.length);
        for (int i = 0; i < masks.length; ++i) {
            out.writeInt(masks[i]);
        }
        out.writeInt(model.getDataType());
        out.writeInt(model.getWidth());
        out.writeInt(model.getHeight());
        out.writeInt(model.getScanlineStride());
    }

    private SinglePixelPackedSampleModel readSinglePixelPackedSampleModel(DataInput in) throws IOException {
        int[] masks = new int[in.readInt()];
        for (int i = 0; i < masks.length; ++i) {
            masks[i] = in.readInt();
        }
        return new SinglePixelPackedSampleModel(in.readInt(), in.readInt(), in.readInt(), in.readInt(), masks);
    }

    private void writeDataBuffer(DataOutput out, DataBuffer buffer) throws IOException {
        if (!(buffer instanceof DataBufferInt)) {
            throw new SGIORuntimeException("Unsupported DataBuffer " + buffer.getClass().getName());
        }
        out.writeInt(1);
        this.writeDataBufferInt(out, (DataBufferInt)buffer);
    }

    private DataBuffer readDataBuffer(DataInput in) throws IOException {
        switch (in.readInt()) {
            case 1: {
                return this.readDataBufferInt(in);
            }
        }
        throw new SGIORuntimeException("Incorrect DataBuffer - file corrupt");
    }

    private void writeDataBufferInt(DataOutput out, DataBufferInt buffer) throws IOException {
        int[][] data = buffer.getBankData();
        out.writeInt(data.length);
        for (int i = 0; i < data.length; ++i) {
            out.writeInt(data[i].length);
            for (int j = 0; j < data[i].length; ++j) {
                out.writeInt(data[i][j]);
            }
        }
        out.writeInt(buffer.getSize());
    }

    private DataBufferInt readDataBufferInt(DataInput in) throws IOException {
        int[][] data = new int[in.readInt()][];
        for (int i = 0; i < data.length; ++i) {
            data[i] = new int[in.readInt()];
            for (int j = 0; j < data[i].length; ++j) {
                data[i][j] = in.readInt();
            }
        }
        return new DataBufferInt(data, in.readInt());
    }
}

