/*
 * Decompiled with CFR 0.152.
 */
package fiji.util.gui;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Collection;

public class OverlayedImageCanvas
extends ImageCanvas {
    private static final long serialVersionUID = -9005735333215207618L;
    protected Collection<Overlay> overlays = new ArrayList<Overlay>();
    private int backBufferWidth;
    private int backBufferHeight;
    private Graphics backBufferGraphics;
    private Image backBufferImage;
    protected Composite backBufferComposite;

    public OverlayedImageCanvas(ImagePlus image) {
        super(image);
    }

    public void addOverlay(Overlay overlay) {
        this.overlays.add(overlay);
    }

    public void addOverlay(Collection<Overlay> overlays) {
        overlays.addAll(overlays);
    }

    public void removeOverlay(Overlay overlay) {
        this.overlays.remove(overlay);
    }

    public void clearOverlay() {
        this.overlays.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (this.backBufferWidth != this.getSize().width || this.backBufferHeight != this.getSize().height || this.backBufferImage == null || this.backBufferGraphics == null) {
            this.resetBackBuffer();
        }
        Rectangle src = this.getSrcRect();
        OverlayedImageCanvas overlayedImageCanvas = this;
        synchronized (overlayedImageCanvas) {
            super.paint(this.backBufferGraphics);
            for (Overlay overlay : this.overlays) {
                overlay.paint(this.backBufferGraphics, src.x, src.y, this.magnification);
            }
            Roi roi = this.imp.getRoi();
            if (roi != null) {
                roi.draw(this.backBufferGraphics);
            }
        }
        g.drawImage(this.backBufferImage, 0, 0, (ImageObserver)((Object)this));
    }

    private void resetBackBuffer() {
        if (this.backBufferGraphics != null) {
            this.backBufferGraphics.dispose();
            this.backBufferGraphics = null;
        }
        if (this.backBufferImage != null) {
            this.backBufferImage.flush();
            this.backBufferImage = null;
        }
        this.backBufferWidth = this.getSize().width;
        this.backBufferHeight = this.getSize().height;
        this.backBufferImage = this.createImage(this.backBufferWidth, this.backBufferHeight);
        this.backBufferGraphics = this.backBufferImage.getGraphics();
    }

    public static interface Overlay {
        public void setComposite(Composite var1);

        public void paint(Graphics var1, int var2, int var3, double var4);
    }
}

